/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.git;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonClient;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonService;

public class Daemon {
    public static final int DEFAULT_PORT = 9418;
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final DaemonService[] services;
    private final ThreadGroup processors;
    private boolean run;
    private Thread acceptThread;
    private int timeout;
    private PackConfig packConfig;
    private volatile RepositoryResolver<DaemonClient> repositoryResolver;
    private volatile UploadPackFactory<DaemonClient> uploadPackFactory;
    private ServerSocket listenSock = null;

    public Daemon() {
        this(null);
    }

    public Daemon(InetSocketAddress addr) {
        this.myAddress = addr;
        this.processors = new ThreadGroup("Git-Daemon");
        this.repositoryResolver = RepositoryResolver.NONE;
        this.uploadPackFactory = new UploadPackFactory<DaemonClient>(){

            public UploadPack create(DaemonClient req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = new UploadPack(db);
                up.setTimeout(Daemon.this.getTimeout());
                up.setPackConfig(Daemon.this.getPackConfig());
                return up;
            }
        };
        this.services = new DaemonService[]{new DaemonService("upload-pack", "uploadpack"){
            {
                this.setEnabled(true);
            }

            @Override
            protected void execute(DaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = Daemon.this.uploadPackFactory.create((Object)dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                up.upload(in, out, null);
            }
        }};
    }

    public synchronized InetSocketAddress getAddress() {
        return this.myAddress;
    }

    public synchronized DaemonService getService(String name) {
        if (!name.startsWith("git-")) {
            name = "git-" + name;
        }
        for (DaemonService s : this.services) {
            if (!s.getCommandName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setRepositoryResolver(RepositoryResolver<DaemonClient> resolver) {
        this.repositoryResolver = resolver;
    }

    public void setUploadPackFactory(UploadPackFactory<DaemonClient> factory) {
        this.uploadPackFactory = factory != null ? factory : UploadPackFactory.DISABLED;
    }

    public synchronized void start() throws IOException {
        if (this.acceptThread != null) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        this.listenSock = new ServerSocket(this.myAddress != null ? this.myAddress.getPort() : 0, 5, this.myAddress != null ? this.myAddress.getAddress() : null);
        this.myAddress = (InetSocketAddress)this.listenSock.getLocalSocketAddress();
        this.run = true;
        this.acceptThread = new Thread(this.processors, "Git-Daemon-Accept"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (Daemon.this.isRunning()) {
                    try {
                        Daemon.this.startClient(Daemon.this.listenSock.accept());
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    if (!Daemon.this.listenSock.isClosed()) {
                        Daemon.this.listenSock.close();
                    }
                }
                catch (IOException iOException) {
                    Daemon daemon = Daemon.this;
                    synchronized (daemon) {
                        Daemon.this.acceptThread = null;
                    }
                }
                finally {
                    Daemon e = Daemon.this;
                    synchronized (e) {
                        Daemon.this.acceptThread = null;
                    }
                }
            }
        };
        this.acceptThread.start();
    }

    public synchronized boolean isRunning() {
        return this.run;
    }

    public synchronized void stop() {
        if (this.acceptThread != null) {
            this.run = false;
            try {
                this.listenSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.acceptThread.interrupt();
        }
    }

    private void startClient(final Socket s) {
        final DaemonClient dc = new DaemonClient(this);
        SocketAddress peer = s.getRemoteSocketAddress();
        if (peer instanceof InetSocketAddress) {
            dc.setRemoteAddress(((InetSocketAddress)peer).getAddress());
        }
        new Thread(this.processors, "Git-Daemon-Client " + peer.toString()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    dc.execute(s);
                }
                catch (ServiceNotEnabledException e) {
                }
                catch (ServiceNotAuthorizedException e) {
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException e) {}
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException e) {}
                }
            }
        }.start();
    }

    synchronized DaemonService matchService(String cmd) {
        for (DaemonService d : this.services) {
            if (!d.handles(cmd)) continue;
            return d;
        }
        return null;
    }

    Repository openRepository(DaemonClient client, String name) throws ServiceMayNotContinueException {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open((Object)client, name.substring(1));
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
        catch (ServiceNotAuthorizedException e) {
            return null;
        }
        catch (ServiceNotEnabledException e) {
            return null;
        }
    }
}

