/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.command.UnknownCommand;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitReceiveCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitUploadCommand;
import org.uberfire.java.nio.security.AuthorizationManager;
import org.uberfire.java.nio.security.Session;
import org.uberfire.java.nio.security.Subject;
import org.uberfire.java.nio.security.UserPassAuthenticator;

public class GitSSHService {
    final SshServer sshd = SshServer.setUpDefaultServer();
    private UserPassAuthenticator userPassAuthenticator;
    private AuthorizationManager authorizationManager;

    public void setup(File certDir, String host, int port, final UserPassAuthenticator userPassAuthenticator, final AuthorizationManager authorizationManager, final ReceivePackFactory receivePackFactory, final JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver) {
        this.userPassAuthenticator = userPassAuthenticator;
        this.authorizationManager = authorizationManager;
        this.sshd.getProperties().put("idle-timeout", "10000");
        this.sshd.setHost(host);
        this.sshd.setPort(port);
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File(certDir, "hostkey.ser").getAbsolutePath()));
        this.sshd.setCommandFactory(new CommandFactory(){

            public Command createCommand(String command) {
                if (command.startsWith("git-upload-pack")) {
                    return new GitUploadCommand(command, repositoryResolver, authorizationManager);
                }
                if (command.startsWith("git-receive-pack")) {
                    return new GitReceiveCommand(command, repositoryResolver, authorizationManager, (ReceivePackFactory<BaseGitCommand>)receivePackFactory);
                }
                return new UnknownCommand(command);
            }
        });
        this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, final ServerSession session) {
                return userPassAuthenticator.authenticate(username, password, new Session(){

                    public void setSubject(Subject value) {
                        session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)value);
                    }

                    public Subject getSubject() {
                        return (Subject)session.getAttribute(BaseGitCommand.SUBJECT_KEY);
                    }
                });
            }
        });
    }

    public void stop() {
        try {
            this.sshd.stop(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public UserPassAuthenticator getUserPassAuthenticator() {
        return this.userPassAuthenticator;
    }

    public void setUserPassAuthenticator(UserPassAuthenticator userPassAuthenticator) {
        this.userPassAuthenticator = userPassAuthenticator;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }
}

