/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.junit.Test;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

public class JGitFileSystemProviderGCTest
extends AbstractTestInfra {
    @Test
    public void testGC() throws IOException {
        URI newRepo = URI.create("git://gc-repo-name");
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(newRepo), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(0);
        try {
            this.provider.newFileSystem(newRepo, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(FileSystemAlreadyExistsException.class);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i = 0; i < 19; ++i) {
            Assertions.assertThat((int)fs.getNumberOfCommitsSinceLastGC()).isEqualTo(i);
            Path path = this.provider.getPath(URI.create("git://gc-repo-name/path/to/myfile" + i + ".txt"));
            OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
            Assertions.assertThat((Object)outStream).isNotNull();
            outStream.write(("my cool" + i + " content").getBytes());
            outStream.close();
        }
        Path path = this.provider.getPath(URI.create("git://gc-repo-name/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        Assertions.assertThat((int)fs.getNumberOfCommitsSinceLastGC()).isEqualTo(0);
        OutputStream outStream2 = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream2).isNotNull();
        outStream2.write("my co dwf sdf ol content".getBytes());
        outStream2.close();
        Assertions.assertThat((int)fs.getNumberOfCommitsSinceLastGC()).isEqualTo(1);
    }
}

