/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_POSIX_Java6;
import org.eclipse.jgit.util.Hook;
import org.eclipse.jgit.util.ProcessResult;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.StringAssert;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

public class JGitFileSystemProviderHookTest
extends AbstractTestInfra {
    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "true");
        int gitDaemonPort = JGitFileSystemProviderHookTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.daemon.port", String.valueOf(gitDaemonPort));
        try {
            File hooksDir = JGitFileSystemProviderHookTest.createTempDirectory();
            gitPrefs.put("org.uberfire.nio.git.hooks", hooksDir.getAbsolutePath());
            this.writeMockHook(hooksDir, Hook.POST_COMMIT.getName());
            this.writeMockHook(hooksDir, Hook.PRE_COMMIT.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return gitPrefs;
    }

    @Test
    public void testInstalledHook() {
        URI newRepo = URI.create("git://hook-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        if (fs instanceof JGitFileSystem) {
            Object[] hooks = new File(((JGitFileSystem)fs).gitRepo().getRepository().getDirectory(), "hooks").listFiles();
            Assertions.assertThat((Object[])hooks).isNotEmpty().isNotNull();
            Assertions.assertThat((int)hooks.length).isEqualTo(2);
            boolean foundPreCommitHook = false;
            boolean foundPostCommitHook = false;
            for (Object hook : hooks) {
                if (((File)hook).getName().equals(Hook.PRE_COMMIT.getName())) {
                    foundPreCommitHook = ((File)hook).canExecute();
                    continue;
                }
                if (!((File)hook).getName().equals(Hook.POST_COMMIT.getName())) continue;
                foundPostCommitHook = ((File)hook).canExecute();
            }
            Assertions.assertThat((boolean)foundPreCommitHook).isTrue();
            Assertions.assertThat((boolean)foundPostCommitHook).isTrue();
        }
    }

    @Test
    public void testExecutedPostCommitHook() throws IOException {
        this.testHook("hook-repo-name-executed", Hook.POST_COMMIT, true);
    }

    @Test
    public void testNotSupportedPreCommitHook() throws IOException {
        this.testHook("hook-repo-name-executed-pre-commit", Hook.PRE_COMMIT, false);
    }

    private void testHook(String gitRepoName, final Hook testedHook, boolean wasExecuted) throws IOException {
        URI newRepo = URI.create("git://" + gitRepoName);
        final AtomicBoolean hookExecuted = new AtomicBoolean(false);
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        this.provider.setDetectedFS((FS)new FS_POSIX_Java6(){

            public ProcessResult runIfPresent(Repository repox, Hook hook, String[] args) throws JGitInternalException {
                if (hook.equals((Object)testedHook)) {
                    hookExecuted.set(true);
                }
                return null;
            }
        });
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://user_branch@" + gitRepoName + "/some/path/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        InputStream inStream = this.provider.newInputStream(path, new OpenOption[0]);
        String content = new Scanner(inStream).useDelimiter("\\A").next();
        inStream.close();
        ((StringAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"my cool content");
        if (wasExecuted) {
            Assertions.assertThat((boolean)hookExecuted.get()).isTrue();
        } else {
            Assertions.assertThat((boolean)hookExecuted.get()).isFalse();
        }
    }

    private void writeMockHook(File hooksDirectory, String hookName) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter writer = new PrintWriter(new File(hooksDirectory, hookName), "UTF-8");
        writer.println("# something");
        writer.close();
    }
}

