/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.jgit.api.Git;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FileAssert;
import org.fest.assertions.api.IterableAssert;
import org.fest.assertions.api.MapAssert;
import org.fest.assertions.api.StringAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.NotImplementedException;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.JGitVersionAttributeView;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class JGitFileSystemProviderTest
extends AbstractTestInfra {
    private int gitDaemonPort;

    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "true");
        this.gitDaemonPort = JGitFileSystemProviderTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.daemon.port", String.valueOf(this.gitDaemonPort));
        return gitPrefs;
    }

    @Test
    @Ignore
    public void testDaemob() throws InterruptedException {
        URI newRepo = URI.create("git://repo-name");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        WatchService ws = null;
        ws = fs.newWatchService();
        Path path = (Path)fs.getRootDirectories().iterator().next();
        path.register(ws, new WatchEvent.Kind[]{StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_MODIFY, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_RENAME});
        WatchKey k = ws.take();
        List events = k.pollEvents();
        for (WatchEvent object : events) {
            if (object.kind() == StandardWatchEventKind.ENTRY_MODIFY) {
                System.out.println("Modify: " + object.context().toString());
            }
            if (object.kind() == StandardWatchEventKind.ENTRY_RENAME) {
                System.out.println("Rename: " + object.context().toString());
            }
            if (object.kind() == StandardWatchEventKind.ENTRY_DELETE) {
                System.out.println("Delete: " + object.context().toString());
            }
            if (object.kind() != StandardWatchEventKind.ENTRY_CREATE) continue;
            System.out.println("Created: " + object.context().toString());
        }
    }

    @Test
    public void testNewFileSystem() {
        URI newRepo = URI.create("git://repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(newRepo), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(0);
        try {
            this.provider.newFileSystem(newRepo, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(FileSystemAlreadyExistsException.class);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.provider.newFileSystem(URI.create("git://repo-name2"), EMPTY_ENV);
    }

    @Test
    public void testNewFileSystemInited() {
        URI newRepo = URI.create("git://init-repo-name");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(newRepo), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(1);
    }

    @Test
    public void testInvalidURINewFileSystem() {
        URI newRepo = URI.create("git:///repo-name");
        try {
            this.provider.newFileSystem(newRepo, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Parameter named 'uri' is invalid, missing host repository!");
        }
    }

    @Test
    public void testNewFileSystemClone() throws java.io.IOException {
        URI originRepo = URI.create("git://my-simple-test-origin-name");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, (Map)new HashMap<String, Object>(){
            {
                this.put("listMode", "ALL");
            }
        });
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitFileSystemProviderTest.this.tempFile("temp"));
            }
        });
        URI newRepo = URI.create("git://my-repo-name");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", "git://localhost:" + JGitFileSystemProviderTest.this.gitDaemonPort + "/my-simple-test-origin-name");
                this.put("listMode", "ALL");
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(2);
        ((FileAssert)Assertions.assertThat((File)fs.getPath("file.txt", new String[0]).toFile()).isNotNull()).exists();
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("fileXXXXX.txt", JGitFileSystemProviderTest.this.tempFile("temp"));
            }
        });
        this.provider.getFileSystem(URI.create("git://my-repo-name?sync=git://localhost:" + this.gitDaemonPort + "/my-simple-test-origin-name&force"));
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(3);
        for (Path root : fs.getRootDirectories()) {
            if (root.toAbsolutePath().toUri().toString().contains("upstream")) {
                ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).isNotEmpty()).hasSize(2);
                continue;
            }
            if (root.toAbsolutePath().toUri().toString().contains("origin")) {
                ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).isNotEmpty()).hasSize(1);
                continue;
            }
            ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).isNotEmpty()).hasSize(2);
        }
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("fileYYYY.txt", JGitFileSystemProviderTest.this.tempFile("tempYYYY"));
            }
        });
        this.provider.getFileSystem(URI.create("git://my-repo-name?sync=git://localhost:" + this.gitDaemonPort + "/my-simple-test-origin-name&force"));
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(3);
        for (Path root : fs.getRootDirectories()) {
            if (root.toAbsolutePath().toUri().toString().contains("upstream")) {
                ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).isNotEmpty()).hasSize(3);
                continue;
            }
            if (root.toAbsolutePath().toUri().toString().contains("origin")) {
                ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).isNotEmpty()).hasSize(1);
                continue;
            }
            ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).isNotEmpty()).hasSize(3);
        }
    }

    @Test
    public void testNewFileSystemCloneAndPush() throws java.io.IOException {
        URI originRepo = URI.create("git://my-simple-test-origin-repo");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, (Map)new HashMap<String, Object>(){
            {
                this.put("listMode", "ALL");
            }
        });
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitFileSystemProviderTest.this.tempFile("temp"));
            }
        });
        URI newRepo = URI.create("git://my-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", "git://localhost:" + JGitFileSystemProviderTest.this.gitDaemonPort + "/my-simple-test-origin-repo");
                this.put("listMode", "ALL");
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(2);
        ((FileAssert)Assertions.assertThat((File)fs.getPath("file.txt", new String[0]).toFile()).isNotNull()).exists();
        JGitUtil.commit((Git)((JGitFileSystem)fs).gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("fileXXXXX.txt", JGitFileSystemProviderTest.this.tempFile("temp"));
            }
        });
        URI newRepo2 = URI.create("git://my-repo2");
        HashMap<String, Object> env2 = new HashMap<String, Object>(){
            {
                this.put("origin", "git://localhost:" + JGitFileSystemProviderTest.this.gitDaemonPort + "/my-simple-test-origin-repo");
                this.put("listMode", "ALL");
            }
        };
        FileSystem fs2 = this.provider.newFileSystem(newRepo2, (Map)env2);
        JGitUtil.commit((Git)origin.gitRepo(), (String)"user-branch", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1UserBranch.txt", JGitFileSystemProviderTest.this.tempFile("tempX"));
            }
        });
        this.provider.getFileSystem(URI.create("git://my-repo2?sync=git://localhost:" + this.gitDaemonPort + "/my-simple-test-origin-repo&force"));
        Assertions.assertThat((Iterable)fs2.getRootDirectories()).hasSize(5);
        ArrayList<String> rootURIs1 = new ArrayList<String>(){
            {
                this.add("git://master@my-repo2/");
                this.add("git://user-branch@my-repo2/");
                this.add("git://origin/master@my-repo2/");
                this.add("git://upstream/master@my-repo2/");
                this.add("git://upstream/user-branch@my-repo2/");
            }
        };
        ArrayList<String> rootURIs2 = new ArrayList<String>(){
            {
                this.add("git://master@my-repo2/");
                this.add("git://user-branch@my-repo2/");
                this.add("git://user-branch-2@my-repo2/");
                this.add("git://origin/master@my-repo2/");
                this.add("git://upstream/master@my-repo2/");
                this.add("git://upstream/user-branch@my-repo2/");
                this.add("git://upstream/user-branch-2@my-repo2/");
            }
        };
        HashSet<String> rootURIs = new HashSet<String>();
        for (Path root : fs2.getRootDirectories()) {
            rootURIs.add(root.toUri().toString());
        }
        rootURIs.removeAll(rootURIs1);
        Assertions.assertThat(rootURIs).isEmpty();
        JGitUtil.commit((Git)origin.gitRepo(), (String)"user-branch-2", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file2UserBranch.txt", JGitFileSystemProviderTest.this.tempFile("tempX"));
            }
        });
        this.provider.getFileSystem(URI.create("git://my-repo2?sync=git://localhost:" + this.gitDaemonPort + "/my-simple-test-origin-repo&force"));
        Assertions.assertThat((Iterable)fs2.getRootDirectories()).hasSize(7);
        for (Path root : fs2.getRootDirectories()) {
            rootURIs.add(root.toUri().toString());
        }
        rootURIs.removeAll(rootURIs2);
        Assertions.assertThat(rootURIs).isEmpty();
    }

    @Test
    public void testGetFileSystem() {
        URI newRepo = URI.create("git://new-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Object)this.provider.getFileSystem(newRepo)).isEqualTo((Object)fs);
        Assertions.assertThat((Object)this.provider.getFileSystem(URI.create("git://master@new-repo-name"))).isEqualTo((Object)fs);
        Assertions.assertThat((Object)this.provider.getFileSystem(URI.create("git://branch@new-repo-name"))).isEqualTo((Object)fs);
        Assertions.assertThat((Object)this.provider.getFileSystem(URI.create("git://branch@new-repo-name?fetch"))).isEqualTo((Object)fs);
    }

    @Test
    public void testInvalidURIGetFileSystem() {
        URI newRepo = URI.create("git:///new-repo-name");
        try {
            this.provider.getFileSystem(newRepo);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Parameter named 'uri' is invalid, missing host repository!");
        }
    }

    @Test
    public void testGetPath() {
        URI newRepo = URI.create("git://new-get-repo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@new-get-repo-name/home"));
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.getRoot().toRealPath(new LinkOption[0]).toUri().toString()).isEqualTo((Object)"git://master@new-get-repo-name/");
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/home");
        Path pathRelative = this.provider.getPath(URI.create("git://master@new-get-repo-name/:home"));
        Assertions.assertThat((Iterable)pathRelative).isNotNull();
        Assertions.assertThat((String)pathRelative.toRealPath(new LinkOption[0]).toUri().toString()).isEqualTo((Object)"git://master@new-get-repo-name/:home");
        Assertions.assertThat((String)pathRelative.getRoot().toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)pathRelative.toString()).isEqualTo((Object)"home");
    }

    @Test
    public void testInvalidURIGetPath() {
        URI uri = URI.create("git:///master@new-get-repo-name/home");
        try {
            this.provider.getPath(uri);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Parameter named 'uri' is invalid, missing host repository!");
        }
    }

    @Test
    public void testGetComplexPath() {
        URI newRepo = URI.create("git://new-complex-get-repo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://origin/master@new-complex-get-repo-name/home"));
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/home");
        Path pathRelative = this.provider.getPath(URI.create("git://origin/master@new-complex-get-repo-name/:home"));
        Assertions.assertThat((Iterable)pathRelative).isNotNull();
        Assertions.assertThat((String)pathRelative.getRoot().toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)pathRelative.toString()).isEqualTo((Object)"home");
    }

    @Test
    public void testInputStream() throws java.io.IOException {
        File parentFolder = JGitFileSystemProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"user", (String)"user@example.com", (String)"commit message", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("myfile.txt", JGitFileSystemProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        });
        URI newRepo = URI.create("git://inputstream-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://origin/master@inputstream-test-repo/myfile.txt"));
        InputStream inputStream = this.provider.newInputStream(path, new OpenOption[0]);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
        String content = new Scanner(inputStream).useDelimiter("\\A").next();
        inputStream.close();
        ((StringAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"temp\n.origin\n.content");
    }

    @Test
    public void testInputStream2() throws java.io.IOException {
        File parentFolder = JGitFileSystemProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"user", (String)"user@example.com", (String)"commit message", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file/myfile.txt", JGitFileSystemProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        });
        URI newRepo = URI.create("git://xinputstream-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://origin/master@xinputstream-test-repo/path/to/file/myfile.txt"));
        InputStream inputStream = this.provider.newInputStream(path, new OpenOption[0]);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
        String content = new Scanner(inputStream).useDelimiter("\\A").next();
        inputStream.close();
        ((StringAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"temp\n.origin\n.content");
    }

    @Test(expected=NoSuchFileException.class)
    public void testInputStream3() throws java.io.IOException {
        File parentFolder = JGitFileSystemProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"user", (String)"user@example.com", (String)"commit message", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file/myfile.txt", JGitFileSystemProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        });
        URI newRepo = URI.create("git://xxinputstream-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://origin/master@xxinputstream-test-repo/path/to"));
        this.provider.newInputStream(path, new OpenOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void testInputStreamNoSuchFile() throws java.io.IOException {
        File parentFolder = JGitFileSystemProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitFileSystemProviderTest.this.tempFile("temp.origin.content.2"));
            }
        });
        URI newRepo = URI.create("git://inputstream-not-exists-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://origin/master@inputstream-not-exists-test-repo/temp.txt"));
        this.provider.newInputStream(path, new OpenOption[0]);
    }

    @Test
    public void testNewOutputStream() throws Exception {
        File parentFolder = JGitFileSystemProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"user", (String)"user@example.com", (String)"commit message", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("myfile.txt", JGitFileSystemProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"user_branch", (String)"user", (String)"user@example.com", (String)"commit message", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/some/file/myfile.txt", JGitFileSystemProviderTest.this.tempFile("some\n.content\nhere"));
            }
        });
        URI newRepo = URI.create("git://outstream-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://user_branch@outstream-test-repo/some/path/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        InputStream inStream = this.provider.newInputStream(path, new OpenOption[0]);
        String content = new Scanner(inStream).useDelimiter("\\A").next();
        inStream.close();
        ((StringAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"my cool content");
        try {
            this.provider.newOutputStream(this.provider.getPath(URI.create("git://user_branch@outstream-test-repo/some/path/")), new OpenOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IOException.class);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testNewOutputStreamWithJGitOp() throws Exception {
        File parentFolder = JGitFileSystemProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"user", (String)"user@example.com", (String)"commit message", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("myfile.txt", JGitFileSystemProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"user_branch", (String)"user", (String)"user@example.com", (String)"commit message", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/some/file/myfile.txt", JGitFileSystemProviderTest.this.tempFile("some\n.content\nhere"));
            }
        });
        URI newRepo = URI.create("git://outstreamwithop-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        CommentedOption op = new CommentedOption("User Tester", "user.tester@example.com", "omg, is it the end?", formatter.parse("31/12/2012"));
        Path path = this.provider.getPath(URI.create("git://user_branch@outstreamwithop-test-repo/some/path/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[]{op});
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        InputStream inStream = this.provider.newInputStream(path, new OpenOption[0]);
        String content = new Scanner(inStream).useDelimiter("\\A").next();
        inStream.close();
        ((StringAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"my cool content");
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void testGetPathFileSystemNotExisting() {
        this.provider.getPath(URI.create("git://master@not-exists-get-repo-name/home"));
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void testGetFileSystemNotExisting() {
        URI newRepo = URI.create("git://not-new-repo-name");
        this.provider.getFileSystem(newRepo);
    }

    @Test
    public void testDelete() throws java.io.IOException {
        URI newRepo = URI.create("git://delete1-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@delete1-test-repo/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.newInputStream(path, new OpenOption[0]).close();
        try {
            this.provider.delete(this.provider.getPath(URI.create("git://user_branch@delete1-test-repo/non_existent_path")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException ex) {
            // empty catch block
        }
        try {
            this.provider.delete(this.provider.getPath(URI.create("git://user_branch@delete1-test-repo/path/to/")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(DirectoryNotEmptyException.class);
        }
        catch (DirectoryNotEmptyException ex) {
            // empty catch block
        }
        this.provider.delete(path, new DeleteOption[0]);
        try {
            this.provider.newFileSystem(newRepo, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(FileSystemAlreadyExistsException.class);
        }
        catch (FileSystemAlreadyExistsException e) {
            // empty catch block
        }
        Path fsPath = path.getFileSystem().getPath(null, new String[0]);
        this.provider.delete(fsPath, new DeleteOption[0]);
        Assertions.assertThat((boolean)fsPath.getFileSystem().isOpen()).isEqualTo(false);
        URI newRepo2 = URI.create("git://delete1-test-repo");
        this.provider.newFileSystem(newRepo2, EMPTY_ENV);
    }

    @Test
    public void testDeleteBranch() throws java.io.IOException {
        URI newRepo = URI.create("git://delete-branch-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@delete-branch-test-repo/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.newInputStream(path, new OpenOption[0]).close();
        this.provider.delete(this.provider.getPath(URI.create("git://user_branch@delete-branch-test-repo")), new DeleteOption[0]);
        try {
            this.provider.delete(this.provider.getPath(URI.create("git://user_branch@delete-branch-test-repo")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException ex) {
            // empty catch block
        }
        try {
            this.provider.delete(this.provider.getPath(URI.create("git://some_user_branch@delete-branch-test-repo")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException ex) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteIfExists() throws java.io.IOException {
        URI newRepo = URI.create("git://deleteifexists1-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@deleteifexists1-test-repo/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.newInputStream(path, new OpenOption[0]).close();
        Assertions.assertThat((boolean)this.provider.deleteIfExists(this.provider.getPath(URI.create("git://user_branch@deleteifexists1-test-repo/non_existent_path")), new DeleteOption[0])).isFalse();
        try {
            this.provider.deleteIfExists(this.provider.getPath(URI.create("git://user_branch@deleteifexists1-test-repo/path/to/")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(DirectoryNotEmptyException.class);
        }
        catch (DirectoryNotEmptyException ex) {
            // empty catch block
        }
        Assertions.assertThat((boolean)this.provider.deleteIfExists(path, new DeleteOption[0])).isTrue();
    }

    @Test
    public void testDeleteBranchIfExists() throws java.io.IOException {
        URI newRepo = URI.create("git://deletebranchifexists1-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@deletebranchifexists1-test-repo/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.newInputStream(path, new OpenOption[0]).close();
        Assertions.assertThat((boolean)this.provider.deleteIfExists(this.provider.getPath(URI.create("git://user_branch@deletebranchifexists1-test-repo")), new DeleteOption[0])).isTrue();
        Assertions.assertThat((boolean)this.provider.deleteIfExists(this.provider.getPath(URI.create("git://not_user_branch@deletebranchifexists1-test-repo")), new DeleteOption[0])).isFalse();
        Assertions.assertThat((boolean)this.provider.deleteIfExists(this.provider.getPath(URI.create("git://user_branch@deletebranchifexists1-test-repo")), new DeleteOption[0])).isFalse();
    }

    @Test
    public void testIsHidden() throws java.io.IOException {
        URI newRepo = URI.create("git://ishidden-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/.myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/myfile.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        Assertions.assertThat((Object)outStream2).isNotNull();
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/.myfile.txt")))).isTrue();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/myfile.txt")))).isFalse();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/non_existent/.myfile.txt")))).isTrue();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/non_existent/myfile.txt")))).isFalse();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/")))).isFalse();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/some")))).isFalse();
    }

    @Test
    public void testIsSameFile() throws java.io.IOException {
        URI newRepo = URI.create("git://issamefile-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@issamefile-test-repo/path/to/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@issamefile-test-repo/path/to/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@issamefile-test-repo/path/to/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Assertions.assertThat((boolean)this.provider.isSameFile(path, path2)).isTrue();
        Assertions.assertThat((boolean)this.provider.isSameFile(path, path3)).isTrue();
    }

    @Test
    public void testCreateDirectory() throws Exception {
        URI newRepo = URI.create("git://xcreatedir-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        JGitPathImpl path = (JGitPathImpl)this.provider.getPath(URI.create("git://master@xcreatedir-test-repo/some/path/to/"));
        Pair result = JGitUtil.checkPath((Git)((JGitFileSystem)path.getFileSystem()).gitRepo(), (String)path.getRefTree(), (String)path.getPath());
        Assertions.assertThat((Object)result.getK1()).isEqualTo((Object)JGitUtil.PathType.NOT_FOUND);
        this.provider.createDirectory((Path)path, new FileAttribute[0]);
        Pair resultAfter = JGitUtil.checkPath((Git)((JGitFileSystem)path.getFileSystem()).gitRepo(), (String)path.getRefTree(), (String)path.getPath());
        Assertions.assertThat((Object)resultAfter.getK1()).isEqualTo((Object)JGitUtil.PathType.DIRECTORY);
        try {
            this.provider.createDirectory((Path)path, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(FileAlreadyExistsException.class);
        }
        catch (FileAlreadyExistsException e) {
            // empty catch block
        }
    }

    @Test
    public void testCheckAccess() throws Exception {
        URI newRepo = URI.create("git://checkaccess-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@checkaccess-test-repo/path/to/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.checkAccess(path, new AccessMode[0]);
        Path path_to_dir = this.provider.getPath(URI.create("git://master@checkaccess-test-repo/path/to"));
        this.provider.checkAccess(path_to_dir, new AccessMode[0]);
        Path path_not_exists = this.provider.getPath(URI.create("git://master@checkaccess-test-repo/path/to/some.txt"));
        try {
            this.provider.checkAccess(path_not_exists, new AccessMode[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException e) {
            // empty catch block
        }
    }

    @Test
    public void testGetFileStore() throws Exception {
        URI newRepo = URI.create("git://filestore-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@filestore-test-repo/path/to/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        FileStore fileStore = this.provider.getFileStore(path);
        Assertions.assertThat((Object)fileStore).isNotNull();
        Assertions.assertThat((Object)fileStore.getAttribute("readOnly")).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void testNewDirectoryStream() throws java.io.IOException {
        URI newRepo = URI.create("git://dirstream-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@dirstream-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        DirectoryStream stream1 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/")), null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream1).isNotNull()).hasSize(2)).contains((Object[])new Path[]{path3, this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other"))});
        DirectoryStream stream2 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other")), null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream2).isNotNull()).hasSize(1)).contains((Object[])new Path[]{this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other/path"))});
        DirectoryStream stream3 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other/path")), null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream3).isNotNull()).hasSize(1)).contains((Object[])new Path[]{path2});
        DirectoryStream stream4 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://master@dirstream-test-repo/")), null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream4).isNotNull()).hasSize(1)).contains((Object[])new Path[]{path});
        try {
            this.provider.newDirectoryStream(path, null);
            Assertions.failBecauseExceptionWasNotThrown(NotDirectoryException.class);
        }
        catch (NotDirectoryException ex) {
            // empty catch block
        }
        Path crazyPath = this.provider.getPath(URI.create("git://master@dirstream-test-repo/crazy/path/here"));
        try {
            this.provider.newDirectoryStream(crazyPath, null);
            Assertions.failBecauseExceptionWasNotThrown(NotDirectoryException.class);
        }
        catch (NotDirectoryException ex) {
            // empty catch block
        }
        this.provider.createDirectory(crazyPath, new FileAttribute[0]);
        ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream(crazyPath, null)).isNotNull()).hasSize(1);
    }

    @Test
    public void testDeleteNonEmptyDirectory() throws java.io.IOException {
        URI newRepo = URI.create("git://delete-non-empty-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path dir = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path"));
        Path _root = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/myfile1.txt"));
        OutputStream outRootStream = this.provider.newOutputStream(_root, new OpenOption[0]);
        outRootStream.write("my cool content".getBytes());
        outRootStream.close();
        Path path = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path dir1 = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path/dir"));
        this.provider.createDirectory(dir1, new FileAttribute[0]);
        DirectoryStream stream3 = this.provider.newDirectoryStream(dir, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream3).isNotNull()).hasSize(4);
        try {
            this.provider.delete(dir, new DeleteOption[0]);
            Assertions.fail((String)"dir not empty");
        }
        catch (DirectoryNotEmptyException ignore) {
            // empty catch block
        }
        try {
            CommentedOption op = new CommentedOption("User Tester", "user.tester@example.com", "omg, erase dir!");
            this.provider.delete(dir, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES, op});
        }
        catch (DirectoryNotEmptyException ignore) {
            Assertions.fail((String)"dir should be deleted!");
        }
        Assertions.assertThat((boolean)this.provider.exists(dir)).isEqualTo(false);
    }

    @Test
    public void testFilteredNewDirectoryStream() throws java.io.IOException {
        URI newRepo = URI.create("git://filter-dirstream-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@filter-dirstream-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@filter-dirstream-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@filter-dirstream-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path path4 = this.provider.getPath(URI.create("git://user_branch@filter-dirstream-test-repo/myfile4.xxx"));
        OutputStream outStream4 = this.provider.newOutputStream(path4, new OpenOption[0]);
        outStream4.write("my cool content".getBytes());
        outStream4.close();
        DirectoryStream stream1 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@filter-dirstream-test-repo/")), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return entry.toString().endsWith(".xxx");
            }
        });
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream1).isNotNull()).hasSize(1)).contains((Object[])new Path[]{path4});
        DirectoryStream stream2 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://master@filter-dirstream-test-repo/")), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return false;
            }
        });
        ((IterableAssert)Assertions.assertThat((Iterable)stream2).isNotNull()).hasSize(0);
    }

    @Test
    public void testGetFileAttributeView() throws java.io.IOException {
        URI newRepo = URI.create("git://getfileattriview-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@getfileattriview-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@getfileattriview-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@getfileattriview-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        JGitVersionAttributeView attrs = (JGitVersionAttributeView)this.provider.getFileAttributeView(path3, JGitVersionAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((int)attrs.readAttributes().history().records().size()).isEqualTo(1);
        Assertions.assertThat((String)((VersionRecord)attrs.readAttributes().history().records().get(0)).uri()).isNotNull();
        Assertions.assertThat((boolean)attrs.readAttributes().isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.readAttributes().isRegularFile()).isTrue();
        Assertions.assertThat((Object)attrs.readAttributes().creationTime()).isNotNull();
        Assertions.assertThat((Object)attrs.readAttributes().lastModifiedTime()).isNotNull();
        Assertions.assertThat((long)attrs.readAttributes().size()).isEqualTo(15L);
        try {
            this.provider.getFileAttributeView(this.provider.getPath(URI.create("git://user_branch@getfileattriview-test-repo/not_exists.txt")), BasicFileAttributeView.class, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        Assertions.assertThat((Object)this.provider.getFileAttributeView(path3, MyInvalidFileAttributeView.class, new LinkOption[0])).isNull();
        Path rootPath = this.provider.getPath(URI.create("git://user_branch@getfileattriview-test-repo/"));
        BasicFileAttributeView attrsRoot = (BasicFileAttributeView)this.provider.getFileAttributeView(rootPath, BasicFileAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((boolean)attrsRoot.readAttributes().isDirectory()).isTrue();
        Assertions.assertThat((boolean)attrsRoot.readAttributes().isRegularFile()).isFalse();
        Assertions.assertThat((Object)attrsRoot.readAttributes().creationTime()).isNotNull();
        Assertions.assertThat((Object)attrsRoot.readAttributes().lastModifiedTime()).isNotNull();
        Assertions.assertThat((long)attrsRoot.readAttributes().size()).isEqualTo(-1L);
    }

    @Test
    public void testReadAttributes() throws java.io.IOException {
        URI newRepo = URI.create("git://readattrs-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@readattrs-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@readattrs-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@readattrs-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        BasicFileAttributes attrs = this.provider.readAttributes(path3, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((boolean)attrs.isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.isRegularFile()).isTrue();
        Assertions.assertThat((Object)attrs.creationTime()).isNotNull();
        Assertions.assertThat((Object)attrs.lastModifiedTime()).isNotNull();
        Assertions.assertThat((long)attrs.size()).isEqualTo(15L);
        try {
            this.provider.readAttributes(this.provider.getPath(URI.create("git://user_branch@readattrs-test-repo/not_exists.txt")), BasicFileAttributes.class, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException e) {
            // empty catch block
        }
        Assertions.assertThat((Object)this.provider.readAttributes(path3, MyAttrs.class, new LinkOption[0])).isNull();
        Path rootPath = this.provider.getPath(URI.create("git://user_branch@readattrs-test-repo/"));
        BasicFileAttributes attrsRoot = this.provider.readAttributes(rootPath, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((boolean)attrsRoot.isDirectory()).isTrue();
        Assertions.assertThat((boolean)attrsRoot.isRegularFile()).isFalse();
        Assertions.assertThat((Object)attrsRoot.creationTime()).isNotNull();
        Assertions.assertThat((Object)attrsRoot.lastModifiedTime()).isNotNull();
        Assertions.assertThat((long)attrsRoot.size()).isEqualTo(-1L);
    }

    @Test
    public void testReadAttributesMap() throws java.io.IOException {
        URI newRepo = URI.create("git://readattrsmap-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@readattrsmap-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@readattrsmap-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@readattrsmap-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "version:version", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        try {
            this.provider.readAttributes(path, ":someThing", new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            this.provider.readAttributes(path, "advanced:isRegularFile", new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        Path rootPath = this.provider.getPath(URI.create("git://user_branch@readattrsmap-test-repo/"));
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        try {
            this.provider.readAttributes(rootPath, ":someThing", new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            this.provider.readAttributes(rootPath, "advanced:isRegularFile", new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        try {
            this.provider.readAttributes(this.provider.getPath(URI.create("git://user_branch@readattrsmap-test-repo/not_exists.txt")), BasicFileAttributes.class, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException e) {
            // empty catch block
        }
    }

    @Test
    public void testSetAttribute() throws java.io.IOException {
        URI newRepo = URI.create("git://setattr-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@setattr-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@setattr-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@setattr-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        try {
            this.provider.setAttribute(path3, "basic:isRegularFile", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NotImplementedException.class);
        }
        catch (NotImplementedException ex) {
            // empty catch block
        }
        try {
            this.provider.setAttribute(path3, "isRegularFile", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NotImplementedException.class);
        }
        catch (NotImplementedException ex) {
            // empty catch block
        }
        try {
            this.provider.setAttribute(path3, "notExisits", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IllegalStateException.class);
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            this.provider.setAttribute(path3, "advanced:notExisits", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        try {
            this.provider.setAttribute(path3, ":isRegularFile", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    private static interface MyAttrs
    extends BasicFileAttributes {
    }

    private static class MyInvalidFileAttributeView
    implements BasicFileAttributeView {
        private MyInvalidFileAttributeView() {
        }

        public BasicFileAttributes readAttributes() throws IOException {
            return null;
        }

        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        }

        public String name() {
            return null;
        }
    }
}

