/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DisposableExecutor;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.lifecycle.Disposable;
import org.uberfire.commons.message.MessageType;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.EncodingUtil;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.ExtendedAttributeView;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.base.SeekableByteChannelFileBasedImpl;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.dotfiles.DotFileOption;
import org.uberfire.java.nio.base.dotfiles.DotFileUtils;
import org.uberfire.java.nio.base.options.CherryPickCopyOption;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.options.SquashOption;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.channels.AsynchronousFileChannel;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AccessDeniedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.attribute.AttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.fs.jgit.CommitInfo;
import org.uberfire.java.nio.fs.jgit.JGitBasicAttributeView;
import org.uberfire.java.nio.fs.jgit.JGitFSPath;
import org.uberfire.java.nio.fs.jgit.JGitFileStore;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.JGitVersionAttributeView;
import org.uberfire.java.nio.fs.jgit.NotificationModel;
import org.uberfire.java.nio.fs.jgit.daemon.git.Daemon;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonClient;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitSSHService;
import org.uberfire.java.nio.fs.jgit.util.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.CopyCommitContent;
import org.uberfire.java.nio.fs.jgit.util.DefaultCommitContent;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.MoveCommitContent;
import org.uberfire.java.nio.fs.jgit.util.ProxyAuthenticator;
import org.uberfire.java.nio.fs.jgit.util.RevertCommitContent;
import org.uberfire.java.nio.fs.jgit.util.commands.Fork;
import org.uberfire.java.nio.fs.jgit.util.commands.Mirror;
import org.uberfire.java.nio.fs.jgit.util.commands.Squash;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;
import org.uberfire.java.nio.security.FileSystemAuthenticator;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.SecuredFileSystemProvider;

public class JGitFileSystemProvider
implements SecuredFileSystemProvider,
Disposable {
    private static final Logger LOG = LoggerFactory.getLogger(JGitFileSystemProvider.class);
    protected static final String DEFAULT_IO_SERVICE_NAME = "default";
    public static final String GIT_ENV_KEY_DEFAULT_REMOTE_NAME = "origin";
    public static final String GIT_ENV_KEY_LIST_MODE = "listMode";
    public static final String GIT_ENV_KEY_DEST_PATH = "out-dir";
    public static final String GIT_ENV_KEY_USER_NAME = "username";
    public static final String GIT_ENV_KEY_PASSWORD = "password";
    public static final String GIT_ENV_KEY_INIT = "init";
    private static final String SCHEME = "git";
    private static final int SCHEME_SIZE = "git://".length();
    private static final int DEFAULT_SCHEME_SIZE = "default://".length();
    public static final String REPOSITORIES_CONTAINER_DIR = ".niogit";
    public static final String SSH_FILE_CERT_CONTAINER_DIR = ".security";
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_HOST_ADDR = "127.0.0.1";
    public static final String DAEMON_DEFAULT_ENABLED = "true";
    public static final String DAEMON_DEFAULT_PORT = "9418";
    public static final String SSH_DEFAULT_ENABLED = "true";
    public static final String SSH_DEFAULT_PORT = "8001";
    public static final String SSH_IDLE_TIMEOUT = "10000";
    public static final String SSH_ALGORITHM = "DSA";
    public static final String SSH_CERT_PASSPHRASE = "";
    public static final String DEFAULT_COMMIT_LIMIT_TO_GC = "20";
    private static final String GIT_ENV_KEY_MIGRATE_FROM = "migrate-from";
    private File gitReposParentDir;
    private File hookDir;
    private int commitLimit;
    private boolean daemonEnabled;
    private int daemonPort;
    private String daemonHostAddr;
    private String daemonHostName;
    private boolean sshEnabled;
    private int sshPort;
    private String sshHostAddr;
    private String sshHostName;
    private File sshFileCertDir;
    private String sshAlgorithm;
    private String sshPassphrase;
    private String sshIdleTimeout;
    private final Map<String, JGitFileSystem> fileSystems = new ConcurrentHashMap<String, JGitFileSystem>();
    private final Set<JGitFileSystem> closedFileSystems = new HashSet<JGitFileSystem>();
    private final Map<Repository, JGitFileSystem> repoIndex = new ConcurrentHashMap<Repository, JGitFileSystem>();
    private final Map<Repository, ClusterService> clusterMap = new ConcurrentHashMap<Repository, ClusterService>();
    private final Map<String, String> fullHostNames = new HashMap<String, String>();
    private boolean isDefault;
    private final Object oldHeadsOfPendingDiffsLock = new Object();
    private final Map<JGitFileSystem, Map<String, NotificationModel>> oldHeadsOfPendingDiffs = new ConcurrentHashMap<JGitFileSystem, Map<String, NotificationModel>>();
    private Daemon daemonService = null;
    private GitSSHService gitSSHService = null;
    private FS detectedFS = FS.DETECTED;

    private void loadConfig(ConfigProperties config) {
        LOG.debug("Configuring from properties:");
        String currentDirectory = System.getProperty("user.dir");
        ConfigProperties.ConfigProperty hookDirProp = config.get("org.uberfire.nio.git.hooks", null);
        ConfigProperties.ConfigProperty bareReposDirProp = config.get("org.uberfire.nio.git.dir", currentDirectory);
        ConfigProperties.ConfigProperty enabledProp = config.get("org.uberfire.nio.git.daemon.enabled", "true");
        ConfigProperties.ConfigProperty hostProp = config.get("org.uberfire.nio.git.daemon.host", DEFAULT_HOST_ADDR);
        ConfigProperties.ConfigProperty hostNameProp = config.get("org.uberfire.nio.git.daemon.hostname", hostProp.isDefault() ? DEFAULT_HOST_NAME : hostProp.getValue());
        ConfigProperties.ConfigProperty portProp = config.get("org.uberfire.nio.git.daemon.port", DAEMON_DEFAULT_PORT);
        ConfigProperties.ConfigProperty sshEnabledProp = config.get("org.uberfire.nio.git.ssh.enabled", "true");
        ConfigProperties.ConfigProperty sshHostProp = config.get("org.uberfire.nio.git.ssh.host", DEFAULT_HOST_ADDR);
        ConfigProperties.ConfigProperty sshHostNameProp = config.get("org.uberfire.nio.git.ssh.hostname", sshHostProp.isDefault() ? DEFAULT_HOST_NAME : sshHostProp.getValue());
        ConfigProperties.ConfigProperty sshPortProp = config.get("org.uberfire.nio.git.ssh.port", SSH_DEFAULT_PORT);
        ConfigProperties.ConfigProperty sshCertDirProp = config.get("org.uberfire.nio.git.ssh.cert.dir", currentDirectory);
        ConfigProperties.ConfigProperty sshIdleTimeoutProp = config.get("org.uberfire.nio.git.ssh.idle.timeout", SSH_IDLE_TIMEOUT);
        ConfigProperties.ConfigProperty sshAlgorithmProp = config.get("org.uberfire.nio.git.ssh.algorithm", SSH_ALGORITHM);
        ConfigProperties.ConfigProperty sshPassphraseProp = config.get("org.uberfire.nio.git.ssh.passphrase", SSH_CERT_PASSPHRASE);
        ConfigProperties.ConfigProperty commitLimitProp = config.get("org.uberfire.nio.git.gc.limit", DEFAULT_COMMIT_LIMIT_TO_GC);
        ConfigProperties.ConfigProperty httpProxyUserProp = config.get("http.proxyUser", null);
        ConfigProperties.ConfigProperty httpProxyPasswordProp = config.get("http.proxyPassword", null);
        ConfigProperties.ConfigProperty httpsProxyUserProp = config.get("https.proxyUser", null);
        ConfigProperties.ConfigProperty httpsProxyPasswordProp = config.get("https.proxyPassword", null);
        if (LOG.isDebugEnabled()) {
            LOG.debug(config.getConfigurationSummary("Summary of JGit configuration:"));
        }
        if (hookDirProp != null && hookDirProp.getValue() != null) {
            this.hookDir = new File(hookDirProp.getValue());
            if (!this.hookDir.exists()) {
                this.hookDir = null;
            }
        }
        this.gitReposParentDir = new File(bareReposDirProp.getValue(), REPOSITORIES_CONTAINER_DIR);
        this.commitLimit = commitLimitProp.getIntValue();
        this.daemonEnabled = enabledProp.getBooleanValue();
        if (this.daemonEnabled) {
            this.daemonPort = portProp.getIntValue();
            this.daemonHostAddr = hostProp.getValue();
            this.daemonHostName = hostNameProp.getValue();
        }
        this.sshEnabled = sshEnabledProp.getBooleanValue();
        if (this.sshEnabled) {
            this.sshPort = sshPortProp.getIntValue();
            this.sshHostAddr = sshHostProp.getValue();
            this.sshHostName = sshHostNameProp.getValue();
            this.sshFileCertDir = new File(sshCertDirProp.getValue(), SSH_FILE_CERT_CONTAINER_DIR);
            this.sshAlgorithm = sshAlgorithmProp.getValue();
            this.sshIdleTimeout = sshIdleTimeoutProp.getValue();
            try {
                Integer.valueOf(this.sshIdleTimeout);
            }
            catch (NumberFormatException exception) {
                LOG.error("SSH Idle Timeout value is not a valid integer - Parameter is ignored, now using default value.");
                this.sshIdleTimeout = SSH_IDLE_TIMEOUT;
            }
        }
        this.sshPassphrase = sshPassphraseProp.getValue();
        if (httpProxyUserProp.getValue() != null && httpProxyPasswordProp.getValue() != null || httpsProxyUserProp.getValue() != null && httpsProxyPasswordProp.getValue() != null) {
            this.setupProxyAuthentication(httpProxyUserProp.getValue(), httpProxyPasswordProp.getValue(), httpsProxyUserProp.getValue(), httpsProxyPasswordProp.getValue());
        }
    }

    private void setupProxyAuthentication(String httpProxyUser, String httpProxyPassword, String httpsProxyUser, String httpsProxyPassword) {
        Authenticator.setDefault(new ProxyAuthenticator(httpProxyUser, httpProxyPassword, httpsProxyUser, httpsProxyPassword));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCloseFileSystem(JGitFileSystem fileSystem) {
        this.closedFileSystems.add(fileSystem);
        Object object = this.oldHeadsOfPendingDiffsLock;
        synchronized (object) {
            this.oldHeadsOfPendingDiffs.remove(fileSystem);
        }
        if (this.closedFileSystems.size() == this.fileSystems.size()) {
            this.forceStopDaemon();
            this.shutdownSSH();
        }
    }

    public void onDisposeFileSystem(JGitFileSystem fileSystem) {
        this.onCloseFileSystem(fileSystem);
        this.closedFileSystems.remove(fileSystem);
        this.fileSystems.remove(fileSystem.id());
        this.repoIndex.remove(fileSystem.gitRepo().getRepository());
        this.clusterMap.remove(fileSystem.gitRepo().getRepository());
    }

    public Set<JGitFileSystem> getOpenFileSystems() {
        HashSet<JGitFileSystem> open = new HashSet<JGitFileSystem>(this.fileSystems.values());
        open.removeAll(this.closedFileSystems);
        return open;
    }

    public void setAuthenticator(FileSystemAuthenticator authenticator) {
        PortablePreconditions.checkNotNull((String)"authenticator", (Object)authenticator);
        if (this.gitSSHService != null) {
            this.gitSSHService.setUserPassAuthenticator(authenticator);
        }
    }

    public void setAuthorizer(FileSystemAuthorizer authorizer) {
        PortablePreconditions.checkNotNull((String)"authorizer", (Object)authorizer);
        if (this.gitSSHService != null) {
            this.gitSSHService.setAuthorizationManager(authorizer);
        }
    }

    public void dispose() {
        this.shutdown();
    }

    public JGitFileSystemProvider() {
        this(new ConfigProperties(System.getProperties()));
    }

    public JGitFileSystemProvider(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public JGitFileSystemProvider(ConfigProperties gitPrefs) {
        this.loadConfig(gitPrefs);
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("guest", SSH_CERT_PASSPHRASE));
        JschConfigSessionFactory sessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host hc, Session session) {
                CredentialsProvider provider = new CredentialsProvider(){

                    public boolean isInteractive() {
                        return false;
                    }

                    public boolean supports(CredentialItem ... items) {
                        return true;
                    }

                    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
                        for (CredentialItem item : items) {
                            if (item instanceof CredentialItem.YesNoType) {
                                ((CredentialItem.YesNoType)item).setValue(true);
                                continue;
                            }
                            if (!(item instanceof CredentialItem.StringType)) continue;
                            ((CredentialItem.StringType)item).setValue(JGitFileSystemProvider.this.sshPassphrase);
                        }
                        return true;
                    }
                };
                CredentialsProviderUserInfo userInfo = new CredentialsProviderUserInfo(session, provider);
                session.setUserInfo((UserInfo)userInfo);
            }
        };
        SshSessionFactory.setInstance((SshSessionFactory)sessionFactory);
        if (this.daemonEnabled) {
            this.fullHostNames.put(SCHEME, this.daemonHostName + ":" + this.daemonPort);
        }
        if (this.sshEnabled) {
            this.fullHostNames.put("ssh", this.sshHostName + ":" + this.sshPort);
        }
        this.rescanForExistingRepositories();
        if (this.daemonEnabled) {
            this.buildAndStartDaemon();
        } else {
            this.daemonService = null;
        }
        if (this.sshEnabled) {
            this.buildAndStartSSH();
        } else {
            this.gitSSHService = null;
        }
    }

    public final void rescanForExistingRepositories() {
        this.fileSystems.clear();
        List<Pair<String, String>> repos = this.getRepositories(this.gitReposParentDir);
        if (repos != null) {
            for (Pair<String, String> repo : repos) {
                File repoDir = new File(this.gitReposParentDir, (String)repo.getK1() + (String)repo.getK2());
                try {
                    if (repoDir.isDirectory()) {
                        String name = (String)repo.getK1() + ((String)repo.getK2()).substring(0, ((String)repo.getK2()).indexOf(".git"));
                        JGitFileSystem fs = new JGitFileSystem(this, this.fullHostNames, JGitUtil.newRepository(repoDir, true), name, null, this.buildCredential(null));
                        LOG.debug("Running GIT GC on '" + name + "'");
                        JGitUtil.gc(fs.gitRepo());
                        LOG.debug("Registering existing GIT filesystem '" + name + "' at " + repoDir);
                        this.fileSystems.put(name, fs);
                        this.repoIndex.put(fs.gitRepo().getRepository(), fs);
                        continue;
                    }
                    LOG.debug("Not registering " + repoDir + " as a GIT filesystem because it is not a directory");
                }
                catch (Exception ex) {
                    LOG.error("Not registering " + repoDir + " as a GIT filesystem failed", (Throwable)ex);
                }
            }
        }
    }

    private List<Pair<String, String>> getRepositories(File root) {
        String[] topLevelFolders;
        ArrayList<Pair<String, String>> repositories = new ArrayList<Pair<String, String>>();
        String[] topLevelRepositories = root.list((file, s) -> s.endsWith(".git"));
        if (topLevelRepositories != null) {
            List repos = Arrays.asList(topLevelRepositories).stream().map(dir -> Pair.newPair((Object)SSH_CERT_PASSPHRASE, (Object)dir)).collect(Collectors.toList());
            repositories.addAll(repos);
        }
        if ((topLevelFolders = root.list((file, s) -> !s.endsWith(".git"))) != null) {
            Arrays.asList(topLevelFolders).stream().forEach(dir -> {
                File subRoot = new File(root.getPath() + "/" + dir);
                String[] repos = subRoot.list((file, name) -> name.endsWith(".git"));
                if (repos != null) {
                    Arrays.asList(repos).stream().forEach(repo -> repositories.add(Pair.newPair((Object)(dir + "/"), (Object)repo)));
                }
            });
        }
        return repositories;
    }

    private void buildAndStartSSH() {
        ReceivePackFactory<BaseGitCommand> receivePackFactory = new ReceivePackFactory<BaseGitCommand>(){

            public ReceivePack create(final BaseGitCommand req, final Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                return new ReceivePack(db){
                    {
                        super(x0);
                        final ClusterService clusterService = (ClusterService)JGitFileSystemProvider.this.clusterMap.get(db);
                        final JGitFileSystem fs = (JGitFileSystem)JGitFileSystemProvider.this.repoIndex.get(db);
                        final HashMap oldTreeRefs = new HashMap();
                        this.setPreReceiveHook(new PreReceiveHook(){

                            public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
                                fs.lock();
                                if (clusterService != null) {
                                    clusterService.lock();
                                }
                                for (ReceiveCommand command : commands) {
                                    RevCommit lastCommit = JGitUtil.getLastCommit(fs.gitRepo(), command.getRefName());
                                    oldTreeRefs.put(command.getRefName(), lastCommit);
                                }
                            }
                        });
                        this.setPostReceiveHook(new PostReceiveHook(){

                            public void onPostReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
                                fs.unlock();
                                String userName = req.getUser().getName();
                                for (Map.Entry oldTreeRef : oldTreeRefs.entrySet()) {
                                    List<RevCommit> commits = JGitUtil.getCommits(fs.gitRepo(), (String)oldTreeRef.getKey(), (ObjectId)oldTreeRef.getValue(), (ObjectId)JGitUtil.getLastCommit(fs.gitRepo(), (String)oldTreeRef.getKey()));
                                    for (RevCommit revCommit : commits) {
                                        RevTree parent = revCommit.getParentCount() > 0 ? revCommit.getParent(0).getTree() : null;
                                        JGitFileSystemProvider.this.notifyDiffs(fs, (String)oldTreeRef.getKey(), "<ssh>", userName, revCommit.getFullMessage(), (ObjectId)parent, (ObjectId)revCommit.getTree());
                                    }
                                }
                                if (clusterService != null) {
                                    clusterService.broadcast(JGitFileSystemProvider.DEFAULT_IO_SERVICE_NAME, new MessageType(){

                                        public String toString() {
                                            return "SYNC_FS";
                                        }

                                        public int hashCode() {
                                            return "SYNC_FS".hashCode();
                                        }
                                    }, (Map)new HashMap<String, String>(){
                                        {
                                            this.put("fs_scheme", JGitFileSystemProvider.SCHEME);
                                            this.put("fs_id", fs.id());
                                            this.put("fs_uri", fs.toString());
                                        }
                                    });
                                    clusterService.unlock();
                                }
                            }
                        });
                    }
                };
            }
        };
        this.gitSSHService = new GitSSHService();
        this.gitSSHService.setup(this.sshFileCertDir, InetSocketAddress.createUnresolved(this.sshHostAddr, this.sshPort), this.sshIdleTimeout, this.sshAlgorithm, (ReceivePackFactory)receivePackFactory, new RepositoryResolverImpl<BaseGitCommand>());
        this.gitSSHService.start();
    }

    void buildAndStartDaemon() {
        if (this.daemonService == null || !this.daemonService.isRunning()) {
            this.daemonService = new Daemon(new InetSocketAddress(this.daemonHostAddr, this.daemonPort), new ExecutorWrapper(SimpleAsyncExecutorService.getUnmanagedInstance()));
            this.daemonService.setRepositoryResolver(new RepositoryResolverImpl<DaemonClient>());
            try {
                this.daemonService.start();
            }
            catch (java.io.IOException e) {
                throw new IOException((Exception)e);
            }
        }
    }

    private void shutdownSSH() {
        if (this.gitSSHService != null) {
            this.gitSSHService.stop();
        }
    }

    void forceStopDaemon() {
        if (this.daemonService != null && this.daemonService.isRunning()) {
            this.daemonService.stop();
        }
    }

    public void shutdown() {
        for (JGitFileSystem fs : this.getOpenFileSystems()) {
            fs.close();
        }
        this.shutdownSSH();
        this.forceStopDaemon();
    }

    public File getGitRepoContainerDir() {
        return this.gitReposParentDir;
    }

    public synchronized void forceAsDefault() {
        this.isDefault = true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getScheme() {
        return SCHEME;
    }

    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, IOException, SecurityException, FileSystemAlreadyExistsException {
        Object _clusterService;
        Git git;
        CredentialsProvider credential;
        ListBranchCommand.ListMode listMode;
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        PortablePreconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals(DEFAULT_IO_SERVICE_NAME) ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        PortablePreconditions.checkNotNull((String)"env", env);
        String name = this.extractRepoName(uri);
        this.migrateIfNeeded(env, name);
        if (this.fileSystems.containsKey(name)) {
            throw new FileSystemAlreadyExistsException("No filesystem for uri (" + uri + ") found.");
        }
        if (env.containsKey(GIT_ENV_KEY_LIST_MODE)) {
            try {
                listMode = ListBranchCommand.ListMode.valueOf((String)((String)env.get(GIT_ENV_KEY_LIST_MODE)));
            }
            catch (Exception ex) {
                listMode = null;
            }
        } else {
            listMode = null;
        }
        boolean bare = true;
        String outPath = (String)env.get(GIT_ENV_KEY_DEST_PATH);
        File repoDest = outPath != null ? new File(outPath, name + ".git") : new File(this.gitReposParentDir, name + ".git");
        if (env.containsKey(GIT_ENV_KEY_DEFAULT_REMOTE_NAME)) {
            String originURI = env.get(GIT_ENV_KEY_DEFAULT_REMOTE_NAME).toString();
            credential = this.buildCredential(env);
            if (this.isForkOrigin(originURI)) {
                git = new Fork(this.getGitRepoContainerDir(), originURI, name, credential).execute().get();
            } else {
                new Mirror(repoDest, originURI, credential).execute();
                git = JGitUtil.cloneRepository(repoDest, originURI, bare, credential);
            }
        } else {
            credential = this.buildCredential(null);
            git = JGitUtil.newRepository(repoDest, bare, this.hookDir);
        }
        JGitFileSystem fs = new JGitFileSystem(this, this.fullHostNames, git, name, listMode, credential);
        this.fileSystems.put(name, fs);
        this.repoIndex.put(fs.gitRepo().getRepository(), fs);
        boolean init = false;
        if (env.containsKey(GIT_ENV_KEY_INIT) && Boolean.valueOf(env.get(GIT_ENV_KEY_INIT).toString()).booleanValue()) {
            init = true;
        }
        if (!env.containsKey(GIT_ENV_KEY_DEFAULT_REMOTE_NAME) && init) {
            try {
                URI initURI = URI.create(this.getScheme() + "://master@" + name + "/readme.md");
                CommentedOption op = this.setupOp(env);
                OutputStream stream = this.newOutputStream(this.getPath(initURI), new OpenOption[]{op});
                String _init = "Repository Init Content\n=======================\n\nYour project description here.";
                stream.write("Repository Init Content\n=======================\n\nYour project description here.".getBytes());
                stream.close();
            }
            catch (Exception initURI) {
                // empty catch block
            }
            if (!bare) {
                // empty if block
            }
        }
        if ((_clusterService = env.get("clusterService")) != null && _clusterService instanceof ClusterService) {
            this.clusterMap.put(git.getRepository(), (ClusterService)_clusterService);
        }
        if (this.daemonEnabled && this.daemonService != null && !this.daemonService.isRunning()) {
            this.buildAndStartDaemon();
        }
        return fs;
    }

    private void migrateIfNeeded(Map<String, ?> env, String name) {
        URI migrateFromURI;
        String oldRepoName;
        if (env.containsKey(GIT_ENV_KEY_MIGRATE_FROM) && this.fileSystems.containsKey(oldRepoName = this.extractRepoName(migrateFromURI = (URI)env.get(GIT_ENV_KEY_MIGRATE_FROM))) && !this.fileSystems.containsKey(name)) {
            this.migrateOldRepository(oldRepoName, name);
        }
    }

    private String extractRepoName(URI uri) {
        String authority = uri.getAuthority();
        String path = uri.getPath();
        String name = authority + path;
        if (path == null || "/".equals(path)) {
            name = authority;
        }
        return name;
    }

    private boolean isForkOrigin(String originURI) {
        return originURI.matches("(^\\w+\\/\\w+$)");
    }

    private void migrateOldRepository(String oldName, String newName) {
        File oldRepository = new File(this.getGitRepoContainerDir(), oldName + ".git");
        File newRepository = new File(this.getGitRepoContainerDir(), newName + ".git");
        if (oldRepository.exists() && !newRepository.exists()) {
            try {
                Files.createDirectories(newRepository.toPath(), new FileAttribute[0]);
                Files.move(oldRepository.toPath(), newRepository.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.fileSystems.remove(oldName);
            }
            catch (java.io.IOException e) {
                throw new GitException("A problem occurred trying to migrate repositories", e);
            }
        }
    }

    private Optional<Pair<String, String>> extractOldName(String name) {
        if (name.contains("/")) {
            String oldName = name.substring(name.indexOf("/") + 1);
            return Optional.of(new Pair((Object)name, (Object)oldName));
        }
        return Optional.empty();
    }

    private String getRepoName(URI uri) {
        String path = uri.getPath();
        int indexOf = path.lastIndexOf("/");
        return path.substring(indexOf + 1);
    }

    private CommentedOption setupOp(Map<String, ?> env) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        PortablePreconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals(DEFAULT_IO_SERVICE_NAME) ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        JGitFileSystem fileSystem = this.fileSystems.get(this.extractRepoNameWithFolder(uri));
        if (fileSystem == null && (fileSystem = this.fileSystems.get(this.extractRepoNameWithoutFolder(uri))) == null) {
            throw new FileSystemNotFoundException("No filesystem for uri (" + uri + ") found.");
        }
        if (this.hasSyncFlag(uri)) {
            try {
                String treeRef = "master";
                ObjectId oldHead = JGitUtil.getTreeRefObjectId(fileSystem.gitRepo().getRepository(), "master");
                Map<String, String> params = JGitFileSystemProvider.getQueryParams(uri);
                try {
                    fileSystem.lock();
                    JGitUtil.syncRepository(fileSystem.gitRepo(), fileSystem.getCredential(), params.get("sync"), this.hasForceFlag(uri));
                }
                finally {
                    fileSystem.unlock();
                }
                ObjectId newHead = JGitUtil.getTreeRefObjectId(fileSystem.gitRepo().getRepository(), "master");
                this.notifyDiffs(fileSystem, "master", "<system>", "<system>", SSH_CERT_PASSPHRASE, oldHead, newHead);
            }
            catch (Exception ex) {
                throw new IOException("Failed to sync repository.", ex);
            }
        }
        if (this.hasPushFlag(uri)) {
            try {
                Map<String, String> params = JGitFileSystemProvider.getQueryParams(uri);
                JGitUtil.pushRepository(fileSystem.gitRepo(), fileSystem.getCredential(), params.get("push"), this.hasForceFlag(uri));
            }
            catch (Exception ex) {
                throw new IOException("Failed to push repository.", ex);
            }
        }
        return fileSystem;
    }

    public Path getPath(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        JGitPathImpl path;
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        PortablePreconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals(DEFAULT_IO_SERVICE_NAME) ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        JGitFileSystem fileSystem = this.fileSystems.get(this.extractRepoNameWithFolder(uri));
        if (fileSystem == null) {
            fileSystem = this.fileSystems.get(this.extractRepoNameWithoutFolder(uri));
            if (fileSystem == null) {
                throw new FileSystemNotFoundException("No filesystem for uri (" + uri + ") found.");
            }
            path = JGitPathImpl.create(fileSystem, this.extractOldPath(uri), this.extractOldHost(uri), false);
        } else {
            path = JGitPathImpl.create(fileSystem, this.extractPath(uri), this.extractHost(uri), false);
        }
        return path;
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, NoSuchFileException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        return JGitUtil.resolveInputStream(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
    }

    public OutputStream newOutputStream(final Path path, final OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        final JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new NotDirectoryException(path.toString());
        }
        try {
            final File file = File.createTempFile("gitz", "woot");
            return new FilterOutputStream(new FileOutputStream(file)){

                @Override
                public void close() throws java.io.IOException {
                    super.close();
                    JGitFileSystemProvider.this.commit(gPath, JGitFileSystemProvider.this.buildCommitInfo("{" + JGitFileSystemProvider.this.toPathImpl(path).getPath() + "}", Arrays.asList(options)), new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
                        {
                            this.put(gPath.getPath(), file);
                        }
                    }));
                }
            };
        }
        catch (java.io.IOException e) {
            throw new IOException("Could not create file or output stream.", (Exception)e);
        }
    }

    private CommitInfo buildCommitInfo(String defaultMessage, Collection<? extends Option> options) {
        CommentedOption op;
        String sessionId = null;
        String name = null;
        String email = null;
        String message = defaultMessage;
        TimeZone timeZone = null;
        Date when = null;
        if (options != null && !options.isEmpty() && (op = this.extractCommentedOption(options)) != null) {
            sessionId = op.getSessionId();
            name = op.getName();
            email = op.getEmail();
            if (op.getMessage() != null && !op.getMessage().trim().isEmpty()) {
                message = op.getMessage() + " " + defaultMessage;
            }
            timeZone = op.getTimeZone();
            when = op.getWhen();
        }
        return new CommitInfo(sessionId, name, email, message, timeZone, when);
    }

    final CommentedOption extractCommentedOption(Collection<? extends Option> options) {
        for (Option option : options) {
            if (!(option instanceof CommentedOption)) continue;
            return (CommentedOption)option;
        }
        return null;
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, org.uberfire.java.nio.file.attribute.FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, org.uberfire.java.nio.file.attribute.FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, org.uberfire.java.nio.file.attribute.FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.exists(path) && !this.shouldCreateOrOpenAByteChannel(options)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new NotDirectoryException(path.toString());
        }
        try {
            if (options != null && options.contains(StandardOpenOption.READ)) {
                SeekableByteChannelFileBasedImpl seekableByteChannelFileBasedImpl = this.openAByteChannel(path);
                return seekableByteChannelFileBasedImpl;
            }
            SeekableByteChannel seekableByteChannel = this.createANewByteChannel(path, options, gPath, attrs);
            return seekableByteChannel;
        }
        catch (java.io.IOException e) {
            throw new IOException("Failed to open or create a byte channel.", (Exception)e);
        }
        finally {
            ((AbstractPath)path).clearCache();
        }
    }

    private SeekableByteChannel createANewByteChannel(final Path path, final Set<? extends OpenOption> options, final JGitPathImpl gPath, final org.uberfire.java.nio.file.attribute.FileAttribute<?>[] attrs) throws java.io.IOException {
        final File file = File.createTempFile("gitz", "woot");
        return new SeekableByteChannelFileBasedImpl(new RandomAccessFile(file, "rw").getChannel()){

            public void close() throws java.io.IOException {
                boolean hasDotContent;
                super.close();
                File tempDot = null;
                if (options != null && options.contains(new DotFileOption())) {
                    JGitFileSystemProvider.this.deleteIfExists(DotFileUtils.dot((Path)path), new DeleteOption[]{JGitFileSystemProvider.this.extractCommentedOption(options)});
                    tempDot = File.createTempFile("meta", "dot");
                    hasDotContent = DotFileUtils.buildDotFile((Path)path, (OutputStream)new FileOutputStream(tempDot), (org.uberfire.java.nio.file.attribute.FileAttribute[])attrs);
                } else {
                    hasDotContent = false;
                }
                final File dotfile = tempDot;
                JGitFileSystemProvider.this.commit(gPath, JGitFileSystemProvider.this.buildCommitInfo("{" + JGitFileSystemProvider.this.toPathImpl(path).getPath() + "}", options), new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
                    {
                        this.put(gPath.getPath(), file);
                        if (hasDotContent) {
                            this.put(JGitFileSystemProvider.this.toPathImpl(DotFileUtils.dot((Path)gPath)).getPath(), dotfile);
                        }
                    }
                }));
            }
        };
    }

    private SeekableByteChannelFileBasedImpl openAByteChannel(Path path) throws FileNotFoundException {
        return new SeekableByteChannelFileBasedImpl(new RandomAccessFile(path.toFile(), "r").getChannel());
    }

    private boolean shouldCreateOrOpenAByteChannel(Set<? extends OpenOption> options) {
        return options != null && (options.contains(StandardOpenOption.TRUNCATE_EXISTING) || options.contains(StandardOpenOption.READ));
    }

    protected boolean exists(Path path) {
        try {
            this.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<Path> pfilter) throws NotDirectoryException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        DirectoryStream.Filter<Path> filter = pfilter == null ? new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        } : pfilter;
        final JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (!((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            throw new NotDirectoryException(path.toString());
        }
        final List<JGitUtil.JGitPathInfo> pathContent = JGitUtil.listPathContent(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        return new DirectoryStream<Path>((DirectoryStream.Filter)filter){
            boolean isClosed = false;
            final /* synthetic */ DirectoryStream.Filter val$filter;
            {
                this.val$filter = filter;
            }

            public void close() throws IOException {
                if (this.isClosed) {
                    throw new IOException("This stream is closed.");
                }
                this.isClosed = true;
            }

            public Iterator<Path> iterator() {
                if (this.isClosed) {
                    throw new IOException("This stream is closed.");
                }
                return new Iterator<Path>(){
                    private int i = -1;
                    private Path nextEntry = null;
                    public boolean atEof = false;

                    @Override
                    public boolean hasNext() {
                        if (this.nextEntry == null && !this.atEof) {
                            this.nextEntry = this.readNextEntry();
                        }
                        return this.nextEntry != null;
                    }

                    @Override
                    public Path next() {
                        Path result;
                        if (this.nextEntry == null && !this.atEof) {
                            result = this.readNextEntry();
                        } else {
                            result = this.nextEntry;
                            this.nextEntry = null;
                        }
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        return result;
                    }

                    private Path readNextEntry() {
                        JGitPathImpl result;
                        block3: {
                            JGitUtil.JGitPathInfo content;
                            JGitPathImpl path;
                            if (this.atEof) {
                                return null;
                            }
                            result = null;
                            do {
                                ++this.i;
                                if (this.i >= pathContent.size()) {
                                    this.atEof = true;
                                    break block3;
                                }
                                content = (JGitUtil.JGitPathInfo)pathContent.get(this.i);
                            } while (!val$filter.accept((Object)(path = JGitPathImpl.create((JGitFileSystem)gPath.getFileSystem(), "/" + content.getPath(), gPath.getHost(), content.getObjectId(), gPath.isRealPath()))));
                            result = path;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void createDirectory(Path path, org.uberfire.java.nio.file.attribute.FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (!((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        try {
            OutputStream outputStream = this.newOutputStream(path.resolve(".gitignore"), new OpenOption[0]);
            outputStream.write("# empty\n".getBytes());
            outputStream.close();
        }
        catch (Exception e) {
            throw new IOException("Failed to write to or close the output stream.", e);
        }
    }

    public void createSymbolicLink(Path link, Path target, org.uberfire.java.nio.file.attribute.FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void createLink(Path link, Path existing) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void delete(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, NoSuchFileException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        if (path instanceof JGitFSPath) {
            this.deleteRepo(path.getFileSystem());
            return;
        }
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.isBranch(gPath)) {
            this.deleteBranch(gPath);
            return;
        }
        this.deleteAsset(gPath, options);
    }

    private boolean deleteRepo(FileSystem fileSystem) {
        File gitDir = ((JGitFileSystem)fileSystem).gitRepo().getRepository().getDirectory();
        fileSystem.close();
        fileSystem.dispose();
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                WindowCache.reconfigure((WindowCacheConfig)new WindowCacheConfig());
            }
            FileUtils.delete((File)gitDir, (int)3);
            return true;
        }
        catch (java.io.IOException e) {
            throw new IOException("Failed to remove the git repository.", (Exception)e);
        }
    }

    public void deleteAsset(JGitPathImpl path, DeleteOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            if (this.deleteNonEmptyDirectory(options)) {
                this.deleteResource(path, options);
                return;
            }
            List<JGitUtil.JGitPathInfo> content = JGitUtil.listPathContent(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
            if (content.size() == 1 && content.get(0).getPath().equals(path.getPath().substring(1) + "/.gitignore")) {
                this.delete(path.resolve(".gitignore"), new DeleteOption[0]);
                this.deleteResource(path, options);
                return;
            }
            throw new DirectoryNotEmptyException(path.toString());
        }
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        this.deleteResource(path, options);
    }

    void deleteResource(JGitPathImpl path, DeleteOption ... options) {
        this.delete(path, this.buildCommitInfo("delete {" + path.getPath() + "}", Arrays.asList(options)));
    }

    private boolean deleteNonEmptyDirectory(DeleteOption ... options) {
        for (DeleteOption option : options) {
            if (!option.equals(StandardDeleteOption.NON_EMPTY_DIRECTORIES)) continue;
            return true;
        }
        return false;
    }

    public void deleteBranch(JGitPathImpl path) {
        Ref branch = JGitUtil.getBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
        if (branch == null) {
            throw new NoSuchFileException(path.toString());
        }
        try {
            ((JGitFileSystem)path.getFileSystem()).lock();
            JGitUtil.deleteBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), branch);
        }
        finally {
            ((JGitFileSystem)path.getFileSystem()).unlock();
        }
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        if (path instanceof JGitFSPath) {
            return this.deleteRepo(path.getFileSystem());
        }
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.isBranch(gPath)) {
            return this.deleteBranchIfExists(gPath);
        }
        return this.deleteAssetIfExists(gPath, options);
    }

    public boolean deleteBranchIfExists(JGitPathImpl path) {
        Ref branch = JGitUtil.getBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
        if (branch == null) {
            return false;
        }
        try {
            ((JGitFileSystem)path.getFileSystem()).lock();
            JGitUtil.deleteBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), branch);
        }
        finally {
            ((JGitFileSystem)path.getFileSystem()).unlock();
        }
        return true;
    }

    public boolean deleteAssetIfExists(JGitPathImpl path, DeleteOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.DIRECTORY)) {
            if (this.deleteNonEmptyDirectory(options)) {
                this.deleteResource(path, options);
                return true;
            }
            List<JGitUtil.JGitPathInfo> content = JGitUtil.listPathContent(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree(), path.getPath());
            if (content.size() == 1 && content.get(0).getPath().equals(path.getPath().substring(1) + "/.gitignore")) {
                this.delete(path.resolve(".gitignore"), new DeleteOption[0]);
                return true;
            }
            throw new DirectoryNotEmptyException(path.toString());
        }
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            return false;
        }
        this.deleteResource(path, options);
        return true;
    }

    public Path readSymbolicLink(Path link) throws UnsupportedOperationException, NotLinkException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"link", (Object)link);
        throw new UnsupportedOperationException();
    }

    public void copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        boolean isBranch;
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"target", (Object)target);
        JGitPathImpl gSource = this.toPathImpl(source);
        JGitPathImpl gTarget = this.toPathImpl(target);
        boolean bl = isBranch = this.isBranch(gSource) && this.isBranch(gTarget);
        if (options.length == 1 && options[0] instanceof CherryPickCopyOption) {
            if (!isBranch) {
                throw new IOException("Cherry pick needs source and target as root.");
            }
            String[] commits = ((CherryPickCopyOption)options[0]).getCommits();
            if (commits == null || commits.length == 0) {
                throw new IOException("Cherry pick needs at least one commit id.");
            }
            this.cherryPick(gSource, gTarget, commits);
        } else {
            if (isBranch) {
                this.copyBranch(gSource, gTarget);
                return;
            }
            this.copyAsset(gSource, gTarget, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cherryPick(JGitPathImpl source, JGitPathImpl target, String ... commits) {
        try {
            ((JGitFileSystem)target.getFileSystem()).lock();
            JGitUtil.cherryPick(((JGitFileSystem)source.getFileSystem()).gitRepo().getRepository(), target.getRefTree(), commits);
        }
        finally {
            ((JGitFileSystem)target.getFileSystem()).unlock();
        }
    }

    private void copyBranch(JGitPathImpl source, JGitPathImpl target) {
        PortablePreconditions.checkCondition((String)"source and taget should have same setup", (!this.hasSameFileSystem(source, target) ? 1 : 0) != 0);
        if (this.existsBranch(target)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (!this.existsBranch(source)) {
            throw new NoSuchFileException(target.toString());
        }
        this.createBranch(source, target);
    }

    private void copyAsset(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> sourceResult = JGitUtil.checkPath(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), source.getPath());
        Pair<JGitUtil.PathType, ObjectId> targetResult = JGitUtil.checkPath(((JGitFileSystem)target.getFileSystem()).gitRepo(), target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getK1() != JGitUtil.PathType.NOT_FOUND && !this.contains(options, (CopyOption)org.uberfire.java.nio.file.StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (!source.getRefTree().equals(target.getRefTree())) {
            this.copyAssetContent(source, target, options);
        } else if (!((JGitFileSystem)source.getFileSystem()).equals(target.getFileSystem())) {
            this.copyAssetContent(source, target, options);
        } else {
            HashMap<JGitPathImpl, JGitPathImpl> sourceDest = new HashMap<JGitPathImpl, JGitPathImpl>();
            if (sourceResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                sourceDest.putAll(this.mapDirectoryContent(source, target, options));
            } else {
                sourceDest.put(source, target);
            }
            this.copyFiles(source, target, sourceDest, options);
        }
    }

    private void copyAssetContent(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> sourceResult = JGitUtil.checkPath(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), source.getPath());
        Pair<JGitUtil.PathType, ObjectId> targetResult = JGitUtil.checkPath(((JGitFileSystem)target.getFileSystem()).gitRepo(), target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getK1() != JGitUtil.PathType.NOT_FOUND && !this.contains(options, (CopyOption)org.uberfire.java.nio.file.StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.DIRECTORY) {
            this.copyDirectory(source, target, options);
            return;
        }
        this.copyFile(source, target, options);
    }

    private boolean contains(CopyOption[] options, CopyOption opt) {
        for (CopyOption option : options) {
            if (!option.equals(opt)) continue;
            return true;
        }
        return false;
    }

    private void copyDirectory(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        ArrayList<JGitPathImpl> directories = new ArrayList<JGitPathImpl>();
        for (Path path : this.newDirectoryStream((Path)source, null)) {
            JGitPathImpl gPath = this.toPathImpl(path);
            Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
            if (pathResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                directories.add(gPath);
                continue;
            }
            JGitPathImpl gTarget = this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]);
            this.copyFile(gPath, gTarget, new CopyOption[0]);
        }
        for (JGitPathImpl directory : directories) {
            this.createDirectory((Path)this.composePath(target, (JGitPathImpl)directory.getFileName(), new CopyOption[0]), new org.uberfire.java.nio.file.attribute.FileAttribute[0]);
        }
    }

    private JGitPathImpl composePath(JGitPathImpl directory, JGitPathImpl fileName, CopyOption ... options) {
        if (directory.getPath().endsWith("/")) {
            return this.toPathImpl(this.getPath(URI.create(directory.toUri().toString() + this.uriEncode(fileName.toString(false)))));
        }
        return this.toPathImpl(this.getPath(URI.create(directory.toUri().toString() + "/" + this.uriEncode(fileName.toString(false)))));
    }

    private String uriEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(JGitPathImpl source, JGitPathImpl target, final CopyOption ... options) {
        InputStream in = this.newInputStream((Path)source, this.convert(options));
        SeekableByteChannel out = this.newByteChannel((Path)target, (Set<? extends OpenOption>)new HashSet<OpenOption>(){
            {
                this.add(StandardOpenOption.TRUNCATE_EXISTING);
                for (CopyOption _option : options) {
                    if (!(_option instanceof OpenOption)) continue;
                    this.add((OpenOption)_option);
                }
            }
        }, new org.uberfire.java.nio.file.attribute.FileAttribute[0]);
        try {
            int count;
            byte[] buffer = new byte[8192];
            while ((count = in.read(buffer)) > 0) {
                out.write(ByteBuffer.wrap(buffer, 0, count));
            }
            return;
        }
        catch (Exception e) {
            throw new IOException("Failed to copy file from '" + (Object)((Object)source) + "' to '" + (Object)((Object)target) + "'", e);
        }
        finally {
            try {
                out.close();
            }
            catch (java.io.IOException e) {
                throw new IOException("Could not close output stream.", (Exception)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (java.io.IOException e) {
                    throw new IOException("Could not close input stream.", (Exception)e);
                }
            }
        }
    }

    private OpenOption[] convert(CopyOption ... options) {
        if (options == null || options.length == 0) {
            return new OpenOption[0];
        }
        ArrayList<OpenOption> newOptions = new ArrayList<OpenOption>(options.length);
        for (CopyOption option : options) {
            if (!(option instanceof OpenOption)) continue;
            newOptions.add((OpenOption)option);
        }
        return newOptions.toArray(new OpenOption[newOptions.size()]);
    }

    private void createBranch(JGitPathImpl source, JGitPathImpl target) {
        try {
            ((JGitFileSystem)target.getFileSystem()).lock();
            JGitUtil.createBranch(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), target.getRefTree());
        }
        finally {
            ((JGitFileSystem)target.getFileSystem()).unlock();
        }
    }

    private boolean existsBranch(JGitPathImpl path) {
        return JGitUtil.hasBranch(((JGitFileSystem)path.getFileSystem()).gitRepo(), path.getRefTree());
    }

    private boolean isBranch(JGitPathImpl path) {
        return path.getPath().length() == 1 && path.getPath().equals("/");
    }

    private boolean isRoot(JGitPathImpl path) {
        return this.isBranch(path);
    }

    private boolean hasSameFileSystem(JGitPathImpl source, JGitPathImpl target) {
        return ((JGitFileSystem)source.getFileSystem()).equals((Object)target);
    }

    public void move(Path source, Path target, CopyOption ... options) throws DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"target", (Object)target);
        JGitPathImpl gSource = this.toPathImpl(source);
        JGitPathImpl gTarget = this.toPathImpl(target);
        boolean isSourceBranch = this.isBranch(gSource);
        boolean isTargetBranch = this.isBranch(gTarget);
        if (isSourceBranch && isTargetBranch) {
            this.moveBranch(gSource, gTarget, options);
            return;
        }
        this.moveAsset(gSource, gTarget, options);
    }

    private void moveBranch(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        PortablePreconditions.checkCondition((String)"source and taget should have same setup", (!this.hasSameFileSystem(source, target) ? 1 : 0) != 0);
        if (!this.exists((Path)source)) {
            throw new NoSuchFileException(target.toString());
        }
        boolean targetExists = this.existsBranch(target);
        if (targetExists && !this.contains(options, (CopyOption)org.uberfire.java.nio.file.StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (!targetExists) {
            this.createBranch(source, target);
            this.deleteBranch(source);
        } else {
            this.commit(target, this.buildCommitInfo("reverting from {" + source.getPath() + "}", Arrays.asList(options)), new RevertCommitContent(source.getRefTree()));
        }
    }

    private void moveAsset(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        Pair<JGitUtil.PathType, ObjectId> sourceResult = JGitUtil.checkPath(((JGitFileSystem)source.getFileSystem()).gitRepo(), source.getRefTree(), source.getPath());
        Pair<JGitUtil.PathType, ObjectId> targetResult = JGitUtil.checkPath(((JGitFileSystem)target.getFileSystem()).gitRepo(), target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getK1() != JGitUtil.PathType.NOT_FOUND && !this.contains(options, (CopyOption)org.uberfire.java.nio.file.StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getK1() == JGitUtil.PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (!source.getRefTree().equals(target.getRefTree())) {
            this.copy((Path)source, (Path)target, options);
            this.delete((Path)source, new DeleteOption[0]);
        } else {
            HashMap<JGitPathImpl, JGitPathImpl> fromTo = new HashMap<JGitPathImpl, JGitPathImpl>();
            if (sourceResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                fromTo.putAll(this.mapDirectoryContent(source, target, options));
            } else {
                fromTo.put(source, target);
            }
            this.moveFiles(source, target, fromTo, options);
        }
    }

    private Map<JGitPathImpl, JGitPathImpl> mapDirectoryContent(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        HashMap<JGitPathImpl, JGitPathImpl> fromTo = new HashMap<JGitPathImpl, JGitPathImpl>();
        for (Path path : this.newDirectoryStream((Path)source, null)) {
            JGitPathImpl gPath = this.toPathImpl(path);
            Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
            if (pathResult.getK1() == JGitUtil.PathType.DIRECTORY) {
                fromTo.putAll(this.mapDirectoryContent(gPath, this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]), new CopyOption[0]));
                continue;
            }
            JGitPathImpl gTarget = this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]);
            fromTo.put(gPath, gTarget);
        }
        return fromTo;
    }

    private void moveFiles(JGitPathImpl source, JGitPathImpl target, Map<JGitPathImpl, JGitPathImpl> fromTo, CopyOption ... options) {
        HashMap<String, String> result = new HashMap<String, String>(fromTo.size());
        for (Map.Entry<JGitPathImpl, JGitPathImpl> fromToEntry : fromTo.entrySet()) {
            result.put(JGitUtil.fixPath(fromToEntry.getKey().getPath()), JGitUtil.fixPath(fromToEntry.getValue().getPath()));
        }
        this.commit(source, this.buildCommitInfo("moving from {" + source.getPath() + "} to {" + target.getPath() + "}", Arrays.asList(options)), new MoveCommitContent(result));
    }

    private void copyFiles(JGitPathImpl source, JGitPathImpl target, Map<JGitPathImpl, JGitPathImpl> sourceDest, CopyOption ... options) {
        HashMap<String, String> result = new HashMap<String, String>(sourceDest.size());
        for (Map.Entry<JGitPathImpl, JGitPathImpl> sourceDestEntry : sourceDest.entrySet()) {
            result.put(JGitUtil.fixPath(sourceDestEntry.getKey().getPath()), JGitUtil.fixPath(sourceDestEntry.getValue().getPath()));
        }
        this.commit(source, this.buildCommitInfo("copy from {" + source.getPath() + "} to {" + target.getPath() + "}", Arrays.asList(options)), new CopyCommitContent(result));
    }

    public boolean isSameFile(Path pathA, Path pathB) throws IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"pathA", (Object)pathA);
        PortablePreconditions.checkNotNull((String)"pathB", (Object)pathB);
        JGitPathImpl gPathA = this.toPathImpl(pathA);
        JGitPathImpl gPathB = this.toPathImpl(pathB);
        Pair<JGitUtil.PathType, ObjectId> resultA = JGitUtil.checkPath(((JGitFileSystem)gPathA.getFileSystem()).gitRepo(), gPathA.getRefTree(), gPathA.getPath());
        Pair<JGitUtil.PathType, ObjectId> resultB = JGitUtil.checkPath(((JGitFileSystem)gPathB.getFileSystem()).gitRepo(), gPathB.getRefTree(), gPathB.getPath());
        if (resultA.getK1() == JGitUtil.PathType.FILE && ((ObjectId)resultA.getK2()).equals((AnyObjectId)resultB.getK2())) {
            return true;
        }
        return pathA.equals(pathB);
    }

    public boolean isHidden(Path path) throws IllegalArgumentException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        if (gPath.getFileName() == null) {
            return false;
        }
        return this.toPathImpl(path.getFileName()).toString(false).startsWith(".");
    }

    public FileStore getFileStore(Path path) throws IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return new JGitFileStore(((JGitFileSystem)this.toPathImpl(path).getFileSystem()).gitRepo().getRepository());
    }

    public void checkAccess(Path path, AccessMode ... modes) throws UnsupportedOperationException, NoSuchFileException, AccessDeniedException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> result = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)result.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
    }

    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) throws NoSuchFileException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"type", type);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)pathResult.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        FileAttributeView resultView = (FileAttributeView)gPath.getAttrView(type);
        if (resultView == null) {
            if (type == BasicFileAttributeView.class || type == JGitBasicAttributeView.class) {
                JGitBasicAttributeView newView = new JGitBasicAttributeView(gPath);
                gPath.addAttrView((AttributeView)newView);
                return (V)((Object)newView);
            }
            if (type == VersionAttributeView.class || type == JGitVersionAttributeView.class) {
                JGitVersionAttributeView newView = new JGitVersionAttributeView(gPath);
                gPath.addAttrView((AttributeView)newView);
                return (V)((Object)newView);
            }
        }
        return (V)resultView;
    }

    private ExtendedAttributeView getFileAttributeView(JGitPathImpl path, String name, LinkOption ... options) {
        ExtendedAttributeView view = (ExtendedAttributeView)path.getAttrView(name);
        if (view == null) {
            if (name.equals("basic")) {
                JGitBasicAttributeView newView = new JGitBasicAttributeView(path);
                path.addAttrView((AttributeView)newView);
                return newView;
            }
            if (name.equals("version")) {
                JGitVersionAttributeView newView = new JGitVersionAttributeView(path);
                path.addAttrView((AttributeView)newView);
                return newView;
            }
        }
        return view;
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"type", type);
        JGitPathImpl gPath = this.toPathImpl(path);
        Pair<JGitUtil.PathType, ObjectId> pathResult = JGitUtil.checkPath(((JGitFileSystem)gPath.getFileSystem()).gitRepo(), gPath.getRefTree(), gPath.getPath());
        if (((JGitUtil.PathType)((Object)pathResult.getK1())).equals((Object)JGitUtil.PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        if (type == VersionAttributes.class) {
            JGitVersionAttributeView view = this.getFileAttributeView(path, JGitVersionAttributeView.class, options);
            return (A)view.readAttributes();
        }
        if (type == BasicFileAttributesImpl.class || type == BasicFileAttributes.class) {
            JGitBasicAttributeView view = this.getFileAttributeView(path, JGitBasicAttributeView.class, options);
            return (A)view.readAttributes();
        }
        return null;
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotEmpty((String)"attributes", (String)attributes);
        String[] s = this.split(attributes);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attributes);
        }
        ExtendedAttributeView view = this.getFileAttributeView(this.toPathImpl(path), s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        return view.readAttributes(s[1].split(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotEmpty((String)"attributes", (String)attribute);
        if (attribute.equals("SQUASH_ATTR") && value instanceof SquashOption) {
            this.lockAndSquash(path, (SquashOption)value);
            return;
        }
        if (attribute.equals(FileSystemState.FILE_SYSTEM_STATE_ATTR)) {
            JGitFileSystem fileSystem = (JGitFileSystem)path.getFileSystem();
            try {
                fileSystem.lock();
                if (value instanceof CommentedOption) {
                    fileSystem.setBatchCommitInfo("Batch mode", (CommentedOption)value);
                    fileSystem.unlock();
                    return;
                }
                boolean isOriginalStateBatch = fileSystem.isOnBatch();
                fileSystem.setState(value.toString());
                FileSystemState.valueOf((String)value.toString());
                if (isOriginalStateBatch && !fileSystem.isOnBatch()) {
                    fileSystem.setBatchCommitInfo(null);
                    this.notifyAllDiffs();
                }
                fileSystem.setHadCommitOnBatchState(false);
            }
            finally {
                fileSystem.unlock();
            }
            return;
        }
        String[] s = this.split(attribute);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attribute);
        }
        ExtendedAttributeView view = this.getFileAttributeView(this.toPathImpl(path), s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        view.setAttribute(s[1], value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndSquash(Path path, SquashOption value) {
        JGitFileSystem fileSystem = (JGitFileSystem)path.getFileSystem();
        try {
            fileSystem.lock();
            JGitPathImpl gSource = this.toPathImpl(path);
            Git git = ((JGitFileSystem)gSource.getFileSystem()).gitRepo();
            String branch = this.getBranchName(gSource);
            String commitMessage = PortablePreconditions.checkNotEmpty((String)"commitMessage", (String)value.getMessage());
            String startCommit = PortablePreconditions.checkNotEmpty((String)"startCommit", (String)value.getRecord().id());
            new Squash(git, branch, startCommit, commitMessage).execute();
        }
        finally {
            fileSystem.unlock();
        }
    }

    private String getBranchName(JGitPathImpl gSource) {
        try {
            return ((JGitFileSystem)gSource.getFileSystem()).gitRepo().getRepository().getBranch();
        }
        catch (java.io.IOException e) {
            throw new IOException("Impossible to get Branch Name", (Exception)e);
        }
    }

    private void checkURI(String paramName, URI uri) throws IllegalArgumentException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getAuthority() == null || uri.getAuthority().isEmpty()) {
            throw new IllegalArgumentException("Parameter named '" + paramName + "' is invalid, missing host repository!");
        }
        int atIndex = uri.getPath().indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@") && uri.getPath().indexOf("/", atIndex) == -1) {
            throw new IllegalArgumentException("Parameter named '" + paramName + "' is invalid, missing host repository!");
        }
    }

    public String extractHost(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        String host = uri.getAuthority();
        String path = uri.getPath();
        int atIndex = path.indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@")) {
            int slashAfterAt = path.indexOf("/", path.indexOf("/", atIndex) + 1);
            if (slashAfterAt != -1) {
                return host + path.substring(0, slashAfterAt);
            }
            return host;
        }
        int secondSlash = path.indexOf("/", 1);
        if (secondSlash != -1) {
            return host + path.substring(0, path.indexOf("/", 1));
        }
        return host + path;
    }

    public String extractOldHost(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        int atIndex = uri.getPath().indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@")) {
            return uri.getAuthority() + uri.getPath().substring(0, uri.getPath().indexOf("/", atIndex));
        }
        return uri.getAuthority();
    }

    public String extractRepoNameWithFolder(URI uri) {
        String complex;
        String path;
        int pathIndex;
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        String host = this.extractHost(uri);
        int index = host.indexOf(64);
        if (index != -1) {
            host = host.substring(index + 1);
        }
        if ((pathIndex = (path = uri.getPath()).indexOf(complex = "@" + host)) != -1) {
            path = path.substring(pathIndex + complex.length());
        }
        return host;
    }

    private String extractRepoNameWithoutFolder(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        String host = this.extractOldHost(uri);
        int index = host.indexOf(64);
        if (index != -1) {
            return host.substring(index + 1);
        }
        return host;
    }

    private boolean hasSyncFlag(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return uri.getQuery() != null && uri.getQuery().contains("sync");
    }

    private boolean hasForceFlag(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return uri.getQuery() != null && uri.getQuery().contains("force");
    }

    private boolean hasPushFlag(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return uri.getQuery() != null && uri.getQuery().contains("push");
    }

    private static Map<String, String> getQueryParams(URI uri) {
        final String[] params = uri.getQuery().split("&");
        return new HashMap<String, String>(params.length){
            {
                super(x0);
                for (String param : params) {
                    String[] kv = param.split("=");
                    String name = kv[0];
                    String value = kv.length == 2 ? kv[1] : JGitFileSystemProvider.SSH_CERT_PASSPHRASE;
                    this.put(name, value);
                }
            }
        };
    }

    public String extractPath(URI uri) {
        String path;
        int secondIndex;
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        String repoName = this.extractRepoNameWithFolder(uri);
        int authority = 0;
        int index = uri.getAuthority().indexOf("@");
        if (index > 0) {
            authority = uri.getAuthority().substring(0, index + 1).length();
        }
        if ((secondIndex = uri.getPath().indexOf("@")) != -1) {
            authority = uri.getAuthority().length();
            authority += uri.getPath().substring(0, secondIndex + 1).length();
        }
        if ((path = EncodingUtil.decode((String)uri.toString()).substring(this.getSchemeSize(uri) + authority + repoName.length())).startsWith("/:")) {
            return path.substring(2);
        }
        return path;
    }

    public String extractOldPath(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        String host = this.extractOldHost(uri);
        String path = EncodingUtil.decode((String)uri.toString()).substring(this.getSchemeSize(uri) + host.length());
        if (path.startsWith("/:")) {
            return path.substring(2);
        }
        return path;
    }

    private CredentialsProvider buildCredential(Map<String, ?> env) {
        if (env != null && env.containsKey(GIT_ENV_KEY_USER_NAME)) {
            if (env.containsKey(GIT_ENV_KEY_PASSWORD)) {
                return new UsernamePasswordCredentialsProvider(env.get(GIT_ENV_KEY_USER_NAME).toString(), env.get(GIT_ENV_KEY_PASSWORD).toString());
            }
            return new UsernamePasswordCredentialsProvider(env.get(GIT_ENV_KEY_USER_NAME).toString(), SSH_CERT_PASSPHRASE);
        }
        return CredentialsProvider.getDefault();
    }

    private JGitPathImpl toPathImpl(Path path) {
        if (path instanceof JGitPathImpl) {
            return (JGitPathImpl)path;
        }
        throw new IllegalArgumentException("Path not supported by current provider.");
    }

    private String[] split(String attribute) {
        String[] s = new String[2];
        int pos = attribute.indexOf(58);
        if (pos == -1) {
            s[0] = "basic";
            s[1] = attribute;
        } else {
            s[0] = attribute.substring(0, pos);
            s[1] = pos == attribute.length() ? SSH_CERT_PASSPHRASE : attribute.substring(pos + 1);
        }
        return s;
    }

    private int getSchemeSize(URI uri) {
        if (uri.getScheme().equals(SCHEME)) {
            return SCHEME_SIZE;
        }
        return DEFAULT_SCHEME_SIZE;
    }

    private void delete(final JGitPathImpl path, CommitInfo commitInfo) {
        this.commit(path, commitInfo, new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
            {
                this.put(path.getPath(), null);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(JGitPathImpl path, CommitInfo commitInfo, CommitContent commitContent) {
        JGitFileSystem fileSystem = (JGitFileSystem)path.getFileSystem();
        fileSystem.lock();
        Git git = fileSystem.gitRepo();
        String branchName = path.getRefTree();
        boolean batchState = fileSystem.isOnBatch();
        boolean amend = batchState && fileSystem.isHadCommitOnBatchState(path.getRoot());
        ObjectId oldHead = JGitUtil.getTreeRefObjectId(((JGitFileSystem)path.getFileSystem()).gitRepo().getRepository(), branchName);
        boolean hasCommit = batchState && fileSystem.getBatchCommitInfo() != null ? JGitUtil.commit(git, branchName, fileSystem.getBatchCommitInfo(), amend, commitContent) : JGitUtil.commit(git, branchName, commitInfo, amend, commitContent);
        if (!batchState) {
            int value;
            if (hasCommit && (value = fileSystem.incrementAndGetCommitCount()) >= this.commitLimit) {
                JGitUtil.gc(git);
                fileSystem.resetCommitCount();
            }
            ObjectId newHead = JGitUtil.getTreeRefObjectId(((JGitFileSystem)path.getFileSystem()).gitRepo().getRepository(), branchName);
            this.postCommitHook(git.getRepository());
            this.notifyDiffs((JGitFileSystem)path.getFileSystem(), branchName, commitInfo.getSessionId(), commitInfo.getName(), commitInfo.getMessage(), oldHead, newHead);
        } else {
            Object object = this.oldHeadsOfPendingDiffsLock;
            synchronized (object) {
                if (!this.oldHeadsOfPendingDiffs.containsKey(path.getFileSystem()) || !this.oldHeadsOfPendingDiffs.get(path.getFileSystem()).containsKey(branchName)) {
                    if (!this.oldHeadsOfPendingDiffs.containsKey(path.getFileSystem())) {
                        this.oldHeadsOfPendingDiffs.put((JGitFileSystem)path.getFileSystem(), new ConcurrentHashMap());
                    }
                    if (fileSystem.getBatchCommitInfo() != null) {
                        this.oldHeadsOfPendingDiffs.get(path.getFileSystem()).put(branchName, new NotificationModel(oldHead, fileSystem.getBatchCommitInfo().getSessionId(), fileSystem.getBatchCommitInfo().getName(), fileSystem.getBatchCommitInfo().getMessage()));
                    } else {
                        this.oldHeadsOfPendingDiffs.get(path.getFileSystem()).put(branchName, new NotificationModel(oldHead, commitInfo.getSessionId(), commitInfo.getName(), commitInfo.getMessage()));
                    }
                }
            }
        }
        if (((JGitFileSystem)path.getFileSystem()).isOnBatch() && !fileSystem.isHadCommitOnBatchState(path.getRoot())) {
            fileSystem.setHadCommitOnBatchState(path.getRoot(), hasCommit);
        }
        fileSystem.unlock();
    }

    private void postCommitHook(Repository repository) {
        this.detectedFS.runHookIfPresent(repository, "post-commit", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllDiffs() {
        Object object = this.oldHeadsOfPendingDiffsLock;
        synchronized (object) {
            for (Map.Entry<JGitFileSystem, Map<String, NotificationModel>> jGitFileSystemMapEntry : this.oldHeadsOfPendingDiffs.entrySet()) {
                for (Map.Entry<String, NotificationModel> branchNameNotificationModelEntry : jGitFileSystemMapEntry.getValue().entrySet()) {
                    ObjectId newHead = JGitUtil.getTreeRefObjectId(jGitFileSystemMapEntry.getKey().gitRepo().getRepository(), branchNameNotificationModelEntry.getKey());
                    try {
                        this.notifyDiffs(jGitFileSystemMapEntry.getKey(), branchNameNotificationModelEntry.getKey(), branchNameNotificationModelEntry.getValue().getSessionId(), branchNameNotificationModelEntry.getValue().getUserName(), branchNameNotificationModelEntry.getValue().getMessage(), branchNameNotificationModelEntry.getValue().getOriginalHead(), newHead);
                    }
                    catch (Exception ex) {
                        LOG.error(String.format("Couldn't produce diff notification for repository `%s` branch `%s`.", jGitFileSystemMapEntry.getKey().toString(), branchNameNotificationModelEntry.getKey()), (Throwable)ex);
                    }
                }
            }
            for (JGitFileSystem fileSystem : this.oldHeadsOfPendingDiffs.keySet()) {
                int value = fileSystem.incrementAndGetCommitCount();
                if (value < this.commitLimit) continue;
                JGitUtil.gc(fileSystem.gitRepo());
                fileSystem.resetCommitCount();
            }
            this.oldHeadsOfPendingDiffs.clear();
        }
    }

    void notifyDiffs(JGitFileSystem fs, String _tree, String sessionId, String userName, String message, ObjectId oldHead, ObjectId newHead) {
        String tree = _tree.startsWith("refs/") ? _tree.substring(_tree.lastIndexOf("/") + 1) : _tree;
        String host = tree + "@" + fs.getName();
        JGitPathImpl root = JGitPathImpl.createRoot(fs, "/", host, false);
        List<DiffEntry> diff = JGitUtil.getDiff(fs.gitRepo().getRepository(), oldHead, newHead);
        ArrayList events = new ArrayList(diff.size());
        for (final DiffEntry diffEntry : diff) {
            JGitPathImpl newPath;
            JGitPathImpl oldPath = !diffEntry.getOldPath().equals("/dev/null") ? JGitPathImpl.create(fs, "/" + diffEntry.getOldPath(), host, null, false) : null;
            if (!diffEntry.getNewPath().equals("/dev/null")) {
                JGitUtil.JGitPathInfo pathInfo = JGitUtil.resolvePath(fs.gitRepo(), tree, diffEntry.getNewPath());
                newPath = JGitPathImpl.create(fs, "/" + pathInfo.getPath(), host, pathInfo.getObjectId(), false);
            } else {
                newPath = null;
            }
            events.add(new WatchEvent((Path)newPath, (Path)oldPath, sessionId, message, userName){
                final /* synthetic */ Path val$newPath;
                final /* synthetic */ Path val$oldPath;
                final /* synthetic */ String val$sessionId;
                final /* synthetic */ String val$message;
                final /* synthetic */ String val$userName;
                {
                    this.val$newPath = path;
                    this.val$oldPath = path2;
                    this.val$sessionId = string;
                    this.val$message = string2;
                    this.val$userName = string3;
                }

                public WatchEvent.Kind kind() {
                    DiffEntry.ChangeType changeType = diffEntry.getChangeType();
                    switch (changeType) {
                        case ADD: 
                        case COPY: {
                            return StandardWatchEventKind.ENTRY_CREATE;
                        }
                        case DELETE: {
                            return StandardWatchEventKind.ENTRY_DELETE;
                        }
                        case MODIFY: {
                            return StandardWatchEventKind.ENTRY_MODIFY;
                        }
                        case RENAME: {
                            return StandardWatchEventKind.ENTRY_RENAME;
                        }
                    }
                    throw new RuntimeException("Unsupported change type: " + changeType);
                }

                public int count() {
                    return 1;
                }

                public Object context() {
                    return new WatchContext(){

                        public Path getPath() {
                            return val$newPath;
                        }

                        public Path getOldPath() {
                            return val$oldPath;
                        }

                        public String getSessionId() {
                            return val$sessionId;
                        }

                        public String getMessage() {
                            return val$message;
                        }

                        public String getUser() {
                            return val$userName;
                        }
                    };
                }

                public String toString() {
                    return "WatchEvent{newPath=" + this.val$newPath + ", oldPath=" + this.val$oldPath + ", sessionId='" + this.val$sessionId + '\'' + ", userName='" + this.val$userName + '\'' + ", message='" + this.val$message + '\'' + ", changeType=" + diffEntry.getChangeType() + '}';
                }
            });
        }
        if (!events.isEmpty()) {
            fs.publishEvents((Path)root, events);
        }
    }

    GitSSHService getGitSSHService() {
        return this.gitSSHService;
    }

    public void setDetectedFS(FS detectedFS) {
        this.detectedFS = detectedFS;
    }

    private static class ExecutorWrapper
    implements Executor {
        private final DisposableExecutor simpleAsyncExecutor;

        public ExecutorWrapper(DisposableExecutor simpleAsyncExecutor) {
            this.simpleAsyncExecutor = (DisposableExecutor)PortablePreconditions.checkNotNull((String)"simpleAsyncExecutor", (Object)simpleAsyncExecutor);
        }

        @Override
        public void execute(Runnable command) {
            this.simpleAsyncExecutor.execute(command);
        }
    }

    public class RepositoryResolverImpl<T>
    implements RepositoryResolver<T> {
        public Repository open(T client, String name) throws RepositoryNotFoundException, ServiceNotAuthorizedException, ServiceNotEnabledException, ServiceMayNotContinueException {
            JGitFileSystem fs = (JGitFileSystem)JGitFileSystemProvider.this.fileSystems.get(name);
            if (fs == null) {
                throw new RepositoryNotFoundException(name);
            }
            return fs.gitRepo().getRepository();
        }

        public JGitFileSystem resolveFileSystem(Repository repository) {
            return (JGitFileSystem)JGitFileSystemProvider.this.repoIndex.get(repository);
        }
    }
}

