/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IllegalTodoFileModification;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.commands.Squash;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitSquashingTest
extends AbstractTestInfra {
    private Logger logger = LoggerFactory.getLogger(JGitSquashingTest.class);

    @Test
    public void rawRebaseWithFixUp() throws IOException, GitAPIException {
        this.logger.info(">>>>>>>>>>>>>>>>>>> rawRebaseWithFixUp");
        File parentFolder = JGitSquashingTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "myrepo.git");
        Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        File gitClonedFolder = new File(parentFolder, "myclone.git");
        Git clone = JGitUtil.cloneRepository((File)gitClonedFolder, (String)origin.getRepository().getDirectory().toString(), (boolean)false, (CredentialsProvider)CredentialsProvider.getDefault());
        this.createAddAndCommitFile(clone, "testfile0");
        Iterable logs = clone.log().all().setMaxCount(1).call();
        Iterator iterator = logs.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        RevCommit firstCommit = (RevCommit)iterator.next();
        this.createAddAndCommitFile(clone, "testfile1");
        this.createAddAndCommitFile(clone, "testfile2");
        this.createAddAndCommitFile(clone, "testfile3");
        logs = clone.log().all().setMaxCount(1).call();
        iterator = logs.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        RevCommit thirdCommit = (RevCommit)iterator.next();
        this.createAddAndCommitFile(clone, "testfile4");
        String squashedCommitMessage = "I'm here to squash some changes";
        final RevCommit lastSquashedCommit = thirdCommit;
        RebaseCommand.InteractiveHandler handler = new RebaseCommand.InteractiveHandler(){

            public void prepareSteps(List<RebaseTodoLine> steps) {
                try {
                    int counter = 0;
                    for (RebaseTodoLine step : steps) {
                        if (counter == 0) {
                            step.setAction(RebaseTodoLine.Action.PICK);
                        } else {
                            step.setAction(RebaseTodoLine.Action.SQUASH);
                        }
                        if (step.getCommit().prefixCompare((AnyObjectId)lastSquashedCommit) != 0) {
                            ++counter;
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalTodoFileModification ex) {
                    JGitSquashingTest.this.logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }

            public String modifyCommitMessage(String oldMessage) {
                return "I'm here to squash some changes";
            }
        };
        this.logger.info("#### Before Rebase");
        int counter = 0;
        for (RevCommit commit : clone.log().all().call()) {
            this.logger.info(">Commit: " + commit.getFullMessage());
            ++counter;
        }
        this.logger.info("#### Before Rebase Commits: " + counter);
        RebaseResult rebaseResult = clone.rebase().setUpstream(firstCommit).runInteractively(handler).call();
        Assertions.assertThat((Object)rebaseResult.getStatus()).isSameAs((Object)RebaseResult.Status.OK);
        this.logger.info("#### After Rebase");
        counter = 0;
        for (RevCommit commit : clone.log().all().call()) {
            this.logger.info(">Commit: " + commit.getFullMessage());
            ++counter;
        }
        this.logger.info("#### After Rebase Commits: " + counter);
        this.logger.info(">>>>>>>>>>>>>>>>>>> END rawRebaseWithFixUp");
    }

    @Test
    public void testSquash4Of5Commits() throws IOException, GitAPIException {
        File parentFolder = JGitSquashingTest.createTempDirectory();
        this.logger.info(">> Parent Forlder for the Test: " + parentFolder.getAbsolutePath());
        File gitFolder = new File(parentFolder, "my-local-repo.git");
        Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 1!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", JGitSquashingTest.this.tempFile("initial content file 1"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 2!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitSquashingTest.this.tempFile("initial content file 2"));
            }
        });
        Iterable logs = origin.log().setMaxCount(1).all().call();
        RevCommit secondCommit = (RevCommit)logs.iterator().next();
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 3!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", JGitSquashingTest.this.tempFile("new content file 1"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 4!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitSquashingTest.this.tempFile("new content file 2"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 5!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file3.txt", JGitSquashingTest.this.tempFile("initial content file 3"));
            }
        });
        logs = origin.log().all().call();
        int commitsCount = 0;
        for (RevCommit commit : logs) {
            this.logger.info(">>> Origin Commit: " + commit.getFullMessage() + " - " + commit.toString());
            ++commitsCount;
        }
        Assertions.assertThat((int)commitsCount).isEqualTo(5);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"pathx/").getK1()).isEqualTo((Object)JGitUtil.PathType.NOT_FOUND);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"path/to/file1.txt").getK1()).isEqualTo((Object)JGitUtil.PathType.FILE);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"path/to/file2.txt").getK1()).isEqualTo((Object)JGitUtil.PathType.FILE);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"path/to/file3.txt").getK1()).isEqualTo((Object)JGitUtil.PathType.FILE);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"path/to").getK1()).isEqualTo((Object)JGitUtil.PathType.DIRECTORY);
        this.logger.info("Squashing from " + secondCommit.getName() + "  to HEAD");
        new Squash(origin, "master", secondCommit.getName(), "squashed message").execute();
        commitsCount = 0;
        for (RevCommit commit : origin.log().all().call()) {
            this.logger.info(">>> Final Commit: " + commit.getFullMessage() + " - " + commit.toString());
            ++commitsCount;
        }
        Assertions.assertThat((int)commitsCount).isEqualTo(2);
    }

    @Test
    public void testFailWhenTryToSquashCommitsFromDifferentBranches() throws IOException, GitAPIException {
        File parentFolder = JGitSquashingTest.createTempDirectory();
        this.logger.info(">> Parent Forlder for the Test: " + parentFolder.getAbsolutePath());
        File gitFolder = new File(parentFolder, "my-local-repo.git");
        Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"aparedes", (String)"aparedes@example.com", (String)"commit 1!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", JGitSquashingTest.this.tempFile("initial content file 1"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 2!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitSquashingTest.this.tempFile("initial content file 2"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"aparedes", (String)"aparedes@example.com", (String)"commit 3!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file3.txt", JGitSquashingTest.this.tempFile("initial content file 1"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"aparedes", (String)"aparedes@example.com", (String)"commit 4!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file4.txt", JGitSquashingTest.this.tempFile("initial content file 1"));
            }
        });
        List<RevCommit> masterCommits = this.getCommitsFromBranch(origin, "master");
        List<RevCommit> developCommits = this.getCommitsFromBranch(origin, "develop");
        Assertions.assertThat((int)masterCommits.size()).isEqualTo(3);
        Assertions.assertThat((int)developCommits.size()).isEqualTo(1);
        try {
            new Squash(origin, "master", developCommits.get(0).getName(), "squashed message").execute();
            Assertions.fail((String)"If it reaches here the test has failed because he found the commit into the branch");
        }
        catch (GitException e) {
            this.logger.info(e.getMessage());
            Assertions.assertThat((Throwable)e).isNotNull();
        }
    }

    private List<RevCommit> getCommitsFromBranch(Git origin, String branch) throws GitAPIException, MissingObjectException, IncorrectObjectTypeException {
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        ObjectId id = JGitUtil.resolveObjectId((Git)origin, (String)branch);
        for (RevCommit commit : origin.log().add((AnyObjectId)id).call()) {
            this.logger.info(">>> " + branch + " Commits: " + commit.getFullMessage() + " - " + commit.toString());
            commits.add(commit);
        }
        return commits;
    }

    @Test
    public void testSquashCommitsWithDifferentPaths() throws IOException, GitAPIException {
        File parentFolder = JGitSquashingTest.createTempDirectory();
        this.logger.info(">> Parent Folder for the Test: " + parentFolder.getAbsolutePath());
        File gitFolder = new File(parentFolder, "my-local-repo.git");
        Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)true);
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 1!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitSquashingTest.this.tempFile("initial content file 1"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 2!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitSquashingTest.this.tempFile("initial content file 2"));
            }
        });
        Iterable logs = origin.log().setMaxCount(1).all().call();
        RevCommit secondCommit = (RevCommit)logs.iterator().next();
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 3!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitSquashingTest.this.tempFile("new content file 1"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 4!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", JGitSquashingTest.this.tempFile("new content file 2"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"salaboy", (String)"salaboy@example.com", (String)"commit 5!", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("path/file3.txt", JGitSquashingTest.this.tempFile("initial content file 3"));
            }
        });
        for (RevCommit commit : origin.log().all().call()) {
            this.logger.info(">>> Origin Commit: " + commit.getFullMessage() + " - " + commit.toString());
        }
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"pathx/").getK1()).isEqualTo((Object)JGitUtil.PathType.NOT_FOUND);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"file1.txt").getK1()).isEqualTo((Object)JGitUtil.PathType.FILE);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"path/to/file2.txt").getK1()).isEqualTo((Object)JGitUtil.PathType.FILE);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"path/file3.txt").getK1()).isEqualTo((Object)JGitUtil.PathType.FILE);
        Assertions.assertThat((Object)JGitUtil.checkPath((Git)origin, (String)"master", (String)"path/to").getK1()).isEqualTo((Object)JGitUtil.PathType.DIRECTORY);
        this.logger.info("Squashing from " + secondCommit.getName() + "  to HEAD");
        new Squash(origin, "master", secondCommit.getName(), "squashed message").execute();
        int commitsCount = 0;
        for (RevCommit commit : origin.log().all().call()) {
            this.logger.info(">>> Final Commit: " + commit.getFullMessage() + " - " + commit.toString());
            ++commitsCount;
        }
        Assertions.assertThat((int)commitsCount).isEqualTo(2);
    }

    @Test(expected=IllegalStateException.class)
    public void repositoryIsBareTest() throws IOException {
        File parentFolder = JGitSquashingTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "myrepo.git");
        Git origin = JGitUtil.newRepository((File)gitFolder, (boolean)false);
        new Squash(origin, "master", null, "squashed message").execute();
    }

    private void createAddAndCommitFile(Git git, String file) throws GitAPIException, IOException {
        File myfile = new File(git.getRepository().getDirectory().getParent(), file);
        myfile.createNewFile();
        git.add().addFilepattern(file).call();
        git.commit().setMessage("Added " + file).call();
    }

    static {
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("guest", ""));
    }
}

