/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.FileUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public abstract class AbstractTestInfra {
    protected static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();
    private static final Logger logger = LoggerFactory.getLogger(AbstractTestInfra.class);
    private static final List<File> tempFiles = new ArrayList<File>();
    protected JGitFileSystemProvider provider;

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            try {
                FileUtils.delete((File)tempFile, (int)1);
            }
            catch (IOException iOException) {}
        }
    }

    protected static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Can't find free port!");
        }
        logger.debug("Found free port " + port);
        return port;
    }

    @Before
    public void createGitFsProvider() {
        this.provider = new JGitFileSystemProvider(this.getGitPreferences());
    }

    public Map<String, String> getGitPreferences() {
        HashMap<String, String> gitPrefs = new HashMap<String, String>();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "false");
        gitPrefs.put("org.uberfire.nio.git.ssh.enabled", "false");
        return gitPrefs;
    }

    @After
    public void destroyGitFsProvider() throws IOException {
        if (this.provider == null) {
            return;
        }
        this.provider.shutdown();
        if (this.provider.getGitRepoContainerDir() != null && this.provider.getGitRepoContainerDir().exists()) {
            FileUtils.delete((File)this.provider.getGitRepoContainerDir(), (int)1);
        }
    }

    protected Git setupGit() throws IOException, GitAPIException {
        return this.setupGit(AbstractTestInfra.createTempDirectory());
    }

    protected Git setupGit(File tempDir) throws IOException, GitAPIException {
        Git git = Git.init().setBare(true).setDirectory(tempDir).call();
        JGitUtil.commit((Git)git, (String)"master", (String)"name", (String)"name@example.com", (String)"cool1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.this.tempFile("content"));
                this.put("file2.txt", AbstractTestInfra.this.tempFile("content2"));
            }
        });
        return git;
    }

    public File tempFile(String content) throws IOException {
        File file = File.createTempFile("bar", "foo");
        FileOutputStream out = new FileOutputStream(file);
        if (content != null && !content.isEmpty()) {
            ((OutputStream)out).write(content.getBytes());
            out.flush();
        }
        ((OutputStream)out).close();
        return file;
    }

    public File tempFile(byte[] content) throws IOException {
        File file = File.createTempFile("bar", "foo");
        FileOutputStream out = new FileOutputStream(file);
        if (content != null && content.length > 0) {
            out.write(content);
            out.flush();
        }
        out.close();
        return file;
    }

    public PersonIdent getAuthor() {
        return new PersonIdent("user", "user@example.com");
    }

    protected byte[] loadImage(String path) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer);
        return writer.toString().getBytes();
    }
}

