/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.UsernamePasswordCredentialsProvider;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.security.FileSystemAuthenticator;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;

public class JGitFileSystemProviderSSHTest
extends AbstractTestInfra {
    private int gitSSHPort;

    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.ssh.enabled", "true");
        this.gitSSHPort = JGitFileSystemProviderSSHTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.ssh.port", String.valueOf(this.gitSSHPort));
        gitPrefs.put("org.uberfire.nio.git.ssh.idle.timeout", "10001");
        return gitPrefs;
    }

    @Test
    public void testSSHPostReceiveHook() throws IOException {
        Assume.assumeFalse((String)"UF-511", (boolean)System.getProperty("java.vendor").equals("IBM Corporation"));
        this.provider.setAuthenticator(new FileSystemAuthenticator(){

            public FileSystemUser authenticate(String username, String password) {
                return new FileSystemUser(){

                    public String getName() {
                        return "admin";
                    }
                };
            }
        });
        this.provider.setAuthorizer(new FileSystemAuthorizer(){

            public boolean authorize(FileSystem fs, FileSystemUser fileSystemUser) {
                return true;
            }
        });
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("admin", ""));
        Assert.assertEquals((Object)"10001", this.provider.getGitSSHService().getProperties().get("idle-timeout"));
        URI originRepo = URI.create("git://repo");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, (Map)new HashMap<String, Object>(){
            {
                this.put("listMode", "ALL");
            }
        });
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file-name.txt", JGitFileSystemProviderSSHTest.this.tempFile("temp1"));
            }
        });
        JGitFileSystem clone = (JGitFileSystem)this.provider.newFileSystem(URI.create("git://repo-clone"), (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
                this.put("origin", "ssh://admin@localhost:" + JGitFileSystemProviderSSHTest.this.gitSSHPort + "/repo");
            }
        });
        Assert.assertNotNull((Object)clone);
        this.provider.getFileSystem(URI.create("git://repo-clone?push=ssh://admin@localhost:" + this.gitSSHPort + "/repo"));
    }
}

