/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;

public abstract class BaseGitCommand
implements Command,
SessionAware,
Runnable {
    public static final Session.AttributeKey<FileSystemUser> SUBJECT_KEY = new Session.AttributeKey();
    protected final String command;
    protected final String repositoryName;
    protected final FileSystemAuthorizer fileSystemAuthorizer;
    protected final JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver;
    private final ExecutorService executorService;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private FileSystemUser user;

    public BaseGitCommand(String command, FileSystemAuthorizer fileSystemAuthorizer, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, ExecutorService executorService) {
        this.command = command;
        this.fileSystemAuthorizer = fileSystemAuthorizer;
        this.repositoryName = this.buildRepositoryName(command);
        this.repositoryResolver = repositoryResolver;
        this.executorService = executorService;
    }

    private String buildRepositoryName(String command) {
        int start = this.getCommandName().length() + 2;
        String temp = command.substring(start);
        return temp.substring(0, temp.indexOf("'"));
    }

    protected abstract String getCommandName();

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
        if (out instanceof ChannelOutputStream) {
            ((ChannelOutputStream)out).setNoDelay(true);
        }
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
        if (err instanceof ChannelOutputStream) {
            ((ChannelOutputStream)err).setNoDelay(true);
        }
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        this.executorService.execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Git Command [" + this.getClass().getName() + "]";
            }

            public void run() {
                BaseGitCommand.this.run();
            }
        });
    }

    @Override
    public void run() {
        try {
            Repository repository = this.openRepository(this.repositoryName);
            if (repository != null) {
                JGitFileSystem fileSystem = this.repositoryResolver.resolveFileSystem(repository);
                if (this.fileSystemAuthorizer.authorize((FileSystem)fileSystem, this.user)) {
                    this.execute(this.user, repository, this.in, this.out, this.err, fileSystem);
                } else {
                    this.err.write("Invalid credentials.".getBytes());
                }
            } else {
                this.err.write("Can't resolve repository name.".getBytes());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.callback != null) {
            this.callback.onExit(0);
        }
    }

    private Repository openRepository(String name) throws ServiceMayNotContinueException {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open(this, name.substring(1));
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
        catch (ServiceNotAuthorizedException e) {
            return null;
        }
        catch (ServiceNotEnabledException e) {
            return null;
        }
    }

    protected abstract void execute(FileSystemUser var1, Repository var2, InputStream var3, OutputStream var4, OutputStream var5, JGitFileSystem var6);

    public void destroy() {
    }

    public FileSystemUser getUser() {
        return this.user;
    }

    public void setSession(ServerSession session) {
        this.user = (FileSystemUser)session.getAttribute(SUBJECT_KEY);
    }
}

