/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class JGitFileSystemProviderDiffTest
extends AbstractTestInfra {
    private Logger logger = LoggerFactory.getLogger(JGitFileSystemProviderDiffTest.class);

    @Test
    public void testDiffsBetweenBranches() throws IOException {
        File parentFolder = JGitFileSystemProviderDiffTest.createTempDirectory();
        File gitSource = new File(parentFolder, "repo.git");
        final Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        Repository gitRepo = origin.getRepository();
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"master-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitFileSystemProviderDiffTest.this.tempFile("temp1\ntemp1\ntemp3\nmiddle\nmoremiddle\nmoremiddle\nmoremiddle\nother\n"));
            }
        });
        JGitUtil.createBranch((Git)origin, (String)"master", (String)"develop");
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitFileSystemProviderDiffTest.this.tempFile("temp1\ntemp2\nmiddle\nmoremiddle\nmoremiddle\nmoremiddle\n"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-2", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", JGitFileSystemProviderDiffTest.this.tempFile("temp3"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-3", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", JGitFileSystemProviderDiffTest.this.tempFile("temp4"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"develop", (String)"name", (String)"name@example.com", (String)"develop-4", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", JGitFileSystemProviderDiffTest.this.tempFile("temp5"));
            }
        });
        URI newRepo = URI.create("git://diff-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        this.provider.newFileSystem(newRepo, (Map)env);
        Path path = this.provider.getPath(newRepo);
        List diffs = (List)this.provider.readAttributes(path, "diff:master,develop", new LinkOption[0]).get("diff");
        diffs.forEach(elem -> this.logger.info(elem.toString()));
        Assertions.assertThat((int)diffs.size()).isEqualTo(5);
    }

    @Test
    public void testBranchesDoNotHaveDifferences() throws IOException {
        File parentFolder = JGitFileSystemProviderDiffTest.createTempDirectory();
        File gitSource = new File(parentFolder, "repo.git");
        final Git origin = JGitUtil.newRepository((File)gitSource, (boolean)true);
        Repository gitRepo = origin.getRepository();
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"master-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitFileSystemProviderDiffTest.this.tempFile("temp1\ntemp1\ntemp3\nmiddle\nmoremiddle\nmoremiddle\nmoremiddle\nother\n"));
            }
        });
        JGitUtil.commit((Git)origin, (String)"master", (String)"name", (String)"name@example.com", (String)"develop-1", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitFileSystemProviderDiffTest.this.tempFile("temp1\ntemp2\nmiddle\nmoremiddle\nmoremiddle\nmoremiddle\n"));
            }
        });
        JGitUtil.createBranch((Git)origin, (String)"master", (String)"develop");
        URI newRepo = URI.create("git://diff-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        this.provider.newFileSystem(newRepo, (Map)env);
        Path path = this.provider.getPath(newRepo);
        List diffs = (List)this.provider.readAttributes(path, "diff:master,develop", new LinkOption[0]).get("diff");
        diffs.forEach(elem -> this.logger.info(elem.toString()));
        Assertions.assertThat((int)diffs.size()).isEqualTo(0);
    }
}

