/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.TcpipForwarderFactory;
import org.apache.sshd.common.cipher.AES128CTR;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.AES256CTR;
import org.apache.sshd.common.cipher.ARCFOUR128;
import org.apache.sshd.common.cipher.ARCFOUR256;
import org.apache.sshd.common.compression.CompressionNone;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.nativefs.NativeFileSystemFactory;
import org.apache.sshd.common.forward.DefaultTcpipForwarderFactory;
import org.apache.sshd.common.forward.TcpipServerChannel;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.common.mac.HMACSHA256;
import org.apache.sshd.common.mac.HMACSHA512;
import org.apache.sshd.common.random.BouncyCastleRandom;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureECDSA;
import org.apache.sshd.common.signature.SignatureRSA;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.UnknownCommand;
import org.apache.sshd.server.global.CancelTcpipForwardHandler;
import org.apache.sshd.server.global.KeepAliveHandler;
import org.apache.sshd.server.global.NoMoreSessionsHandler;
import org.apache.sshd.server.global.TcpipForwardHandler;
import org.apache.sshd.server.kex.DHG1;
import org.apache.sshd.server.kex.DHG14;
import org.apache.sshd.server.kex.DHGEX;
import org.apache.sshd.server.kex.DHGEX256;
import org.apache.sshd.server.kex.ECDHP256;
import org.apache.sshd.server.kex.ECDHP384;
import org.apache.sshd.server.kex.ECDHP521;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitReceiveCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitUploadCommand;
import org.uberfire.java.nio.security.FileSystemAuthenticator;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;

public class GitSSHService {
    private final SshServer sshd = GitSSHService.buildSshServer();
    private FileSystemAuthenticator fileSystemAuthenticator;
    private FileSystemAuthorizer fileSystemAuthorizer;
    private ExecutorService executorService;

    public static SshServer buildSshServer() {
        SshServer sshd = new SshServer();
        if (SecurityUtils.isBouncyCastleRegistered()) {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new ECDHP256.Factory(), new ECDHP384.Factory(), new ECDHP521.Factory(), new DHG14.Factory(), new DHG1.Factory()));
            sshd.setSignatureFactories(Arrays.asList(new SignatureECDSA.NISTP256Factory(), new SignatureECDSA.NISTP384Factory(), new SignatureECDSA.NISTP521Factory(), new SignatureDSA.Factory(), new SignatureRSA.Factory()));
            sshd.setRandomFactory((Factory)new SingletonRandomFactory((NamedFactory)new BouncyCastleRandom.Factory()));
        } else if (SecurityUtils.hasEcc()) {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new ECDHP256.Factory(), new ECDHP384.Factory(), new ECDHP521.Factory(), new DHG1.Factory()));
            sshd.setSignatureFactories(Arrays.asList(new SignatureECDSA.NISTP256Factory(), new SignatureECDSA.NISTP384Factory(), new SignatureECDSA.NISTP521Factory(), new SignatureDSA.Factory(), new SignatureRSA.Factory()));
            sshd.setRandomFactory((Factory)new SingletonRandomFactory((NamedFactory)new JceRandom.Factory()));
        } else {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new DHG1.Factory()));
            sshd.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory()));
            sshd.setRandomFactory((Factory)new SingletonRandomFactory((NamedFactory)new JceRandom.Factory()));
        }
        GitSSHService.setUpDefaultCiphers(sshd);
        sshd.setCompressionFactories(Arrays.asList(new CompressionNone.Factory()));
        sshd.setMacFactories(Arrays.asList(new HMACSHA256.Factory(), new HMACSHA512.Factory(), new HMACSHA1.Factory(), new HMACMD5.Factory(), new HMACSHA196.Factory(), new HMACMD596.Factory()));
        sshd.setChannelFactories(Arrays.asList(new ChannelSession.Factory(), new TcpipServerChannel.DirectTcpipFactory()));
        sshd.setFileSystemFactory((FileSystemFactory)new NativeFileSystemFactory());
        sshd.setTcpipForwarderFactory((TcpipForwarderFactory)new DefaultTcpipForwarderFactory());
        sshd.setGlobalRequestHandlers(Arrays.asList(new KeepAliveHandler(), new NoMoreSessionsHandler(), new TcpipForwardHandler(), new CancelTcpipForwardHandler()));
        return sshd;
    }

    private static void setUpDefaultCiphers(SshServer sshd) {
        LinkedList<Object> avail = new LinkedList<Object>();
        avail.add(new AES128CTR.Factory());
        avail.add(new AES256CTR.Factory());
        avail.add(new ARCFOUR128.Factory());
        avail.add(new ARCFOUR256.Factory());
        avail.add(new AES192CBC.Factory());
        avail.add(new AES256CBC.Factory());
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            NamedFactory f = (NamedFactory)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                i.remove();
            }
            catch (Exception e) {
                i.remove();
            }
        }
        sshd.setCipherFactories(avail);
    }

    public void setup(File certDir, InetSocketAddress inetSocketAddress, String sshIdleTimeout, String algorithm, final ReceivePackFactory receivePackFactory, final JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, final ExecutorService executorService) {
        PortablePreconditions.checkNotNull((String)"certDir", (Object)certDir);
        PortablePreconditions.checkNotEmpty((String)"sshIdleTimeout", (String)sshIdleTimeout);
        PortablePreconditions.checkNotEmpty((String)"algorithm", (String)algorithm);
        PortablePreconditions.checkNotNull((String)"receivePackFactory", (Object)receivePackFactory);
        PortablePreconditions.checkNotNull((String)"repositoryResolver", repositoryResolver);
        PortablePreconditions.checkNotNull((String)"executorService", (Object)executorService);
        this.executorService = executorService;
        this.sshd.getProperties().put("idle-timeout", sshIdleTimeout);
        if (inetSocketAddress != null) {
            this.sshd.setHost(inetSocketAddress.getHostName());
            this.sshd.setPort(inetSocketAddress.getPort());
        }
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        SimpleGeneratorHostKeyProvider keyPairProvider = new SimpleGeneratorHostKeyProvider(new File(certDir, "hostkey.ser").getAbsolutePath());
        try {
            SecurityUtils.getKeyPairGenerator((String)algorithm);
            keyPairProvider.setAlgorithm(algorithm);
        }
        catch (Exception ignore) {
            throw new RuntimeException(String.format("Can't use '%s' algorithm for ssh key pair generator.", algorithm), ignore);
        }
        this.sshd.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        this.sshd.setCommandFactory(new CommandFactory(){

            public Command createCommand(String command) {
                if (command.startsWith("git-upload-pack")) {
                    return new GitUploadCommand(command, repositoryResolver, GitSSHService.this.getAuthorizationManager(), executorService);
                }
                if (command.startsWith("git-receive-pack")) {
                    return new GitReceiveCommand(command, repositoryResolver, GitSSHService.this.getAuthorizationManager(), (ReceivePackFactory<BaseGitCommand>)receivePackFactory, executorService);
                }
                return new UnknownCommand(command);
            }
        });
        this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                FileSystemUser user = GitSSHService.this.getUserPassAuthenticator().authenticate(username, password);
                if (user == null) {
                    return false;
                }
                session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)user);
                return true;
            }
        });
    }

    public void stop() {
        try {
            this.sshd.stop(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't start SSH daemon at " + this.sshd.getHost() + ":" + this.sshd.getPort(), e);
        }
    }

    public boolean isRunning() {
        return !this.sshd.isClosed() && !this.sshd.isClosing();
    }

    SshServer getSshServer() {
        return this.sshd;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.sshd.getProperties());
    }

    public FileSystemAuthenticator getUserPassAuthenticator() {
        return this.fileSystemAuthenticator;
    }

    public void setUserPassAuthenticator(FileSystemAuthenticator fileSystemAuthenticator) {
        this.fileSystemAuthenticator = fileSystemAuthenticator;
    }

    public FileSystemAuthorizer getAuthorizationManager() {
        return this.fileSystemAuthorizer;
    }

    public void setAuthorizationManager(FileSystemAuthorizer fileSystemAuthorizer) {
        this.fileSystemAuthorizer = fileSystemAuthorizer;
    }
}

