/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.extensions;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.java.nio.fs.jgit.util.extensions.JGitFSHooks;

public class JGitFSHooksTest {
    @Test
    public void executeFSHooksTest() {
        final String fsName = "dora";
        AtomicBoolean executedWithLambda = new AtomicBoolean(false);
        FileSystemHooks.FileSystemHook hook = (FileSystemHooks.FileSystemHook)Mockito.spy((Object)new FileSystemHooks.FileSystemHook<String>(){

            public void execute(String s) {
                Assert.assertEquals((Object)fsName, (Object)s);
            }
        });
        FileSystemHooks.FileSystemHook lambdaHook = s -> {
            Assert.assertEquals((Object)fsName, (Object)s);
            executedWithLambda.set(true);
        };
        JGitFSHooks.executeFSHooks((Object)hook, (FileSystemHooks)FileSystemHooks.ExternalUpdate, (String)fsName);
        JGitFSHooks.executeFSHooks((Object)lambdaHook, (FileSystemHooks)FileSystemHooks.ExternalUpdate, (String)fsName);
        ((FileSystemHooks.FileSystemHook)Mockito.verify((Object)hook)).execute((Object)fsName);
        Assert.assertTrue((boolean)executedWithLambda.get());
    }

    @Test
    public void executeFSHooksArrayTest() {
        final String fsName = "dora";
        AtomicBoolean executedWithLambda = new AtomicBoolean(false);
        FileSystemHooks.FileSystemHook hook = (FileSystemHooks.FileSystemHook)Mockito.spy((Object)new FileSystemHooks.FileSystemHook<String>(){

            public void execute(String s) {
                Assert.assertEquals((Object)fsName, (Object)s);
            }
        });
        FileSystemHooks.FileSystemHook lambdaHook = s -> {
            Assert.assertEquals((Object)fsName, (Object)s);
            executedWithLambda.set(true);
        };
        JGitFSHooks.executeFSHooks(Arrays.asList(hook, lambdaHook), (FileSystemHooks)FileSystemHooks.ExternalUpdate, (String)fsName);
        ((FileSystemHooks.FileSystemHook)Mockito.verify((Object)hook)).execute((Object)fsName);
        Assert.assertTrue((boolean)executedWithLambda.get());
    }
}

