/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class JGitFileSystemLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitFileSystemLock.class);
    ReentrantLock lock = new ReentrantLock(true);
    private FileLock physicalLock;
    private Path lockFile;
    private FileChannel fileChannel;
    private long lastAccessMilliseconds;
    private long lastAccessThresholdMilliseconds;

    public JGitFileSystemLock(Git git, TimeUnit t, long duration) {
        URI repoURI = this.getRepoURI(git);
        this.lockFile = this.createLockInfra(repoURI);
        this.lastAccessThresholdMilliseconds = t.toMillis(duration);
    }

    URI getRepoURI(Git git) {
        return git.getRepository().getDirectory().toURI();
    }

    void registerAccess() {
        this.lastAccessMilliseconds = System.currentTimeMillis();
    }

    public void lock() {
        this.registerAccess();
        this.lock.lock();
        if (this.needToCreatePhysicalLock()) {
            this.physicalLockOnFS();
        }
    }

    public void unlock() {
        this.registerAccess();
        if (this.lock.isLocked()) {
            if (this.releasePhysicalLock()) {
                this.physicalUnLockOnFS();
            }
            this.lock.unlock();
        }
    }

    public boolean hasBeenInUse() {
        if (this.recentlyAccessed()) {
            return true;
        }
        return this.lock.isLocked();
    }

    private boolean recentlyAccessed() {
        return System.currentTimeMillis() - this.lastAccessMilliseconds < this.lastAccessThresholdMilliseconds;
    }

    private boolean needToCreatePhysicalLock() {
        return (this.physicalLock == null || !this.physicalLock.isValid()) && this.lock.getHoldCount() == 1;
    }

    private boolean releasePhysicalLock() {
        return this.physicalLock != null && this.physicalLock.isValid() && this.lock.isLocked() && this.lock.getHoldCount() == 1;
    }

    void physicalLockOnFS() {
        try {
            File file = this.lockFile.toFile();
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            this.fileChannel = raf.getChannel();
            this.physicalLock = this.fileChannel.lock();
            this.fileChannel.position(0L);
            this.fileChannel.write(ByteBuffer.wrap("locked".getBytes()));
        }
        catch (Exception e) {
            LOGGER.error("Error during lock of FS [" + this.toString() + "]", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void physicalUnLockOnFS() {
        try {
            this.physicalLock.release();
            this.fileChannel.close();
            this.fileChannel = null;
            this.physicalLock = null;
        }
        catch (Exception e) {
            LOGGER.error("Error during unlock of FS [" + this.toString() + "]", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    Path createLockInfra(URI uri) {
        Path lockFile = null;
        try {
            Path repo = Paths.get(uri);
            lockFile = repo.resolve("af.lock");
            Files.createFile(lockFile, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException repo) {
        }
        catch (Exception e) {
            LOGGER.error("Error building lock infra [" + this.toString() + "]", (Throwable)e);
            throw new RuntimeException(e);
        }
        return lockFile;
    }
}

