/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;
import org.uberfire.java.nio.fs.jgit.util.commands.SubdirectoryClone;

public class JGitSubdirectoryCloneTest
extends AbstractTestInfra {
    private static final String TARGET_GIT = "target/target";
    private static final String SOURCE_GIT = "source/source";

    @Test
    public void cloneSubdirectorySingleBranch() throws Exception {
        File parentFolder = JGitSubdirectoryCloneTest.createTempDirectory();
        File sourceDir = new File(parentFolder, "source/source.git");
        File targetDir = new File(parentFolder, "target/target.git");
        Git origin = this.gitRepo(sourceDir);
        JGitSubdirectoryCloneTest.commit(origin, "master", "first", JGitSubdirectoryCloneTest.content("dir1/file.txt", "foo"));
        JGitSubdirectoryCloneTest.commit(origin, "master", "second", JGitSubdirectoryCloneTest.content("dir2/file2.txt", "bar"));
        JGitSubdirectoryCloneTest.commit(origin, "master", "third", JGitSubdirectoryCloneTest.content("file3.txt", "moogah"));
        Git cloned = new SubdirectoryClone(targetDir, sourceDir.getAbsoluteFile().toURI().toString(), "dir1", Collections.singletonList("master"), CredentialsProvider.getDefault(), null, null).execute();
        Assertions.assertThat((Iterable)origin.getRepository().getRemoteNames()).isEmpty();
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat(this.listRefs(cloned)).hasSize(1);
        List<RevCommit> cloneCommits = this.getCommits(cloned, "master");
        Assertions.assertThat(cloneCommits).hasSize(1);
        RevCommit clonedCommit = cloneCommits.get(0);
        RevCommit originCommit = this.getCommits(origin, "master").get(2);
        this.assertClonedCommitData(origin, "dir1", clonedCommit, originCommit);
    }

    @Test
    public void cloneSubdirectoryMultipleBranches() throws Exception {
        File parentFolder = JGitSubdirectoryCloneTest.createTempDirectory();
        File sourceDir = new File(parentFolder, "source/source.git");
        File targetDir = new File(parentFolder, "target/target.git");
        Git origin = this.gitRepo(sourceDir);
        JGitSubdirectoryCloneTest.commit(origin, "master", "first", JGitSubdirectoryCloneTest.content("dir1/file.txt", "foo"), JGitSubdirectoryCloneTest.content("dir2/file2.txt", "bar"), JGitSubdirectoryCloneTest.content("file3.txt", "moogah"));
        this.branch(origin, "master", "dev");
        JGitSubdirectoryCloneTest.commit(origin, "dev", "second", JGitSubdirectoryCloneTest.content("dir1/file.txt", "foo1"), JGitSubdirectoryCloneTest.content("file3.txt", "bar1"));
        this.branch(origin, "master", "ignored");
        JGitSubdirectoryCloneTest.commit(origin, "ignored", "third", JGitSubdirectoryCloneTest.content("dir1/file.txt", "foo2"));
        Git cloned = new SubdirectoryClone(targetDir, sourceDir.getAbsoluteFile().toURI().toString(), "dir1", Arrays.asList("master", "dev"), CredentialsProvider.getDefault(), null, null).execute();
        Assertions.assertThat((Object)cloned).isNotNull();
        Set clonedRefs = this.listRefs(cloned).stream().map(ref -> ref.getName()).collect(Collectors.toSet());
        Assertions.assertThat(clonedRefs).hasSize(2);
        Assertions.assertThat(clonedRefs).containsExactly((Object[])new String[]{"refs/heads/master", "refs/heads/dev"});
        List<RevCommit> cloneCommits = this.getCommits(cloned, "master");
        Assertions.assertThat(cloneCommits).hasSize(1);
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(0), this.getCommits(origin, "master").get(0));
        cloneCommits = this.getCommits(cloned, "dev");
        Assertions.assertThat(cloneCommits).hasSize(2);
        List<RevCommit> originCommits = this.getCommits(origin, "dev");
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(0), originCommits.get(0));
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(1), originCommits.get(1));
    }

    @Test
    public void cloneSubdirectoryWithMergeCommit() throws Exception {
        File parentFolder = JGitSubdirectoryCloneTest.createTempDirectory();
        File sourceDir = new File(parentFolder, "source/source.git");
        File targetDir = new File(parentFolder, "target/target.git");
        Git origin = this.gitRepo(sourceDir);
        JGitSubdirectoryCloneTest.commit(origin, "master", "first", JGitSubdirectoryCloneTest.content("dir1/file.txt", "foo"), JGitSubdirectoryCloneTest.content("dir2/file2.txt", "bar"), JGitSubdirectoryCloneTest.content("file3.txt", "moogah"));
        this.branch(origin, "master", "dev");
        JGitSubdirectoryCloneTest.commit(origin, "dev", "second", JGitSubdirectoryCloneTest.content("dir1/file.txt", "foo1"), JGitSubdirectoryCloneTest.content("file3.txt", "bar1"));
        JGitSubdirectoryCloneTest.commit(origin, "master", "another", JGitSubdirectoryCloneTest.content("dir1/file2.txt", "blah"));
        this.mergeCommit(origin, "master", "dev", JGitSubdirectoryCloneTest.content("dir1/file.txt", "merged value!"), JGitSubdirectoryCloneTest.content("dir2/file2.txt", "merged value!"), JGitSubdirectoryCloneTest.content("file3.txt", "merged value!"));
        Git cloned = new SubdirectoryClone(targetDir, sourceDir.getAbsoluteFile().toURI().toString(), "dir1", Arrays.asList("master", "dev"), CredentialsProvider.getDefault(), null, null).execute();
        Assertions.assertThat((Object)cloned).isNotNull();
        Set clonedRefs = this.listRefs(cloned).stream().map(ref -> ref.getName()).collect(Collectors.toSet());
        Assertions.assertThat(clonedRefs).hasSize(2);
        Assertions.assertThat(clonedRefs).containsExactly((Object[])new String[]{"refs/heads/master", "refs/heads/dev"});
        List<RevCommit> cloneCommits = this.getCommits(cloned, "master");
        Assertions.assertThat(cloneCommits).hasSize(4);
        List<RevCommit> originCommits = this.getCommits(origin, "master");
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(0), originCommits.get(0));
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(1), originCommits.get(1));
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(2), originCommits.get(2));
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(3), originCommits.get(3));
        Assertions.assertThat((int)cloneCommits.get(0).getParentCount()).isEqualTo(2);
        Assertions.assertThat((int)cloneCommits.get(1).getParentCount()).isEqualTo(1);
        Assertions.assertThat((int)cloneCommits.get(2).getParentCount()).isEqualTo(1);
        Assertions.assertThat((int)cloneCommits.get(3).getParentCount()).isEqualTo(0);
        cloneCommits = this.getCommits(cloned, "dev");
        Assertions.assertThat(cloneCommits).hasSize(2);
        originCommits = this.getCommits(origin, "dev");
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(0), originCommits.get(0));
        this.assertClonedCommitData(origin, "dir1", cloneCommits.get(1), originCommits.get(1));
    }

    @Test
    public void cloneSubdirectoryWithHookDir() throws Exception {
        File hooksDir = JGitSubdirectoryCloneTest.createTempDirectory();
        this.writeMockHook(hooksDir, "post-commit");
        this.writeMockHook(hooksDir, "pre-commit");
        File parentFolder = JGitSubdirectoryCloneTest.createTempDirectory();
        File sourceDir = new File(parentFolder, "source/source.git");
        File targetDir = new File(parentFolder, "target/target.git");
        Git origin = this.gitRepo(sourceDir);
        JGitSubdirectoryCloneTest.commit(origin, "master", "first", JGitSubdirectoryCloneTest.content("dir1/file.txt", "foo"));
        JGitSubdirectoryCloneTest.commit(origin, "master", "second", JGitSubdirectoryCloneTest.content("dir2/file2.txt", "bar"));
        JGitSubdirectoryCloneTest.commit(origin, "master", "third", JGitSubdirectoryCloneTest.content("file3.txt", "moogah"));
        Git cloned = new SubdirectoryClone(targetDir, sourceDir.getAbsoluteFile().toURI().toString(), "dir1", Collections.singletonList("master"), CredentialsProvider.getDefault(), null, hooksDir).execute();
        Assertions.assertThat((Iterable)origin.getRepository().getRemoteNames()).isEmpty();
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat(this.listRefs(cloned)).hasSize(1);
        List<RevCommit> cloneCommits = this.getCommits(cloned, "master");
        Assertions.assertThat(cloneCommits).hasSize(1);
        RevCommit clonedCommit = cloneCommits.get(0);
        RevCommit originCommit = this.getCommits(origin, "master").get(2);
        this.assertClonedCommitData(origin, "dir1", clonedCommit, originCommit);
        boolean foundPreCommitHook = false;
        boolean foundPostCommitHook = false;
        Object[] hooks = new File(cloned.getRepository().getDirectory(), "hooks").listFiles();
        Assertions.assertThat((Object[])hooks).isNotEmpty().isNotNull();
        Assertions.assertThat((int)hooks.length).isEqualTo(2);
        for (Object hook : hooks) {
            if (((File)hook).getName().equals("pre-commit")) {
                foundPreCommitHook = ((File)hook).canExecute();
                continue;
            }
            if (!((File)hook).getName().equals("post-commit")) continue;
            foundPostCommitHook = ((File)hook).canExecute();
        }
        Assertions.assertThat((boolean)foundPreCommitHook).isTrue();
        Assertions.assertThat((boolean)foundPostCommitHook).isTrue();
    }

    private void assertClonedCommitData(Git origin, String subdirectory, RevCommit clonedCommit, RevCommit originCommit) throws Exception {
        Assertions.assertThat((String)clonedCommit.getFullMessage()).isEqualTo((Object)originCommit.getFullMessage());
        PersonIdent authorIdent = clonedCommit.getAuthorIdent();
        PersonIdent commiterIdent = clonedCommit.getCommitterIdent();
        Assertions.assertThat((Object)authorIdent).isEqualTo((Object)commiterIdent);
        Assertions.assertThat((String)authorIdent.getName()).isEqualTo((Object)"name");
        Assertions.assertThat((String)authorIdent.getEmailAddress()).isEqualTo((Object)"name@example.com");
        ObjectId originDirId = this.findIdForPath(origin, originCommit, subdirectory);
        ObjectId clonedTreeId = clonedCommit.getTree().getId();
        Assertions.assertThat((Comparable)clonedTreeId).isEqualTo((Object)originDirId);
    }

    private Ref branch(Git origin, String source, String target) throws Exception {
        Repository repo = origin.getRepository();
        return org.eclipse.jgit.api.Git.wrap((Repository)repo).branchCreate().setName(target).setStartPoint(source).call();
    }

    private ObjectId findIdForPath(Git origin, RevCommit originMasterTip, String searchPath) throws Exception {
        try (TreeWalk treeWalk = new TreeWalk(origin.getRepository());){
            int treeId = treeWalk.addTree((AnyObjectId)originMasterTip.getTree());
            treeWalk.setRecursive(false);
            CanonicalTreeParser treeParser = (CanonicalTreeParser)treeWalk.getTree(treeId, CanonicalTreeParser.class);
            while (treeWalk.next()) {
                String path = treeParser.getEntryPathString();
                if (!path.equals(searchPath)) continue;
                ObjectId objectId = treeParser.getEntryObjectId();
                return objectId;
            }
        }
        throw new AssertionError((Object)String.format("Could not find path [%s] in commit [%s].", searchPath, originMasterTip.name()));
    }

    private List<RevCommit> getCommits(Git git, String branch) throws Exception {
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        try (RevWalk revWalk = new RevWalk(git.getRepository());){
            RevCommit branchTip = revWalk.parseCommit((AnyObjectId)git.getRepository().resolve(branch));
            revWalk.markStart(branchTip);
            revWalk.sort(RevSort.TOPO);
            Iterator iter = revWalk.iterator();
            while (iter.hasNext()) {
                commits.add((RevCommit)iter.next());
            }
        }
        return commits;
    }

    private List<Ref> listRefs(Git cloned) {
        return new ListRefs(cloned.getRepository()).execute();
    }

    private Git gitRepo(File gitSource) {
        return (Git)new CreateRepository(gitSource).execute().get();
    }

    private void mergeCommit(Git origin, String targetBranchName, String sourceBranchName, AbstractTestInfra.TestFile ... testFiles) throws Exception {
        Repository repo = origin.getRepository();
        org.eclipse.jgit.api.Git git = org.eclipse.jgit.api.Git.wrap((Repository)repo);
        ObjectId targetId = repo.resolve(targetBranchName);
        ObjectId sourceId = repo.resolve(sourceBranchName);
        DirCache dc = DirCache.newInCore();
        DirCacheEditor editor = dc.editor();
        try (ObjectInserter inserter = repo.newObjectInserter();){
            ObjectId treeId = this.writeTestFilesToTree(dc, editor, inserter, testFiles);
            ObjectId commitId = this.writeCommit(inserter, treeId, targetId, sourceId);
            this.updateBranch(targetBranchName, git, commitId);
        }
    }

    private void updateBranch(String targetBranchName, org.eclipse.jgit.api.Git git, ObjectId commitId) throws Exception {
        git.branchCreate().setName(targetBranchName).setStartPoint(commitId.name()).setForce(true).call();
    }

    private ObjectId writeCommit(ObjectInserter inserter, ObjectId commitTreeId, ObjectId ... parentIds) throws IOException {
        CommitBuilder builder = new CommitBuilder();
        builder.setAuthor(new PersonIdent("name", "name@example.com"));
        builder.setCommitter(new PersonIdent("name", "name@example.com"));
        builder.setTreeId((AnyObjectId)commitTreeId);
        builder.setMessage("merge commit");
        builder.setParentIds(parentIds);
        ObjectId commitId = inserter.insert(builder);
        return commitId;
    }

    private ObjectId writeTestFilesToTree(DirCache dc, DirCacheEditor editor, ObjectInserter inserter, AbstractTestInfra.TestFile ... testFiles) throws Exception {
        for (AbstractTestInfra.TestFile data : testFiles) {
            this.writeBlob(editor, inserter, data);
        }
        editor.finish();
        ObjectId commitTreeId = dc.writeTree(inserter);
        return commitTreeId;
    }

    private void writeBlob(DirCacheEditor editor, ObjectInserter inserter, AbstractTestInfra.TestFile data) throws IOException {
        final ObjectId blobId = inserter.insert(3, (long)data.content.length(), IOUtils.toInputStream((String)data.content, (String)"UTF-8"));
        editor.add(new DirCacheEditor.PathEdit(data.path){

            public void apply(DirCacheEntry ent) {
                ent.setFileMode(FileMode.REGULAR_FILE);
                ent.setObjectId((AnyObjectId)blobId);
            }
        });
    }
}

