/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.PathMatcher;
import org.uberfire.java.nio.file.PatternSyntaxException;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.UserPrincipalLookupService;
import org.uberfire.java.nio.file.extensions.FileSystemHookExecutionContext;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFSPath;
import org.uberfire.java.nio.fs.jgit.JGitFileStore;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemLock;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.extensions.JGitFSHooks;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.ws.JGitFileSystemsEventsManager;

public class JGitFileSystemImpl
implements JGitFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitFileSystemImpl.class);
    private static final Set<String> SUPPORTED_ATTR_VIEWS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "version")));
    private final JGitFileSystemProvider provider;
    private final Git git;
    private final String toStringContent;
    private boolean isClosed = false;
    private final FileStore fileStore;
    private final String name;
    private final CredentialsProvider credential;
    private final Map<FileSystemHooks, ?> fsHooks;
    private final AtomicInteger numberOfCommitsSinceLastGC = new AtomicInteger(0);
    private FileSystemState state = FileSystemState.NORMAL;
    private CommitInfo batchCommitInfo = null;
    private Map<Path, Boolean> hadCommitOnBatchState = new ConcurrentHashMap<Path, Boolean>();
    private JGitFileSystemLock lock;
    private JGitFileSystemsEventsManager fsEventsManager;
    private List<WatchEvent<?>> postponedWatchEvents = Collections.synchronizedList(new ArrayList());

    public JGitFileSystemImpl(JGitFileSystemProvider provider, Map<String, String> fullHostNames, Git git, JGitFileSystemLock lock, String name, CredentialsProvider credential, JGitFileSystemsEventsManager fsEventsManager, Map<FileSystemHooks, ?> fsHooks) {
        this.fsEventsManager = fsEventsManager;
        this.provider = (JGitFileSystemProvider)PortablePreconditions.checkNotNull((String)"provider", (Object)provider);
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.name = PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        this.lock = (JGitFileSystemLock)PortablePreconditions.checkNotNull((String)"lock", (Object)lock);
        this.credential = (CredentialsProvider)PortablePreconditions.checkNotNull((String)"credential", (Object)credential);
        this.fsHooks = fsHooks;
        this.fileStore = new JGitFileStore(this.git.getRepository());
        if (fullHostNames != null && !fullHostNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<String, String>> iterator = fullHostNames.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                sb.append(entry.getKey()).append("://").append(entry.getValue()).append("/").append(name);
                if (!iterator.hasNext()) continue;
                sb.append("\n");
            }
            this.toStringContent = sb.toString();
        } else {
            this.toStringContent = "git://" + name;
        }
    }

    public String id() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Git getGit() {
        return this.git;
    }

    @Override
    public CredentialsProvider getCredential() {
        return this.credential;
    }

    public FileSystemProvider provider() {
        return this.provider;
    }

    public boolean isOpen() {
        return !this.isClosed;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getSeparator() {
        return "/";
    }

    public Iterable<Path> getRootDirectories() {
        this.checkClosed();
        return () -> new Iterator<Path>(){
            Iterator branches = null;

            @Override
            public boolean hasNext() {
                if (this.branches == null) {
                    this.init();
                }
                return this.branches.hasNext();
            }

            private void init() {
                this.branches = JGitFileSystemImpl.this.git.listRefs().iterator();
            }

            @Override
            public Path next() {
                if (this.branches == null) {
                    this.init();
                }
                try {
                    return JGitPathImpl.createRoot(JGitFileSystemImpl.this, "/", Repository.shortenRefName((String)((Ref)this.branches.next()).getName()) + "@" + JGitFileSystemImpl.this.name, false);
                }
                catch (NoSuchElementException e) {
                    throw new IllegalStateException("The gitnio directory is in an invalid state. If you are an IntelliJ IDEA user, there is a known bug which requires specifying a custom directory for your git repository. You can specify a custom directory using '-Dorg.uberfire.nio.git.dir=/tmp/dir'. For more details please see https://issues.jboss.org/browse/UF-275.", e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<FileStore> getFileStores() {
        this.checkClosed();
        return () -> new Iterator<FileStore>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 1;
            }

            @Override
            public FileStore next() {
                if (this.i < 1) {
                    ++this.i;
                    return JGitFileSystemImpl.this.fileStore;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<String> supportedFileAttributeViews() {
        this.checkClosed();
        return SUPPORTED_ATTR_VIEWS;
    }

    public Path getPath(String first, String ... more) throws InvalidPathException {
        this.checkClosed();
        if (first == null || first.trim().isEmpty()) {
            return new JGitFSPath(this);
        }
        if (more == null || more.length == 0) {
            return JGitPathImpl.create(this, first, "master@" + this.name, false);
        }
        StringBuilder sb = new StringBuilder();
        for (String segment : more) {
            if (segment.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(this.getSeparator());
            }
            sb.append(segment);
        }
        return JGitPathImpl.create(this, sb.toString(), first + "@" + this.name, false);
    }

    public PathMatcher getPathMatcher(String syntaxAndPattern) throws IllegalArgumentException, PatternSyntaxException, UnsupportedOperationException {
        this.checkClosed();
        PortablePreconditions.checkNotEmpty((String)"syntaxAndPattern", (String)syntaxAndPattern);
        throw new UnsupportedOperationException();
    }

    public UserPrincipalLookupService getUserPrincipalLookupService() throws UnsupportedOperationException {
        this.checkClosed();
        throw new UnsupportedOperationException();
    }

    public WatchService newWatchService() throws UnsupportedOperationException, IOException {
        this.checkClosed();
        return this.fsEventsManager.newWatchService(this.name);
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.git.getRepository().close();
        this.isClosed = true;
        try {
            this.fsEventsManager.close(this.name);
        }
        catch (Exception ex) {
            LOGGER.error("Error during close of WatchServices [" + this.toString() + "]", (Throwable)ex);
        }
        finally {
            this.provider.onCloseFileSystem(this);
        }
    }

    @Override
    public void checkClosed() throws IllegalStateException {
        if (this.isClosed) {
            throw new IllegalStateException("FileSystem is closed.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            if (o != null && o instanceof JGitFileSystemProxy) {
                o = ((JGitFileSystemProxy)o).getRealJGitFileSystem();
            } else {
                return false;
            }
        }
        JGitFileSystemImpl that = (JGitFileSystemImpl)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        return this.toStringContent;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        return result;
    }

    @Override
    public void publishEvents(Path watchableRoot, List<WatchEvent<?>> elist) {
        this.fsEventsManager.publishEvents(this.name, watchableRoot, elist);
    }

    public void dispose() {
        if (!this.isClosed) {
            this.close();
        }
        this.provider.onDisposeFileSystem(this);
    }

    @Override
    public boolean isOnBatch() {
        return this.state.equals((Object)FileSystemState.BATCH);
    }

    @Override
    public void setState(String state) {
        try {
            this.state = FileSystemState.valueOf((String)state);
        }
        catch (Exception ex) {
            this.state = FileSystemState.NORMAL;
        }
    }

    @Override
    public CommitInfo buildCommitInfo(String defaultMessage, CommentedOption op) {
        String sessionId = null;
        String name = null;
        String email = null;
        String message = defaultMessage;
        TimeZone timeZone = null;
        Date when = null;
        if (op != null) {
            sessionId = op.getSessionId();
            name = op.getName();
            email = op.getEmail();
            if (op.getMessage() != null && !op.getMessage().trim().isEmpty()) {
                message = op.getMessage();
            }
            timeZone = op.getTimeZone();
            when = op.getWhen();
        }
        return new CommitInfo(sessionId, name, email, message, timeZone, when);
    }

    @Override
    public void setBatchCommitInfo(String defaultMessage, CommentedOption op) {
        this.batchCommitInfo = this.buildCommitInfo(defaultMessage, op);
    }

    @Override
    public void setHadCommitOnBatchState(Path path, boolean hadCommitOnBatchState) {
        Path root = ((Path)PortablePreconditions.checkNotNull((String)"path", (Object)path)).getRoot();
        this.hadCommitOnBatchState.put(root.getRoot(), hadCommitOnBatchState);
    }

    @Override
    public void setHadCommitOnBatchState(boolean value) {
        for (Map.Entry<Path, Boolean> entry : this.hadCommitOnBatchState.entrySet()) {
            entry.setValue(value);
        }
    }

    @Override
    public boolean isHadCommitOnBatchState(Path path) {
        Path root = ((Path)PortablePreconditions.checkNotNull((String)"path", (Object)path)).getRoot();
        return this.hadCommitOnBatchState.containsKey(root) ? this.hadCommitOnBatchState.get(root) : false;
    }

    @Override
    public void setBatchCommitInfo(CommitInfo batchCommitInfo) {
        this.batchCommitInfo = batchCommitInfo;
    }

    @Override
    public CommitInfo getBatchCommitInfo() {
        return this.batchCommitInfo;
    }

    @Override
    public int incrementAndGetCommitCount() {
        return this.numberOfCommitsSinceLastGC.incrementAndGet();
    }

    @Override
    public void resetCommitCount() {
        this.numberOfCommitsSinceLastGC.set(0);
    }

    @Override
    public int getNumberOfCommitsSinceLastGC() {
        return this.numberOfCommitsSinceLastGC.get();
    }

    public FileSystemState getState() {
        return this.state;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public JGitFileSystemLock getLock() {
        return this.lock;
    }

    @Override
    public void addPostponedWatchEvents(List<WatchEvent<?>> postponedWatchEvents) {
        this.postponedWatchEvents.addAll(postponedWatchEvents);
    }

    @Override
    public List<WatchEvent<?>> getPostponedWatchEvents() {
        return this.postponedWatchEvents;
    }

    @Override
    public void clearPostponedWatchEvents() {
        this.postponedWatchEvents = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public boolean hasPostponedEvents() {
        return !this.getPostponedWatchEvents().isEmpty();
    }

    @Override
    public boolean hasBeenInUse() {
        return this.lock.hasBeenInUse();
    }

    @Override
    public void notifyExternalUpdate() {
        Object hook = this.fsHooks.get(FileSystemHooks.ExternalUpdate);
        if (hook != null) {
            JGitFSHooks.executeFSHooks(hook, FileSystemHooks.ExternalUpdate, new FileSystemHookExecutionContext(this.name));
        }
    }

    @Override
    public void notifyPostCommit(int exitCode) {
        Object hook = this.fsHooks.get(FileSystemHooks.PostCommit);
        if (hook != null) {
            FileSystemHookExecutionContext ctx = new FileSystemHookExecutionContext(this.name);
            ctx.addParam("POST_COMMIT_EXIT_CODE", (Object)exitCode);
            JGitFSHooks.executeFSHooks(hook, FileSystemHooks.ExternalUpdate, ctx);
        }
    }
}

