/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.CachingPublicKeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.UnknownCommand;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.common.PortUtil;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitReceiveCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitUploadCommand;
import org.uberfire.java.nio.security.FileSystemAuthenticator;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;
import org.uberfire.java.nio.security.SSHAuthenticator;

public class GitSSHService {
    private static final Logger LOG = LoggerFactory.getLogger(GitSSHService.class);
    private final List<BuiltinCiphers> managedCiphers = Collections.unmodifiableList(Arrays.asList(BuiltinCiphers.aes128ctr, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes256ctr, BuiltinCiphers.arcfour256, BuiltinCiphers.arcfour128, BuiltinCiphers.aes192cbc, BuiltinCiphers.aes256cbc));
    private final List<BuiltinMacs> managedMACs = Collections.unmodifiableList(Arrays.asList(BuiltinMacs.hmacmd5, BuiltinMacs.hmacsha1, BuiltinMacs.hmacsha256, BuiltinMacs.hmacsha512, BuiltinMacs.hmacsha196, BuiltinMacs.hmacmd596));
    private SshServer sshd;
    private FileSystemAuthenticator fileSystemAuthenticator;
    private FileSystemAuthorizer fileSystemAuthorizer;
    private SSHAuthenticator sshAuthenticator;

    private SshServer buildSshServer(String ciphersConfigured, String macsConfigured) {
        return (SshServer)((ServerBuilder)((ServerBuilder)ServerBuilder.builder().cipherFactories(NamedFactory.setUpBuiltinFactories((boolean)false, this.checkAndSetGitCiphers(ciphersConfigured)))).macFactories(NamedFactory.setUpBuiltinFactories((boolean)false, this.checkAndSetGitMacs(macsConfigured)))).build();
    }

    public void setup(File certDir, InetSocketAddress inetSocketAddress, String sshIdleTimeout, String algorithm, ReceivePackFactory receivePackFactory, UploadPackFactory uploadPackFactory, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, ExecutorService executorService) {
        this.setup(certDir, inetSocketAddress, sshIdleTimeout, algorithm, receivePackFactory, uploadPackFactory, repositoryResolver, executorService, null, null);
    }

    public void setup(File certDir, InetSocketAddress inetSocketAddress, String sshIdleTimeout, String algorithm, ReceivePackFactory receivePackFactory, UploadPackFactory uploadPackFactory, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, ExecutorService executorService, String gitSshCiphers, String gitSshMacs) {
        PortablePreconditions.checkNotNull((String)"certDir", (Object)certDir);
        PortablePreconditions.checkNotEmpty((String)"sshIdleTimeout", (String)sshIdleTimeout);
        PortablePreconditions.checkNotEmpty((String)"algorithm", (String)algorithm);
        PortablePreconditions.checkNotNull((String)"receivePackFactory", (Object)receivePackFactory);
        PortablePreconditions.checkNotNull((String)"uploadPackFactory", (Object)uploadPackFactory);
        PortablePreconditions.checkNotNull((String)"repositoryResolver", repositoryResolver);
        this.buildSSHServer(gitSshCiphers, gitSshMacs);
        this.sshd.getProperties().put("idle-timeout", sshIdleTimeout);
        if (inetSocketAddress != null) {
            this.sshd.setHost(inetSocketAddress.getHostName());
            this.sshd.setPort(PortUtil.validateOrGetNew(inetSocketAddress.getPort()));
            if (inetSocketAddress.getPort() != this.sshd.getPort()) {
                LOG.error("SSH for Git original port {} not available, new free port {} assigned.", (Object)inetSocketAddress.getPort(), (Object)this.sshd.getPort());
            }
        }
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        SimpleGeneratorHostKeyProvider keyPairProvider = new SimpleGeneratorHostKeyProvider(new File(certDir, "hostkey.ser"));
        try {
            SecurityUtils.getKeyPairGenerator((String)algorithm);
            keyPairProvider.setAlgorithm(algorithm);
        }
        catch (Exception ignore) {
            throw new RuntimeException(String.format("Can't use '%s' algorithm for ssh key pair generator.", algorithm), ignore);
        }
        this.sshd.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        this.sshd.setCommandFactory(command -> {
            if (command.startsWith("git-upload-pack")) {
                return new GitUploadCommand(command, repositoryResolver, this.getAuthorizationManager(), uploadPackFactory, executorService);
            }
            if (command.startsWith("git-receive-pack")) {
                return new GitReceiveCommand(command, repositoryResolver, this.getAuthorizationManager(), (ReceivePackFactory<BaseGitCommand>)receivePackFactory, executorService);
            }
            return new UnknownCommand(command);
        });
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new CachingPublicKeyAuthenticator((username, key, session) -> {
            FileSystemUser user = this.getSshAuthenticator().authenticate(username, key);
            if (user == null) {
                return false;
            }
            session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)user);
            return true;
        }));
        this.sshd.setPasswordAuthenticator((username, password, session) -> {
            FileSystemUser user = this.getUserPassAuthenticator().authenticate(username, password);
            if (user == null) {
                return false;
            }
            session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)user);
            return true;
        });
    }

    private void buildSSHServer(String gitSshCiphers, String gitSshMacs) {
        this.sshd = this.buildSshServer(gitSshCiphers, gitSshMacs);
    }

    private List<BuiltinCiphers> checkAndSetGitCiphers(String gitSshCiphers) {
        if (gitSshCiphers == null || gitSshCiphers.isEmpty()) {
            return this.managedCiphers;
        }
        ArrayList<BuiltinCiphers> ciphersHandled = new ArrayList<BuiltinCiphers>();
        List<String> ciphers = Arrays.asList(gitSshCiphers.split(","));
        for (String cipherCode : ciphers) {
            BuiltinCiphers cipher = BuiltinCiphers.fromFactoryName((String)cipherCode.trim().toLowerCase());
            if (cipher != null && this.managedCiphers.contains(cipher)) {
                ciphersHandled.add(cipher);
                LOG.info("Added Cipher {} to the git ssh configuration. ", (Object)cipher);
                continue;
            }
            LOG.warn("Cipher {} not handled in git ssh configuration. ", (Object)cipher);
        }
        return ciphersHandled;
    }

    private List<BuiltinMacs> checkAndSetGitMacs(String gitSshMacs) {
        if (gitSshMacs == null || gitSshMacs.isEmpty()) {
            return this.managedMACs;
        }
        ArrayList<BuiltinMacs> macs = new ArrayList<BuiltinMacs>();
        List<String> macsInput = Arrays.asList(gitSshMacs.split(","));
        for (String macCode : macsInput) {
            BuiltinMacs mac = BuiltinMacs.fromFactoryName((String)macCode.trim().toLowerCase());
            if (mac != null && this.managedMACs.contains(mac)) {
                macs.add(mac);
                LOG.info("Added MAC {} to the git ssh configuration. ", (Object)mac);
                continue;
            }
            LOG.warn("MAC {} not handled in git ssh configuration. ", (Object)mac);
        }
        return macs;
    }

    public void stop() {
        try {
            this.sshd.stop(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't start SSH daemon at " + this.sshd.getHost() + ":" + this.sshd.getPort(), e);
        }
    }

    public boolean isRunning() {
        return !this.sshd.isClosed() && !this.sshd.isClosing();
    }

    SshServer getSshServer() {
        return this.sshd;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.sshd.getProperties());
    }

    public FileSystemAuthenticator getUserPassAuthenticator() {
        return this.fileSystemAuthenticator;
    }

    public void setUserPassAuthenticator(FileSystemAuthenticator fileSystemAuthenticator) {
        this.fileSystemAuthenticator = fileSystemAuthenticator;
    }

    public FileSystemAuthorizer getAuthorizationManager() {
        return this.fileSystemAuthorizer;
    }

    public void setAuthorizationManager(FileSystemAuthorizer fileSystemAuthorizer) {
        this.fileSystemAuthorizer = fileSystemAuthorizer;
    }

    public SSHAuthenticator getSshAuthenticator() {
        return this.sshAuthenticator;
    }

    public void setSshAuthenticator(SSHAuthenticator sshAuthenticator) {
        this.sshAuthenticator = sshAuthenticator;
    }

    public List<BuiltinCiphers> getManagedCiphers() {
        return this.managedCiphers;
    }

    public List<BuiltinMacs> getManagedMACs() {
        return this.managedMACs;
    }
}

