/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.junit.Test;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;

public class JGitFileSystemImplProviderWithFoldersTest
extends AbstractTestInfra {
    @Test
    public void testNewFileSystemWithSubfolder() {
        URI newRepo = URI.create("git://test/sub-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(newRepo), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(0);
    }

    @Test
    public void testCreateFileIntoRepositoryWithFolder() throws IOException, GitAPIException {
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        };
        String oldPath = "git://test/old";
        URI oldUri = URI.create(oldPath);
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(oldUri, (Map)env);
        Path path = this.provider.getPath(URI.create("git://master@test/old/some/path/myfile.txt"));
        this.provider.setAttribute(path, FileSystemState.FILE_SYSTEM_STATE_ATTR, (Object)FileSystemState.BATCH, new LinkOption[0]);
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        Assertions.assertThat((boolean)new File(this.provider.getGitRepoContainerDir(), "test/old.git").exists()).isTrue();
        int commitsCount = 0;
        for (RevCommit com : ((GitImpl)fs.getGit())._log().all().call()) {
            ++commitsCount;
        }
    }

    @Test
    public void testExtractPathWithAuthority() {
        this.provider.newFileSystem(URI.create("git://test/repo"), (Map)new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        });
        String path = "git://master@test/repo/readme.md";
        URI uri = URI.create(path);
        String extracted = this.provider.extractPath(uri);
        Assertions.assertThat((String)extracted).isEqualTo((Object)"/readme.md");
    }

    @Test
    public void testComplexExtractPath() {
        URI newRepo = URI.create("git://test/repo");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        String path = "git://origin/master@test/repo/readme.md";
        URI uri = URI.create(path);
        String extracted = this.provider.extractPath(uri);
        Assertions.assertThat((String)extracted).isEqualTo((Object)"/readme.md");
    }

    @Test
    public void testExtractComplexRepoName() {
        this.provider.newFileSystem(URI.create("default://test/repo"), (Map)new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        });
        String path = "git://origin/master@test/repo/readme.md";
        URI uri = URI.create(path);
        String extracted = this.provider.extractFSNameWithPath(uri);
        Assertions.assertThat((String)extracted).isEqualTo((Object)"test/repo/readme.md");
    }

    @Test
    public void testExtractSimpleRepoName() {
        String path = "git://master@test/repo/readme.md";
        URI uri = URI.create(path);
        String extracted = this.provider.extractFSNameWithPath(uri);
        Assertions.assertThat((String)extracted).isEqualTo((Object)"test/repo/readme.md");
    }

    @Test
    public void testExtractVerySimpleRepoName() {
        String path = "git://test/repo/readme.md";
        URI uri = URI.create(path);
        String extracted = this.provider.extractFSNameWithPath(uri);
        Assertions.assertThat((String)extracted).isEqualTo((Object)"test/repo/readme.md");
    }
}

