/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.core.Condition;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;

public class JGitMirrorTest
extends AbstractTestInfra {
    public static final String TARGET_GIT = "test/target.git";
    public static final String ORIGIN = "https://github.com/uberfire/uberfire-website";
    private static Logger logger = LoggerFactory.getLogger(JGitMirrorTest.class);

    @Test
    public void testToHTTPMirrorSuccess() throws IOException, GitAPIException {
        File parentFolder = JGitMirrorTest.createTempDirectory();
        File directory = new File(parentFolder, TARGET_GIT);
        new Clone(directory, ORIGIN, false, CredentialsProvider.getDefault(), null).execute();
        Git cloned = Git.open((File)directory);
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).is((Condition)new Condition<List<Ref>>(){

            public boolean matches(List<Ref> refs) {
                return refs.size() > 0;
            }
        });
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo((Object)"refs/heads/master");
        URIish remoteUri = (URIish)((RemoteConfig)cloned.remoteList().call().get(0)).getURIs().get(0);
        String remoteUrl = remoteUri.getScheme() + "://" + remoteUri.getHost() + remoteUri.getPath();
        Assertions.assertThat((String)remoteUrl).isEqualTo((Object)ORIGIN);
    }

    @Test
    public void testEmptyCredentials() throws IOException, GitAPIException {
        File parentFolder = JGitMirrorTest.createTempDirectory();
        File directory = new File(parentFolder, TARGET_GIT);
        new Clone(directory, ORIGIN, false, null, null).execute();
        Git cloned = Git.open((File)directory);
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).is((Condition)new Condition<List<Ref>>(){

            public boolean matches(List<Ref> refs) {
                return refs.size() > 0;
            }
        });
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo((Object)"refs/heads/master");
        URIish remoteUri = (URIish)((RemoteConfig)cloned.remoteList().call().get(0)).getURIs().get(0);
        String remoteUrl = remoteUri.getScheme() + "://" + remoteUri.getHost() + remoteUri.getPath();
        Assertions.assertThat((String)remoteUrl).isEqualTo((Object)ORIGIN);
    }

    @Test
    public void testBadUrl() throws IOException, GitAPIException {
        File parentFolder = JGitMirrorTest.createTempDirectory();
        File directory = new File(parentFolder, TARGET_GIT);
        try {
            new Clone(directory, "https://github.com/uberfire/uberfire-websitesssss", false, CredentialsProvider.getDefault(), null).execute();
            Assertions.fail((String)"If got here the test is wrong because the ORIGIN does no exist");
        }
        catch (RuntimeException ex) {
            Assertions.assertThat((Throwable)ex).isNotNull();
            logger.info(ex.getMessage(), (Throwable)ex);
        }
    }
}

