/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(loadDirectory="target/test-classes", debug=true)
public class ConcurrentJGitUtilTest
extends AbstractTestInfra {
    @BeforeClass
    public static void setup() {
        GitImpl.setRetryTimes((int)5);
    }

    @Test
    @BMScript(value="byteman/retry/resolve_path.btm")
    public void testRetryResolvePath() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(git, "master", "name", "name@example.com", "1st commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "2nd commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        try {
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file1.txt"));
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file1.txt"));
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file1.txt"));
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file1.txt"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            git.getPathInfo("master", "path/to/file1.txt");
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/resolve_inputstream.btm")
    public void testRetryResolveInputStream() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(git, "master", "name", "name@example.com", "1st commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "2nd commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        try {
            Assert.assertNotNull((Object)git.blobAsInputStream("master", "path/to/file1.txt"));
            Assert.assertNotNull((Object)git.blobAsInputStream("master", "path/to/file1.txt"));
            Assert.assertNotNull((Object)git.blobAsInputStream("master", "path/to/file1.txt"));
            Assert.assertNotNull((Object)git.blobAsInputStream("master", "path/to/file1.txt"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)git.blobAsInputStream("master", "path/to/file1.txt"));
            Assert.fail((String)"forced to fail!");
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/list_path_content.btm")
    public void testRetryListPathContent() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(git, "master", "name", "name@example.com", "1st commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "2nd commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        try {
            Assert.assertNotNull((Object)git.listPathContent("master", "path/to/"));
            Assert.assertNotNull((Object)git.listPathContent("master", "path/to/"));
            Assert.assertNotNull((Object)git.listPathContent("master", "path/to/"));
            Assert.assertNotNull((Object)git.listPathContent("master", "path/to/"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)git.listPathContent("master", "path/to/"));
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/check_path.btm")
    public void testRetryCheckPath() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(git, "master", "name", "name@example.com", "1st commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "2nd commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        try {
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file2.txt"));
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file2.txt"));
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file2.txt"));
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file2.txt"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)git.getPathInfo("master", "path/to/file2.txt"));
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/get_last_commit.btm")
    public void testRetryGetLastCommit() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(git, "master", "name", "name@example.com", "1st commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "2nd commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        try {
            Assert.assertNotNull((Object)git.getLastCommit("master"));
            Assert.assertNotNull((Object)git.getLastCommit("master"));
            Assert.assertNotNull((Object)git.getLastCommit("master"));
            Assert.assertNotNull((Object)git.getLastCommit("master"));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)git.getLastCommit("master"));
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    @BMScript(value="byteman/retry/get_commits.btm")
    public void testRetryGetCommits() throws IOException {
        File parentFolder = ConcurrentJGitUtilTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        Git git = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(git, "master", "name", "name@example.com", "1st commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file1.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        new Commit(git, "master", "name", "name@example.com", "2nd commit", null, new Date(), false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file2.txt", ConcurrentJGitUtilTest.this.tempFile("temp2222"));
            }
        }).execute();
        RevCommit commit = git.getLastCommit("master");
        try {
            Assert.assertNotNull((Object)git.listCommits(null, (ObjectId)commit));
            Assert.assertNotNull((Object)git.listCommits(null, (ObjectId)commit));
            Assert.assertNotNull((Object)git.listCommits(null, (ObjectId)commit));
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            Assert.assertNotNull((Object)git.listCommits(null, (ObjectId)commit));
            Assert.fail((String)"forced to fail!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

