/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.model;

import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;

public class PathInfo {
    private final long size;
    private final ObjectId objectId;
    private final String path;
    private final PathType pathType;

    public PathInfo(ObjectId objectId, String path, FileMode fileMode) {
        this(objectId, path, PathInfo.convert(fileMode), -1L);
    }

    public PathInfo(ObjectId objectId, String path, FileMode fileMode, long size) {
        this(objectId, path, PathInfo.convert(fileMode));
    }

    public PathInfo(ObjectId objectId, String path, PathType pathType) {
        this(objectId, path, pathType, -1L);
    }

    public PathInfo(ObjectId objectId, String path, PathType pathType, long size) {
        this.objectId = objectId;
        this.path = path;
        this.pathType = pathType;
        this.size = size;
    }

    private static PathType convert(FileMode fileMode) {
        if (fileMode.equals(16384)) {
            return PathType.DIRECTORY;
        }
        if (fileMode.equals(32768)) {
            return PathType.FILE;
        }
        return null;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public String getPath() {
        return this.path;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public long getSize() {
        return this.size;
    }
}

