/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.GetTreeFromRef;
import org.uberfire.java.nio.fs.jgit.util.commands.ListDiffs;
import org.uberfire.java.nio.fs.jgit.util.commands.Merge;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitMergeTest
extends AbstractTestInfra {
    private static Logger logger = LoggerFactory.getLogger(JGitMergeTest.class);
    public static final String SOURCE_GIT = "source/source";

    @Test
    public void testMergeSuccessful() throws IOException, GitAPIException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "master", "name", "name@example.com", "master-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitMergeTest.this.tempFile("temp1"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "master", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", JGitMergeTest.this.tempFile("temp2"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-2", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", JGitMergeTest.this.tempFile("temp3"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-3", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", JGitMergeTest.this.tempFile("temp4"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-4", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", JGitMergeTest.this.tempFile("temp5"));
            }
        }).execute();
        new Merge(origin, "develop", "master").execute();
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "master").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }

    @Test
    public void testMergeConflict() throws IOException, GitAPIException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "master", "name", "name@example.com", "master-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitMergeTest.this.tempFile("temp1"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "master", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitMergeTest.this.tempFile("temp1"));
            }
        }).execute();
        new Merge(origin, "develop", "master").execute();
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "master").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParametersNotNull() throws IOException, GitAPIException {
        new Merge(null, "develop", "master").execute();
    }

    @Test(expected=GitException.class)
    public void testTryToMergeNonexistentBranch() throws IOException, GitAPIException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "master", "name", "name@example.com", "master-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", JGitMergeTest.this.tempFile("temp1"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "master", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", JGitMergeTest.this.tempFile("temp2"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-2", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", JGitMergeTest.this.tempFile("temp3"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-3", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", JGitMergeTest.this.tempFile("temp4"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-4", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", JGitMergeTest.this.tempFile("temp5"));
            }
        }).execute();
        new Merge(origin, "develop", "nonexistent").execute();
    }

    @Test(expected=GitException.class)
    public void testMergeBinaryInformationButHasConflicts() throws IOException, GitAPIException {
        final byte[] contentA = this.loadImage("images/drools.png");
        final byte[] contentB = this.loadImage("images/jbpm.png");
        final byte[] contentC = this.loadImage("images/opta.png");
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "master", "name", "name@example.com", "master-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentA));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "master", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentB));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "master-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentC));
            }
        }).execute();
        new Merge(origin, "develop", "master").execute();
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "master").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }

    @Test
    public void testMergeBinaryInformationSuccessful() throws IOException, GitAPIException {
        final byte[] contentA = this.loadImage("images/drools.png");
        final byte[] contentB = this.loadImage("images/jbpm.png");
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "master", "name", "name@example.com", "master-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentA));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "master", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentB));
            }
        }).execute();
        new Merge(origin, "develop", "master").execute();
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "master").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((int)result.size()).isEqualTo(0);
    }
}

