/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;

public class JGitCloneTest
extends AbstractTestInfra {
    private static final String TARGET_GIT = "target/target";
    private static final String SOURCE_GIT = "source/source";
    private static Logger logger = LoggerFactory.getLogger(JGitCloneTest.class);

    @Test
    public void testToCloneSuccess() throws IOException, GitAPIException {
        File parentFolder = JGitCloneTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        File gitTarget = new File(parentFolder, "target/target.git");
        Git origin = this.setupGitRepo(gitSource);
        Git cloned = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), false, CredentialsProvider.getDefault(), null).execute().get();
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).hasSize(2);
        Assert.assertEquals((long)new ListRefs(cloned.getRepository()).execute().size(), (long)new ListRefs(origin.getRepository()).execute().size());
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(0)).getName()).isEqualTo((Object)"refs/heads/master");
        Assertions.assertThat((String)((Ref)new ListRefs(cloned.getRepository()).execute().get(1)).getName()).isEqualTo((Object)"refs/heads/user_branch");
    }

    @Test
    public void cloneShouldOnlyWorksWithEmptyRepos() throws IOException {
        File parentFolder = JGitCloneTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        File gitTarget = new File(parentFolder, "target/target.git");
        Git origin = this.setupGitRepo(gitSource);
        Git cloned = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), false, CredentialsProvider.getDefault(), null).execute().get();
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((List)new ListRefs(cloned.getRepository()).execute()).hasSize(2);
        Assert.assertEquals((long)new ListRefs(cloned.getRepository()).execute().size(), (long)new ListRefs(origin.getRepository()).execute().size());
        Assertions.assertThatThrownBy(() -> {
            Git cfr_ignored_0 = (Git)new Clone(gitTarget, gitSource.getAbsolutePath(), false, CredentialsProvider.getDefault(), null).execute().get();
        }).isInstanceOf(Clone.CloneException.class);
    }

    private Git setupGitRepo(File gitSource) throws IOException {
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "user_branch", "name", "name@example.com", "commit!", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", JGitCloneTest.this.tempFile("temp2222"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "commit", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitCloneTest.this.tempFile("temp"));
            }
        }).execute();
        return origin;
    }
}

