/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_POSIX;
import org.eclipse.jgit.util.ProcessResult;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;

public class JGitFileSystemImplProviderHookTest
extends AbstractTestInfra {
    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "true");
        int gitDaemonPort = JGitFileSystemImplProviderHookTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.daemon.port", String.valueOf(gitDaemonPort));
        try {
            File hooksDir = JGitFileSystemImplProviderHookTest.createTempDirectory();
            gitPrefs.put("org.uberfire.nio.git.hooks", hooksDir.getAbsolutePath());
            this.writeMockHook(hooksDir, "post-commit");
            this.writeMockHook(hooksDir, "pre-commit");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return gitPrefs;
    }

    @Test
    public void testInstalledHook() {
        URI newRepo = URI.create("git://hook-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        if (fs instanceof JGitFileSystemImpl) {
            Object[] hooks = new File(((JGitFileSystemImpl)fs).getGit().getRepository().getDirectory(), "hooks").listFiles();
            Assertions.assertThat((Object[])hooks).isNotEmpty().isNotNull();
            Assertions.assertThat((int)hooks.length).isEqualTo(2);
            boolean foundPreCommitHook = false;
            boolean foundPostCommitHook = false;
            for (Object hook : hooks) {
                if (((File)hook).getName().equals("pre-commit")) {
                    foundPreCommitHook = ((File)hook).canExecute();
                    continue;
                }
                if (!((File)hook).getName().equals("post-commit")) continue;
                foundPostCommitHook = ((File)hook).canExecute();
            }
            Assertions.assertThat((boolean)foundPreCommitHook).isTrue();
            Assertions.assertThat((boolean)foundPostCommitHook).isTrue();
        }
    }

    @Test
    public void testExecutedPostCommitHook() throws IOException {
        this.testHook("hook-repo-name-executed", "post-commit", true);
    }

    @Test
    public void testNotSupportedPreCommitHook() throws IOException {
        this.testHook("hook-repo-name-executed-pre-commit", "pre-commit", false);
    }

    private void testHook(String gitRepoName, final String testedHookName, boolean wasExecuted) throws IOException {
        URI newRepo = URI.create("git://" + gitRepoName);
        final AtomicBoolean hookExecuted = new AtomicBoolean(false);
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        this.provider.setDetectedFS((FS)new FS_POSIX(){

            public ProcessResult runHookIfPresent(Repository repox, String hookName, String[] args) throws JGitInternalException {
                if (hookName.equals(testedHookName)) {
                    hookExecuted.set(true);
                }
                return null;
            }
        });
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://user_branch@" + gitRepoName + "/some/path/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        InputStream inStream = this.provider.newInputStream(path, new OpenOption[0]);
        String content = new Scanner(inStream).useDelimiter("\\A").next();
        inStream.close();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"my cool content");
        if (wasExecuted) {
            Assertions.assertThat((boolean)hookExecuted.get()).isTrue();
        } else {
            Assertions.assertThat((boolean)hookExecuted.get()).isFalse();
        }
    }

    private void writeMockHook(File hooksDirectory, String hookName) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter writer = new PrintWriter(new File(hooksDirectory, hookName), "UTF-8");
        writer.println("# something");
        writer.close();
    }
}

