/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import junit.framework.TestCase;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.base.NotImplementedException;
import org.uberfire.java.nio.base.attributes.HiddenAttributeView;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.options.SquashOption;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AmbiguousFileSystemNameException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.JGitVersionAttributeView;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.GetRef;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;

public class JGitFileSystemImplProviderTest
extends AbstractTestInfra {
    private int gitDaemonPort;

    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.daemon.enabled", "true");
        this.gitDaemonPort = JGitFileSystemImplProviderTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.daemon.port", String.valueOf(this.gitDaemonPort));
        System.out.println(this.gitDaemonPort);
        return gitPrefs;
    }

    @Test
    @Ignore
    public void testDaemob() {
        URI newRepo = URI.create("git://repo-name");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        WatchService ws = fs.newWatchService();
        Path path = (Path)fs.getRootDirectories().iterator().next();
        path.register(ws, new WatchEvent.Kind[]{StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_MODIFY, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_RENAME});
        WatchKey k = ws.take();
        List events = k.pollEvents();
        for (WatchEvent object : events) {
            if (object.kind() == StandardWatchEventKind.ENTRY_MODIFY) {
                System.out.println("Modify: " + object.context().toString());
            }
            if (object.kind() == StandardWatchEventKind.ENTRY_RENAME) {
                System.out.println("Rename: " + object.context().toString());
            }
            if (object.kind() == StandardWatchEventKind.ENTRY_DELETE) {
                System.out.println("Delete: " + object.context().toString());
            }
            if (object.kind() != StandardWatchEventKind.ENTRY_CREATE) continue;
            System.out.println("Created: " + object.context().toString());
        }
    }

    @Test
    public void testNewFileSystem() {
        URI newRepo = URI.create("git://repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(newRepo), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(0);
        try {
            this.provider.newFileSystem(newRepo, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(FileSystemAlreadyExistsException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.provider.newFileSystem(URI.create("git://repo-name2"), EMPTY_ENV);
    }

    @Test
    public void testNewFileSystemInited() {
        URI newRepo = URI.create("git://init-repo-name");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        DirectoryStream stream = this.provider.newDirectoryStream(this.provider.getPath(newRepo), null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream).isNotNull()).hasSize(1);
    }

    @Test
    public void testInvalidURINewFileSystem() {
        URI newRepo = URI.create("git:///repo-name");
        try {
            this.provider.newFileSystem(newRepo, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Parameter named 'uri' is invalid, missing host repository!");
        }
    }

    @Test
    public void testNewFileSystemClone() throws java.io.IOException {
        URI originRepo = URI.create("git://my-simple-test-origin-name");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, Collections.emptyMap());
        new Commit(origin.getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitFileSystemImplProviderTest.this.tempFile("temp"));
            }
        }).execute();
        URI newRepo = URI.create("git://my-repo-name");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", "git://localhost:" + JGitFileSystemImplProviderTest.this.gitDaemonPort + "/my-simple-test-origin-name");
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(1);
        ((AbstractFileAssert)Assertions.assertThat((File)fs.getPath("file.txt", new String[0]).toFile()).isNotNull()).exists();
        new Commit(origin.getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("fileXXXXX.txt", JGitFileSystemImplProviderTest.this.tempFile("temp"));
            }
        }).execute();
        this.provider.getFileSystem(URI.create("git://my-repo-name?sync=git://localhost:" + this.gitDaemonPort + "/my-simple-test-origin-name&force"));
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(1);
        for (Path root : fs.getRootDirectories()) {
            if (root.toAbsolutePath().toUri().toString().contains("upstream")) {
                Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).hasSize(2);
                continue;
            }
            if (root.toAbsolutePath().toUri().toString().contains("origin")) {
                Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).hasSize(1);
                continue;
            }
            Assertions.assertThat((Iterable)this.provider.newDirectoryStream(root, null)).hasSize(2);
        }
        new Commit(origin.getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("fileYYYY.txt", JGitFileSystemImplProviderTest.this.tempFile("tempYYYY"));
            }
        }).execute();
        this.provider.getFileSystem(URI.create("git://my-repo-name?sync=git://localhost:" + this.gitDaemonPort + "/my-simple-test-origin-name&force"));
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(1);
        ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream((Path)fs.getRootDirectories().iterator().next(), null)).isNotEmpty()).hasSize(3);
    }

    @Test
    public void testNewFileSystemCloneAndPush() throws java.io.IOException {
        URI originRepo = URI.create("git://my-simple-test-origin-repo");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, Collections.emptyMap());
        new Commit(origin.getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitFileSystemImplProviderTest.this.tempFile("temp"));
            }
        }).execute();
        URI newRepo = URI.create("git://my-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", "git://localhost:" + JGitFileSystemImplProviderTest.this.gitDaemonPort + "/my-simple-test-origin-repo");
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(1);
        ((AbstractFileAssert)Assertions.assertThat((File)fs.getPath("file.txt", new String[0]).toFile()).isNotNull()).exists();
        new Commit(((JGitFileSystem)fs).getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("fileXXXXX.txt", JGitFileSystemImplProviderTest.this.tempFile("temp"));
            }
        }).execute();
        URI newRepo2 = URI.create("git://my-repo2");
        HashMap<String, Object> env2 = new HashMap<String, Object>(){
            {
                this.put("origin", "git://localhost:" + JGitFileSystemImplProviderTest.this.gitDaemonPort + "/my-simple-test-origin-repo");
            }
        };
        FileSystem fs2 = this.provider.newFileSystem(newRepo2, (Map)env2);
        new Commit(origin.getGit(), "user-branch", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1UserBranch.txt", JGitFileSystemImplProviderTest.this.tempFile("tempX"));
            }
        }).execute();
        this.provider.getFileSystem(URI.create("git://my-repo2?sync=git://localhost:" + this.gitDaemonPort + "/my-simple-test-origin-repo&force"));
        Assertions.assertThat((Iterable)fs2.getRootDirectories()).hasSize(2);
        ArrayList<String> rootURIs1 = new ArrayList<String>(){
            {
                this.add("git://master@my-repo2/");
                this.add("git://user-branch@my-repo2/");
            }
        };
        ArrayList<String> rootURIs2 = new ArrayList<String>(){
            {
                this.add("git://master@my-repo2/");
                this.add("git://user-branch@my-repo2/");
                this.add("git://user-branch-2@my-repo2/");
            }
        };
        HashSet<String> rootURIs = new HashSet<String>();
        for (Path root : fs2.getRootDirectories()) {
            rootURIs.add(root.toUri().toString());
        }
        rootURIs.removeAll(rootURIs1);
        Assertions.assertThat(rootURIs).isEmpty();
        new Commit(origin.getGit(), "user-branch-2", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2UserBranch.txt", JGitFileSystemImplProviderTest.this.tempFile("tempX"));
            }
        }).execute();
        this.provider.getFileSystem(URI.create("git://my-repo2?sync=git://localhost:" + this.gitDaemonPort + "/my-simple-test-origin-repo&force"));
        Assertions.assertThat((Iterable)fs2.getRootDirectories()).hasSize(3);
        for (Path root : fs2.getRootDirectories()) {
            rootURIs.add(root.toUri().toString());
        }
        rootURIs.removeAll(rootURIs2);
        Assertions.assertThat(rootURIs).isEmpty();
    }

    @Test
    public void testNewFileSystemCloneAndRescan() throws java.io.IOException {
        URI originRepo = URI.create("git://my-simple-test-origin-name");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, Collections.emptyMap());
        new Commit(origin.getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitFileSystemImplProviderTest.this.tempFile("temp"));
            }
        }).execute();
        URI newRepo = URI.create("git://my-repo-name");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", "git://localhost:" + JGitFileSystemImplProviderTest.this.gitDaemonPort + "/my-simple-test-origin-name");
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Iterable)fs.getRootDirectories()).hasSize(1);
        FileSystem fs2 = this.provider.getFileSystem(newRepo);
        Assertions.assertThat((Object)fs2).isNotNull();
        Assertions.assertThat((Iterable)fs2.getRootDirectories()).hasSize(1);
    }

    @Test
    public void testGetFileSystem() {
        URI newRepo = URI.create("git://new-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        Assertions.assertThat((Object)this.provider.getFileSystem(newRepo)).isEqualTo((Object)fs);
        Assertions.assertThat((Object)this.provider.getFileSystem(URI.create("git://master@new-repo-name"))).isEqualTo((Object)fs);
        Assertions.assertThat((Object)this.provider.getFileSystem(URI.create("git://branch@new-repo-name"))).isEqualTo((Object)fs);
        Assertions.assertThat((Object)this.provider.getFileSystem(URI.create("git://branch@new-repo-name?_fetch"))).isEqualTo((Object)fs);
    }

    @Test
    public void testInvalidURIGetFileSystem() {
        URI newRepo = URI.create("git:///new-repo-name");
        try {
            this.provider.getFileSystem(newRepo);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Parameter named 'uri' is invalid, missing host repository!");
        }
    }

    @Test
    public void testGetPath() {
        URI newRepo = URI.create("git://new-get-repo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@new-get-repo-name/home"));
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Path root = path.getRoot();
        Path path1 = root.toRealPath(new LinkOption[0]);
        Assertions.assertThat((String)root.toRealPath(new LinkOption[0]).toUri().toString()).isEqualTo((Object)"git://master@new-get-repo-name/");
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/home");
        Path pathRelative = this.provider.getPath(URI.create("git://master@new-get-repo-name/:home"));
        AssertionsForClassTypes.assertThat((Object)pathRelative).isNotNull();
        Assertions.assertThat((String)pathRelative.toRealPath(new LinkOption[0]).toUri().toString()).isEqualTo((Object)"git://master@new-get-repo-name/:home");
        Assertions.assertThat((String)pathRelative.getRoot().toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)pathRelative.toString()).isEqualTo((Object)"home");
    }

    @Test
    public void testInvalidURIGetPath() {
        URI uri = URI.create("git:///master@new-get-repo-name/home");
        try {
            this.provider.getPath(uri);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Parameter named 'uri' is invalid, missing host repository!");
        }
    }

    @Test
    public void testGetComplexPath() {
        URI newRepo = URI.create("git://new-complex-get-repo-name");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://origin/master@new-complex-get-repo-name/home"));
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/home");
        Path pathRelative = this.provider.getPath(URI.create("git://origin/master@new-complex-get-repo-name/:home"));
        AssertionsForClassTypes.assertThat((Object)pathRelative).isNotNull();
        Assertions.assertThat((String)pathRelative.getRoot().toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)pathRelative.toString()).isEqualTo((Object)"home");
    }

    @Test
    public void testGetComplexPathComposed() {
        URI newRepo = URI.create("git://new-complex-get-repo-name/composed");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path1 = this.provider.getPath(URI.create("git://new-complex-get-repo-name/composed/home"));
        AssertionsForClassTypes.assertThat((Object)path1).isNotNull();
        Assertions.assertThat((String)path1.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path1.toString()).isEqualTo((Object)"/home");
        Path path = this.provider.getPath(URI.create("git://origin/master@new-complex-get-repo-name/composed/home"));
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((String)path.getRoot().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/home");
        Path pathRelative = this.provider.getPath(URI.create("git://origin/master@new-complex-get-repo-name/composed/:home"));
        AssertionsForClassTypes.assertThat((Object)pathRelative).isNotNull();
        Assertions.assertThat((String)pathRelative.getRoot().toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)pathRelative.toString()).isEqualTo((Object)"home");
    }

    @Test
    public void testInputStream() throws java.io.IOException {
        File parentFolder = JGitFileSystemImplProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "user", "user@example.com", "commit message", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("myfile.txt", JGitFileSystemImplProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        }).execute();
        URI newRepo = URI.create("git://inputstream-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://master@inputstream-test-repo/myfile.txt"));
        InputStream inputStream = this.provider.newInputStream(path, new OpenOption[0]);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
        String content = new Scanner(inputStream).useDelimiter("\\A").next();
        inputStream.close();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"temp\n.origin\n.content");
    }

    @Test
    public void testInputStream2() throws java.io.IOException {
        File parentFolder = JGitFileSystemImplProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "user", "user@example.com", "commit message", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file/myfile.txt", JGitFileSystemImplProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        }).execute();
        URI newRepo = URI.create("git://xinputstream-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://master@xinputstream-test-repo/path/to/file/myfile.txt"));
        InputStream inputStream = this.provider.newInputStream(path, new OpenOption[0]);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
        String content = new Scanner(inputStream).useDelimiter("\\A").next();
        inputStream.close();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"temp\n.origin\n.content");
    }

    @Test(expected=NoSuchFileException.class)
    public void testInputStream3() throws java.io.IOException {
        File parentFolder = JGitFileSystemImplProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "user", "user@example.com", "commit message", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/file/myfile.txt", JGitFileSystemImplProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        }).execute();
        URI newRepo = URI.create("git://xxinputstream-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://origin/master@xxinputstream-test-repo/path/to"));
        this.provider.newInputStream(path, new OpenOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void testInputStreamNoSuchFile() throws java.io.IOException {
        File parentFolder = JGitFileSystemImplProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file.txt", JGitFileSystemImplProviderTest.this.tempFile("temp.origin.content.2"));
            }
        }).execute();
        URI newRepo = URI.create("git://inputstream-not-exists-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://origin/master@inputstream-not-exists-test-repo/temp.txt"));
        this.provider.newInputStream(path, new OpenOption[0]);
    }

    @Test
    public void testNewOutputStream() throws Exception {
        File parentFolder = JGitFileSystemImplProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "user", "user@example.com", "commit message", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("myfile.txt", JGitFileSystemImplProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        }).execute();
        new Commit(origin, "user_branch", "user", "user@example.com", "commit message", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/some/file/myfile.txt", JGitFileSystemImplProviderTest.this.tempFile("some\n.content\nhere"));
            }
        }).execute();
        URI newRepo = URI.create("git://outstream-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://user_branch@outstream-test-repo/some/path/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        InputStream inStream = this.provider.newInputStream(path, new OpenOption[0]);
        String content = new Scanner(inStream).useDelimiter("\\A").next();
        inStream.close();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"my cool content");
        try {
            this.provider.newOutputStream(this.provider.getPath(URI.create("git://user_branch@outstream-test-repo/some/path/")), new OpenOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IOException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNewOutputStreamWithJGitOp() throws Exception {
        File parentFolder = JGitFileSystemImplProviderTest.createTempDirectory();
        File gitFolder = new File(parentFolder, "mytest.git");
        final Git origin = (Git)new CreateRepository(gitFolder).execute().get();
        new Commit(origin, "master", "user", "user@example.com", "commit message", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("myfile.txt", JGitFileSystemImplProviderTest.this.tempFile("temp\n.origin\n.content"));
            }
        }).execute();
        new Commit(origin, "user_branch", "user", "user@example.com", "commit message", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("path/to/some/file/myfile.txt", JGitFileSystemImplProviderTest.this.tempFile("some\n.content\nhere"));
            }
        }).execute();
        URI newRepo = URI.create("git://outstreamwithop-test-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)env);
        Assertions.assertThat((Object)fs).isNotNull();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        CommentedOption op = new CommentedOption("User Tester", "user.tester@example.com", "omg, is it the end?", formatter.parse("31/12/2012"));
        Path path = this.provider.getPath(URI.create("git://user_branch@outstreamwithop-test-repo/some/path/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[]{op});
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        InputStream inStream = this.provider.newInputStream(path, new OpenOption[0]);
        String content = new Scanner(inStream).useDelimiter("\\A").next();
        inStream.close();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)content).isNotNull()).isEqualTo((Object)"my cool content");
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void testGetPathFileSystemNotExisting() {
        this.provider.getPath(URI.create("git://master@not-exists-get-repo-name/home"));
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void testGetFileSystemNotExisting() {
        URI newRepo = URI.create("git://not-new-repo-name");
        this.provider.getFileSystem(newRepo);
    }

    @Test
    public void testDeleteShouldRemoveEmptyParentDir() throws java.io.IOException {
        URI doraRepo = URI.create("git://parentDir/dora-repo");
        FileSystem doraFS = this.provider.newFileSystem(doraRepo, EMPTY_ENV);
        File doraRepoDir = ((JGitFileSystemProxy)doraFS).getGit().getRepository().getDirectory();
        File parentDir = doraRepoDir.getParentFile();
        File gitProviderDir = this.provider.getGitRepoContainerDir();
        URI doraRepo1 = URI.create("git://parentDir/dora-repo1");
        FileSystem doraFS1 = this.provider.newFileSystem(doraRepo1, EMPTY_ENV);
        File dora1RepoDir = ((JGitFileSystemProxy)doraFS1).getGit().getRepository().getDirectory();
        File parentDir1 = doraRepoDir.getParentFile();
        TestCase.assertEquals((Object)parentDir, (Object)parentDir1);
        this.provider.delete(doraFS.getPath(null, new String[0]), new DeleteOption[0]);
        Assert.assertFalse((boolean)doraRepoDir.exists());
        Assert.assertTrue((boolean)parentDir.exists());
        Assert.assertTrue((boolean)gitProviderDir.exists());
        this.provider.delete(doraFS1.getPath(null, new String[0]), new DeleteOption[0]);
        Assert.assertFalse((boolean)dora1RepoDir.exists());
        Assert.assertFalse((boolean)parentDir1.exists());
        Assert.assertTrue((boolean)gitProviderDir.exists());
    }

    @Test
    public void testDelete() throws java.io.IOException {
        URI newRepo = URI.create("git://delete1-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@delete1-test-repo/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.newInputStream(path, new OpenOption[0]).close();
        try {
            this.provider.delete(this.provider.getPath(URI.create("git://user_branch@delete1-test-repo/non_existent_path")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        try {
            this.provider.delete(this.provider.getPath(URI.create("git://user_branch@delete1-test-repo/path/to/")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(DirectoryNotEmptyException.class);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            // empty catch block
        }
        this.provider.delete(path, new DeleteOption[0]);
        try {
            this.provider.newFileSystem(newRepo, EMPTY_ENV);
            Assertions.failBecauseExceptionWasNotThrown(FileSystemAlreadyExistsException.class);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        Path fsPath = path.getFileSystem().getPath(null, new String[0]);
        this.provider.delete(fsPath, new DeleteOption[0]);
        Assertions.assertThat((boolean)fsPath.getFileSystem().isOpen()).isEqualTo(false);
        URI newRepo2 = URI.create("git://delete1-test-repo");
        this.provider.newFileSystem(newRepo2, EMPTY_ENV);
    }

    @Test
    public void testDeleteBranch() throws java.io.IOException {
        URI newRepo = URI.create("git://delete-branch-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@delete-branch-test-repo/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.newInputStream(path, new OpenOption[0]).close();
        this.provider.delete(this.provider.getPath(URI.create("git://user_branch@delete-branch-test-repo")), new DeleteOption[0]);
        try {
            this.provider.delete(this.provider.getPath(URI.create("git://user_branch@delete-branch-test-repo")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        try {
            this.provider.delete(this.provider.getPath(URI.create("git://some_user_branch@delete-branch-test-repo")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteIfExists() throws java.io.IOException {
        URI newRepo = URI.create("git://deleteifexists1-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@deleteifexists1-test-repo/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.newInputStream(path, new OpenOption[0]).close();
        Assertions.assertThat((boolean)this.provider.deleteIfExists(this.provider.getPath(URI.create("git://user_branch@deleteifexists1-test-repo/non_existent_path")), new DeleteOption[0])).isFalse();
        try {
            this.provider.deleteIfExists(this.provider.getPath(URI.create("git://user_branch@deleteifexists1-test-repo/path/to/")), new DeleteOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(DirectoryNotEmptyException.class);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            // empty catch block
        }
        Assertions.assertThat((boolean)this.provider.deleteIfExists(path, new DeleteOption[0])).isTrue();
    }

    @Test
    public void testDeleteBranchIfExists() throws java.io.IOException {
        URI newRepo = URI.create("git://deletebranchifexists1-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@deletebranchifexists1-test-repo/path/to/myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.newInputStream(path, new OpenOption[0]).close();
        Assertions.assertThat((boolean)this.provider.deleteIfExists(this.provider.getPath(URI.create("git://user_branch@deletebranchifexists1-test-repo")), new DeleteOption[0])).isTrue();
        Assertions.assertThat((boolean)this.provider.deleteIfExists(this.provider.getPath(URI.create("git://not_user_branch@deletebranchifexists1-test-repo")), new DeleteOption[0])).isFalse();
        Assertions.assertThat((boolean)this.provider.deleteIfExists(this.provider.getPath(URI.create("git://user_branch@deletebranchifexists1-test-repo")), new DeleteOption[0])).isFalse();
    }

    @Test
    public void testIsHidden() throws java.io.IOException {
        URI newRepo = URI.create("git://ishidden-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/.myfile.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/myfile.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        Assertions.assertThat((Object)outStream2).isNotNull();
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/.myfile.txt")))).isTrue();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/myfile.txt")))).isFalse();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/non_existent/.myfile.txt")))).isTrue();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/path/to/non_existent/myfile.txt")))).isFalse();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/")))).isFalse();
        Assertions.assertThat((boolean)this.provider.isHidden(this.provider.getPath(URI.create("git://user_branch@ishidden-test-repo/some")))).isFalse();
    }

    @Test
    public void testIsSameFile() throws java.io.IOException {
        URI newRepo = URI.create("git://issamefile-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@issamefile-test-repo/path/to/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@issamefile-test-repo/path/to/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@issamefile-test-repo/path/to/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Assertions.assertThat((boolean)this.provider.isSameFile(path, path2)).isTrue();
        Assertions.assertThat((boolean)this.provider.isSameFile(path, path3)).isTrue();
    }

    @Test
    public void testCreateDirectory() {
        URI newRepo = URI.create("git://xcreatedir-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        JGitPathImpl path = (JGitPathImpl)this.provider.getPath(URI.create("git://master@xcreatedir-test-repo/some/path/to/"));
        PathInfo result = ((JGitFileSystem)path.getFileSystem()).getGit().getPathInfo(path.getRefTree(), path.getPath());
        Assertions.assertThat((Comparable)result.getPathType()).isEqualTo((Object)PathType.NOT_FOUND);
        this.provider.createDirectory((Path)path, new FileAttribute[0]);
        PathInfo resultAfter = ((JGitFileSystem)path.getFileSystem()).getGit().getPathInfo(path.getRefTree(), path.getPath());
        Assertions.assertThat((Comparable)resultAfter.getPathType()).isEqualTo((Object)PathType.DIRECTORY);
        Path gitkeepPath = path.resolve(".gitkeep");
        Assertions.assertThat((boolean)this.provider.exists(gitkeepPath)).isEqualTo(true);
        try {
            this.provider.createDirectory((Path)path, new FileAttribute[0]);
            Assertions.failBecauseExceptionWasNotThrown(FileAlreadyExistsException.class);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckAccess() throws Exception {
        URI newRepo = URI.create("git://checkaccess-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@checkaccess-test-repo/path/to/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        this.provider.checkAccess(path, new AccessMode[0]);
        Path path_to_dir = this.provider.getPath(URI.create("git://master@checkaccess-test-repo/path/to"));
        this.provider.checkAccess(path_to_dir, new AccessMode[0]);
        Path path_not_exists = this.provider.getPath(URI.create("git://master@checkaccess-test-repo/path/to/some.txt"));
        try {
            this.provider.checkAccess(path_not_exists, new AccessMode[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFileStore() throws Exception {
        URI newRepo = URI.create("git://filestore-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@filestore-test-repo/path/to/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        FileStore fileStore = this.provider.getFileStore(path);
        Assertions.assertThat((Object)fileStore).isNotNull();
        Assertions.assertThat((Object)fileStore.getAttribute("readOnly")).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void testNewDirectoryStream() throws java.io.IOException {
        URI newRepo = URI.create("git://dirstream-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@dirstream-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        DirectoryStream stream1 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/")), null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream1).isNotNull()).hasSize(2)).contains((Object[])new Path[]{path3, this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other"))});
        DirectoryStream stream2 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other")), null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream2).isNotNull()).hasSize(1)).contains((Object[])new Path[]{this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other/path"))});
        DirectoryStream stream3 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@dirstream-test-repo/other/path")), null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream3).isNotNull()).hasSize(1)).contains((Object[])new Path[]{path2});
        DirectoryStream stream4 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://master@dirstream-test-repo/")), null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream4).isNotNull()).hasSize(1)).contains((Object[])new Path[]{path});
        try {
            this.provider.newDirectoryStream(path, null);
            Assertions.failBecauseExceptionWasNotThrown(NotDirectoryException.class);
        }
        catch (NotDirectoryException notDirectoryException) {
            // empty catch block
        }
        Path crazyPath = this.provider.getPath(URI.create("git://master@dirstream-test-repo/crazy/path/here"));
        try {
            this.provider.newDirectoryStream(crazyPath, null);
            Assertions.failBecauseExceptionWasNotThrown(NotDirectoryException.class);
        }
        catch (NotDirectoryException notDirectoryException) {
            // empty catch block
        }
        this.provider.createDirectory(crazyPath, new FileAttribute[0]);
        ((IterableAssert)Assertions.assertThat((Iterable)this.provider.newDirectoryStream(crazyPath, null)).isNotNull()).hasSize(1);
    }

    @Test
    public void testDeleteNonEmptyDirectory() throws java.io.IOException {
        URI newRepo = URI.create("git://delete-non-empty-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path dir = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path"));
        Path _root = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/myfile1.txt"));
        OutputStream outRootStream = this.provider.newOutputStream(_root, new OpenOption[0]);
        outRootStream.write("my cool content".getBytes());
        outRootStream.close();
        Path path = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path dir1 = this.provider.getPath(URI.create("git://master@delete-non-empty-test-repo/other/path/dir"));
        this.provider.createDirectory(dir1, new FileAttribute[0]);
        DirectoryStream stream3 = this.provider.newDirectoryStream(dir, null);
        ((IterableAssert)Assertions.assertThat((Iterable)stream3).isNotNull()).hasSize(4);
        try {
            this.provider.delete(dir, new DeleteOption[0]);
            Assertions.fail((String)"dir not empty");
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            // empty catch block
        }
        try {
            CommentedOption op = new CommentedOption("User Tester", "user.tester@example.com", "omg, erase dir!");
            this.provider.delete(dir, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES, op});
        }
        catch (DirectoryNotEmptyException ignore) {
            Assertions.fail((String)"dir should be deleted!");
        }
        Assertions.assertThat((boolean)this.provider.exists(dir)).isEqualTo(false);
    }

    @Test
    public void testFilteredNewDirectoryStream() throws java.io.IOException {
        URI newRepo = URI.create("git://filter-dirstream-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@filter-dirstream-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@filter-dirstream-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@filter-dirstream-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        Path path4 = this.provider.getPath(URI.create("git://user_branch@filter-dirstream-test-repo/myfile4.xxx"));
        OutputStream outStream4 = this.provider.newOutputStream(path4, new OpenOption[0]);
        outStream4.write("my cool content".getBytes());
        outStream4.close();
        DirectoryStream stream1 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://user_branch@filter-dirstream-test-repo/")), entry -> entry.toString().endsWith(".xxx"));
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)stream1).isNotNull()).hasSize(1)).contains((Object[])new Path[]{path4});
        DirectoryStream stream2 = this.provider.newDirectoryStream(this.provider.getPath(URI.create("git://master@filter-dirstream-test-repo/")), entry -> false);
        ((IterableAssert)Assertions.assertThat((Iterable)stream2).isNotNull()).hasSize(0);
    }

    @Test
    public void testGetFileAttributeView() throws java.io.IOException {
        URI newRepo = URI.create("git://getfileattriview-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@getfileattriview-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@getfileattriview-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@getfileattriview-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        JGitVersionAttributeView attrs = (JGitVersionAttributeView)this.provider.getFileAttributeView(path3, JGitVersionAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((int)attrs.readAttributes().history().records().size()).isEqualTo(1);
        Assertions.assertThat((String)((VersionRecord)attrs.readAttributes().history().records().get(0)).uri()).isNotNull();
        Assertions.assertThat((boolean)attrs.readAttributes().isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.readAttributes().isRegularFile()).isTrue();
        Assertions.assertThat((Comparable)attrs.readAttributes().creationTime()).isNotNull();
        Assertions.assertThat((Comparable)attrs.readAttributes().lastModifiedTime()).isNotNull();
        Assertions.assertThat((long)attrs.readAttributes().size()).isEqualTo(15L);
        try {
            this.provider.getFileAttributeView(this.provider.getPath(URI.create("git://user_branch@getfileattriview-test-repo/not_exists.txt")), BasicFileAttributeView.class, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertThat((Object)this.provider.getFileAttributeView(path3, MyInvalidFileAttributeView.class, new LinkOption[0])).isNull();
        Path rootPath = this.provider.getPath(URI.create("git://user_branch@getfileattriview-test-repo/"));
        BasicFileAttributeView attrsRoot = (BasicFileAttributeView)this.provider.getFileAttributeView(rootPath, BasicFileAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((boolean)attrsRoot.readAttributes().isDirectory()).isTrue();
        Assertions.assertThat((boolean)attrsRoot.readAttributes().isRegularFile()).isFalse();
        Assertions.assertThat((Comparable)attrsRoot.readAttributes().creationTime()).isNotNull();
        Assertions.assertThat((Comparable)attrsRoot.readAttributes().lastModifiedTime()).isNotNull();
        Assertions.assertThat((long)attrsRoot.readAttributes().size()).isEqualTo(-1L);
        Path prRootPath = this.provider.getPath(URI.create("git://PR-1-from/develop-master@getfileattriview-test-repo/"));
        HiddenAttributeView extendedAttrs = (HiddenAttributeView)this.provider.getFileAttributeView(prRootPath, HiddenAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((boolean)extendedAttrs.readAttributes().isDirectory()).isTrue();
        Assertions.assertThat((boolean)extendedAttrs.readAttributes().isRegularFile()).isFalse();
        Assertions.assertThat((boolean)extendedAttrs.readAttributes().isHidden()).isEqualTo(true);
        Assertions.assertThat((long)extendedAttrs.readAttributes().size()).isEqualTo(-1L);
        Assertions.assertThat((Comparable)extendedAttrs.readAttributes().creationTime()).isNotNull();
        Assertions.assertThat((Comparable)extendedAttrs.readAttributes().lastModifiedTime()).isNotNull();
    }

    @Test
    public void testReadAttributes() throws java.io.IOException {
        URI newRepo = URI.create("git://readattrs-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@readattrs-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@readattrs-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@readattrs-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        BasicFileAttributes attrs = this.provider.readAttributes(path3, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((boolean)attrs.isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.isRegularFile()).isTrue();
        Assertions.assertThat((Comparable)attrs.creationTime()).isNotNull();
        Assertions.assertThat((Comparable)attrs.lastModifiedTime()).isNotNull();
        Assertions.assertThat((long)attrs.size()).isEqualTo(15L);
        try {
            this.provider.readAttributes(this.provider.getPath(URI.create("git://user_branch@readattrs-test-repo/not_exists.txt")), BasicFileAttributes.class, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        Assertions.assertThat((Object)this.provider.readAttributes(path3, MyAttrs.class, new LinkOption[0])).isNull();
        Path rootPath = this.provider.getPath(URI.create("git://user_branch@readattrs-test-repo/"));
        BasicFileAttributes attrsRoot = this.provider.readAttributes(rootPath, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((boolean)attrsRoot.isDirectory()).isTrue();
        Assertions.assertThat((boolean)attrsRoot.isRegularFile()).isFalse();
        Assertions.assertThat((Comparable)attrsRoot.creationTime()).isNotNull();
        Assertions.assertThat((Comparable)attrsRoot.lastModifiedTime()).isNotNull();
        Assertions.assertThat((long)attrsRoot.size()).isEqualTo(-1L);
    }

    @Test
    public void testReadAttributesMap() throws java.io.IOException {
        URI newRepo = URI.create("git://readattrsmap-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@readattrsmap-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@readattrsmap-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@readattrsmap-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "basic:someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "version:version", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(path, "someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        try {
            this.provider.readAttributes(path, ":someThing", new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.provider.readAttributes(path, "advanced:isRegularFile", new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Path rootPath = this.provider.getPath(URI.create("git://user_branch@readattrsmap-test-repo/"));
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "basic:someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)this.provider.readAttributes(rootPath, "someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        try {
            this.provider.readAttributes(rootPath, ":someThing", new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.provider.readAttributes(rootPath, "advanced:isRegularFile", new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.provider.readAttributes(this.provider.getPath(URI.create("git://user_branch@readattrsmap-test-repo/not_exists.txt")), BasicFileAttributes.class, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NoSuchFileException.class);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Test
    public void testSetAttribute() throws java.io.IOException {
        URI newRepo = URI.create("git://setattr-test-repo");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://master@setattr-test-repo/myfile1.txt"));
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        outStream.write("my cool content".getBytes());
        outStream.close();
        Path path2 = this.provider.getPath(URI.create("git://user_branch@setattr-test-repo/other/path/myfile2.txt"));
        OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
        outStream2.write("my cool content".getBytes());
        outStream2.close();
        Path path3 = this.provider.getPath(URI.create("git://user_branch@setattr-test-repo/myfile3.txt"));
        OutputStream outStream3 = this.provider.newOutputStream(path3, new OpenOption[0]);
        outStream3.write("my cool content".getBytes());
        outStream3.close();
        try {
            this.provider.setAttribute(path3, "basic:isRegularFile", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NotImplementedException.class);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            this.provider.setAttribute(path3, "isRegularFile", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(NotImplementedException.class);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            this.provider.setAttribute(path3, "notExisits", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IllegalStateException.class);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.provider.setAttribute(path3, "advanced:notExisits", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.provider.setAttribute(path3, ":isRegularFile", (Object)true, new LinkOption[0]);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkProperAmend() throws Exception {
        URI newRepo = URI.create("git://outstream-test-repo");
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        Assertions.assertThat((Object)fs).isNotNull();
        for (int z = 0; z < 5; ++z) {
            Path _path = this.provider.getPath(URI.create("git://user_branch@outstream-test-repo/some/path/myfile.txt"));
            this.provider.setAttribute(_path, FileSystemState.FILE_SYSTEM_STATE_ATTR, (Object)FileSystemState.BATCH, new LinkOption[0]);
            Path path = this.provider.getPath(URI.create("git://user_branch@outstream-test-repo/some/path/myfile.txt"));
            OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
            Assertions.assertThat((Object)outStream).isNotNull();
            outStream.write(("my cool content" + z).getBytes());
            outStream.close();
            Path path2 = this.provider.getPath(URI.create("git://error_branch@outstream-test-repo/some/path/myfile.txt"));
            OutputStream outStream2 = this.provider.newOutputStream(path2, new OpenOption[0]);
            Assertions.assertThat((Object)outStream2).isNotNull();
            outStream2.write(("bad content" + z).getBytes());
            outStream2.close();
            this.provider.setAttribute(_path, FileSystemState.FILE_SYSTEM_STATE_ATTR, (Object)FileSystemState.NORMAL, new LinkOption[0]);
        }
        Path path = this.provider.getPath(URI.create("git://error_branch@outstream-test-repo/some/path/myfile.txt"));
        JGitVersionAttributeView attrs = (JGitVersionAttributeView)this.provider.getFileAttributeView(path.getRoot(), JGitVersionAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((int)attrs.readAttributes().history().records().size()).isEqualTo(5);
    }

    @Test
    public void accessOldVersions() throws Exception {
        URI newRepo = URI.create("git://old-versions-test-repo");
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        Assertions.assertThat((Object)fs).isNotNull();
        for (int i = 0; i < 5; ++i) {
            Path path = this.provider.getPath(URI.create("git://old-versions-test-repo/some/path/myfile.txt"));
            OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
            Assertions.assertThat((Object)outStream).isNotNull();
            outStream.write(("my cool content" + i).getBytes());
            outStream.close();
        }
        Path path = this.provider.getPath(URI.create("git://old-versions-test-repo/some/path/myfile.txt"));
        JGitVersionAttributeView attrs = (JGitVersionAttributeView)this.provider.getFileAttributeView(path, JGitVersionAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((int)attrs.readAttributes().history().records().size()).isEqualTo(5);
        for (int i = 0; i < 5; ++i) {
            Path oldPath = this.provider.getPath(URI.create("git://" + ((VersionRecord)attrs.readAttributes().history().records().get(i)).id() + "@old-versions-test-repo/some/path/myfile.txt"));
            InputStream stream = this.provider.newInputStream(oldPath, new OpenOption[0]);
            TestCase.assertNotNull((Object)stream);
            String content = new Scanner(stream).useDelimiter("\\A").next();
            TestCase.assertEquals((String)("my cool content" + i), (String)content);
        }
    }

    @Test
    public void checkProperSquash() throws java.io.IOException, GitAPIException {
        URI newRepo = URI.create("git://squash-repo");
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path generalPath = this.provider.getPath(URI.create("git://master@squash-repo/"));
        Path path = this.provider.getPath(URI.create("git://master@squash-repo/myfile1.txt"));
        Path path2 = this.provider.getPath(URI.create("git://master@squash-repo/myfile2.txt"));
        Path path3 = this.provider.getPath(URI.create("git://master@squash-repo/myfile3.txt"));
        OutputStream aStream = this.provider.newOutputStream(path, new OpenOption[0]);
        aStream.write("my cool content".getBytes());
        aStream.close();
        RevCommit commit = (RevCommit)((GitImpl)fs.getGit())._log().add((AnyObjectId)fs.getGit().getRef("master").getObjectId()).setMaxCount(1).call().iterator().next();
        OutputStream bStream = this.provider.newOutputStream(path2, new OpenOption[0]);
        bStream.write("my cool content".getBytes());
        bStream.close();
        OutputStream cStream = this.provider.newOutputStream(path3, new OpenOption[0]);
        cStream.write("my cool content".getBytes());
        cStream.close();
        VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing!", new Date(), commit.getName());
        SquashOption squashOption = new SquashOption(record);
        this.provider.setAttribute(generalPath, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
        int commitsCount = 0;
        for (RevCommit com : ((GitImpl)fs.getGit())._log().all().call()) {
            ++commitsCount;
            System.out.println(com.getName() + " - " + com.getFullMessage());
        }
        Assertions.assertThat((int)commitsCount).isEqualTo(2);
    }

    @Test(expected=GitException.class)
    public void testSquashFailBecauseCommitIsFromAnotherBranch() throws java.io.IOException, GitAPIException {
        URI newRepo = URI.create("git://squash-repo");
        JGitFileSystem fs = (JGitFileSystem)this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path generalPath = this.provider.getPath(URI.create("git://master@squash-repo/"));
        Path path = this.provider.getPath(URI.create("git://develop@squash-repo/myfile1.txt"));
        Path path2 = this.provider.getPath(URI.create("git://master@squash-repo/myfile2.txt"));
        Path path3 = this.provider.getPath(URI.create("git://master@squash-repo/myfile3.txt"));
        OutputStream aStream = this.provider.newOutputStream(path, new OpenOption[0]);
        aStream.write("my cool content".getBytes());
        aStream.close();
        List<RevCommit> commits = this.getCommitsFromBranch((GitImpl)fs.getGit(), "develop");
        OutputStream bStream = this.provider.newOutputStream(path2, new OpenOption[0]);
        bStream.write("my cool content".getBytes());
        bStream.close();
        OutputStream cStream = this.provider.newOutputStream(path3, new OpenOption[0]);
        cStream.write("my cool content".getBytes());
        cStream.close();
        VersionRecord record = this.makeVersionRecord("aparedes", "aparedes@redhat.com", "squashing!", new Date(), commits.get(0).getName());
        SquashOption squashOption = new SquashOption(record);
        this.provider.setAttribute(generalPath, "SQUASH_ATTR", (Object)squashOption, new LinkOption[0]);
    }

    @Test
    public void checkBatchError() throws Exception {
        URI newRepo = URI.create("git://outstream-test-repo");
        FileSystem fs = this.provider.newFileSystem(newRepo, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        this.provider = (JGitFileSystemProvider)Mockito.spy((Object)this.provider);
        ((JGitFileSystemProvider)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.provider)).notifyDiffs((JGitFileSystem)Mockito.any(JGitFileSystemImpl.class), (String)Mockito.any(String.class), (String)Mockito.any(String.class), (String)Mockito.any(String.class), (String)Mockito.any(String.class), (ObjectId)Mockito.any(ObjectId.class), (ObjectId)Mockito.any(ObjectId.class));
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://user_branch@outstream-test-repo/some/path/myfile.txt"));
        this.provider.setAttribute(path, FileSystemState.FILE_SYSTEM_STATE_ATTR, (Object)FileSystemState.BATCH, new LinkOption[0]);
        OutputStream outStream = this.provider.newOutputStream(path, new OpenOption[0]);
        Assertions.assertThat((Object)outStream).isNotNull();
        outStream.write("my cool content".getBytes());
        outStream.close();
        try {
            this.provider.setAttribute(path, FileSystemState.FILE_SYSTEM_STATE_ATTR, (Object)FileSystemState.NORMAL, new LinkOption[0]);
        }
        catch (Exception ex) {
            Assertions.fail((String)"Batch can't fail!", (Throwable)ex);
        }
    }

    @Test
    public void resolveFSName() {
        String fsName = "dora-repo";
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("git://dora-repo")));
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("default://dora-repo")));
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("git://branch@dora-repo")));
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("default://branch@dora-repo")));
        fsName = "dora-repo/subdir";
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("git://dora-repo/subdir")));
        TestCase.assertEquals((String)"dora-repo/subdir", (String)this.provider.extractFSName(URI.create("default://dora-repo/subdir")));
        TestCase.assertEquals((String)"dora-repo/subdir", (String)this.provider.extractFSName(URI.create("git://branch@dora-repo/subdir")));
        TestCase.assertEquals((String)"dora-repo/subdir", (String)this.provider.extractFSName(URI.create("default://branch@dora-repo/subdir")));
        fsName = "dora-repo/subdir/subdir";
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("git://dora-repo/subdir/subdir")));
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("default://dora-repo/subdir/subdir")));
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("git://branch@dora-repo/subdir/subdir")));
        TestCase.assertEquals((String)fsName, (String)this.provider.extractFSName(URI.create("default://branch@dora-repo/subdir/subdir")));
    }

    @Test
    public void resolveSimpleFSNames() {
        URI newRepo = URI.create("git://dora-repo");
        try {
            Path path = this.provider.getPath(URI.create("git://dora-repo/some/path/myfile.txt"));
            Assertions.fail((String)"should triggered FileSystemNotFoundException");
        }
        catch (FileSystemNotFoundException path) {
            // empty catch block
        }
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Assertions.assertThat((Object)fs).isNotNull();
        Path path = this.provider.getPath(URI.create("git://dora-repo/some/path/myfile.txt"));
        Path another = this.provider.getPath(URI.create("git://dora-repo/another/path/myfile.txt"));
        TestCase.assertEquals((Object)fs, (Object)path.getFileSystem());
        TestCase.assertEquals((Object)path.getFileSystem(), (Object)another.getFileSystem());
    }

    @Test
    public void resolveComposedFSNames() {
        URI simpleName = URI.create("git://dora-repo");
        FileSystem fsSimpleName = this.provider.newFileSystem(simpleName, EMPTY_ENV);
        Assertions.assertThat((Object)fsSimpleName).isNotNull();
        URI composedName = URI.create("git://ou-dora/dora-repo");
        FileSystem fsComposedName = this.provider.newFileSystem(composedName, EMPTY_ENV);
        Assertions.assertThat((Object)fsComposedName).isNotNull();
        junit.framework.Assert.assertNotSame((Object)fsSimpleName, (Object)fsComposedName);
        TestCase.assertEquals((Object)fsSimpleName, (Object)this.provider.getFileSystem(simpleName));
        TestCase.assertEquals((Object)fsComposedName, (Object)this.provider.getFileSystem(composedName));
        URI simpleFileName = URI.create("git://dora-repo/file.txt");
        TestCase.assertEquals((Object)fsSimpleName, (Object)this.provider.getFileSystem(simpleFileName));
        URI composedFileName = URI.create("git://ou-dora/dora-repo/file.txt");
        TestCase.assertEquals((Object)fsComposedName, (Object)this.provider.getFileSystem(composedFileName));
    }

    @Test
    public void validFSNameTest() {
        this.checkAmbiguousFS("git://dora-repo", "git://dora-repo/subdir");
        this.checkAmbiguousFS("git://bento-repo/subdir", "git://bento-repo");
        this.checkAmbiguousFS("git://leao", "default://leao/subdir/subdir");
        this.checkAmbiguousFS("git://rex/subdir", "git://rex", "git://rex/subdir/subdir", "git://rex/subdir/subdir");
        this.provider.newFileSystem(URI.create("git://ou/dora"), EMPTY_ENV);
        this.provider.newFileSystem(URI.create("git://user1/dora"), EMPTY_ENV);
        this.provider.newFileSystem(URI.create("git://user2/dora"), EMPTY_ENV);
        this.provider.newFileSystem(URI.create("git://user3/dora"), EMPTY_ENV);
    }

    private void checkAmbiguousFS(String fsOriginalName, String ... ambiguousFsName) {
        this.provider.newFileSystem(URI.create(fsOriginalName), EMPTY_ENV);
        try {
            for (String fsName : ambiguousFsName) {
                this.provider.newFileSystem(URI.create(fsName), EMPTY_ENV);
            }
            Assertions.fail((String)"ambiguous fs");
        }
        catch (AmbiguousFileSystemNameException ambiguousFileSystemNameException) {
            // empty catch block
        }
    }

    @Test
    public void checkRootPath() {
        URI composedName = URI.create("git://dora-repo/subdir1");
        FileSystem fsComposedName = this.provider.newFileSystem(composedName, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("git://dora-repo/subdir1/file.txt"));
        Path path1 = this.provider.getPath(URI.create("git://origin/bla@dora-repo/subdir1/file2.txt"));
        TestCase.assertEquals((Object)fsComposedName, (Object)path.getRoot().getFileSystem());
        TestCase.assertEquals((Object)fsComposedName, (Object)path1.getRoot().getFileSystem());
    }

    @Test
    public void getPathForComposedFSNames() {
        URI composedName = URI.create("git://dora-repo/subdir1");
        FileSystem fsComposedName = this.provider.newFileSystem(composedName, EMPTY_ENV);
        URI simpleFileName = URI.create("git://dora-repo/subdir1/file.txt");
        Path path = this.provider.getPath(simpleFileName);
        TestCase.assertEquals((Object)fsComposedName, (Object)path.getFileSystem());
        TestCase.assertEquals((String)"/file.txt", (String)((JGitPathImpl)path).getPath());
        URI simpleName = URI.create("git://bento-repo/");
        FileSystem fsSimpleName = this.provider.newFileSystem(simpleName, EMPTY_ENV);
        URI composedFileName = URI.create("git://bento-repo/subdir1/file.txt");
        path = this.provider.getPath(composedFileName);
        TestCase.assertEquals((Object)fsSimpleName, (Object)path.getFileSystem());
        TestCase.assertEquals((String)"/subdir1/file.txt", (String)((JGitPathImpl)path).getPath());
        composedFileName = URI.create("git://bento-repo/subdir1/subdir2/file.txt");
        path = this.provider.getPath(composedFileName);
        TestCase.assertEquals((Object)fsSimpleName, (Object)path.getFileSystem());
        TestCase.assertEquals((String)"/subdir1/subdir2/file.txt", (String)((JGitPathImpl)path).getPath());
        composedFileName = URI.create("git://bento-repo/subdir1/subdir2/subdir3");
        path = this.provider.getPath(composedFileName);
        TestCase.assertEquals((Object)fsSimpleName, (Object)path.getFileSystem());
        TestCase.assertEquals((String)"/subdir1/subdir2/subdir3", (String)((JGitPathImpl)path).getPath());
    }

    @Test
    public void getPathForComposedFSNames2() {
        URI composedName = URI.create("git://user1/dora");
        FileSystem fsComposedName1 = this.provider.newFileSystem(composedName, EMPTY_ENV);
        URI composedName2 = URI.create("git://user2/dora");
        FileSystem fsComposedName2 = this.provider.newFileSystem(composedName2, EMPTY_ENV);
        URI composedFileName1 = URI.create("git://user1/dora/file.txt");
        Path path1 = this.provider.getPath(composedFileName1);
        URI composedFileName2 = URI.create("git://user2/dora/file.txt");
        Path path2 = this.provider.getPath(composedFileName2);
        Assert.assertNotEquals((Object)fsComposedName1, (Object)fsComposedName2);
        Assert.assertNotEquals((Object)path1.getFileSystem(), (Object)path2.getFileSystem());
        TestCase.assertEquals((String)path2.toString(), (String)this.provider.extractPath(composedFileName2));
    }

    @Test
    public void extractPathTest() {
        URI composedName = URI.create("git://user1/dora");
        FileSystem fsComposedName1 = this.provider.newFileSystem(composedName, EMPTY_ENV);
        URI composedFileName1 = URI.create("git://user1/dora/file.txt");
        Path path1 = this.provider.getPath(composedFileName1);
        TestCase.assertEquals((String)path1.toString(), (String)this.provider.extractPath(composedFileName1));
    }

    @Test
    public void resolveByRepositoryTest() {
        JGitFileSystem fsSimpleName = ((JGitFileSystemProxy)this.provider.newFileSystem(URI.create("git://repo"), EMPTY_ENV)).getRealJGitFileSystem();
        JGitFileSystemProvider.RepositoryResolverImpl objectRepositoryResolver = new JGitFileSystemProvider.RepositoryResolverImpl(this.provider);
        TestCase.assertEquals((Object)fsSimpleName, (Object)objectRepositoryResolver.resolveFileSystem(fsSimpleName.getGit().getRepository()));
        JGitFileSystem fsComposedName1 = ((JGitFileSystemProxy)this.provider.newFileSystem(URI.create("git://user1/dora"), EMPTY_ENV)).getRealJGitFileSystem();
        TestCase.assertEquals((Object)fsComposedName1, (Object)objectRepositoryResolver.resolveFileSystem(fsComposedName1.getGit().getRepository()));
    }

    private VersionRecord makeVersionRecord(final String author, final String email, final String comment, final Date date, final String commit) {
        return new VersionRecord(){

            public String id() {
                return commit;
            }

            public String author() {
                return author;
            }

            public String email() {
                return email;
            }

            public String comment() {
                return comment;
            }

            public Date date() {
                return date;
            }

            public String uri() {
                return null;
            }
        };
    }

    private List<RevCommit> getCommitsFromBranch(GitImpl origin, String branch) throws GitAPIException, MissingObjectException, IncorrectObjectTypeException {
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        ObjectId id = new GetRef(origin.getRepository(), branch).execute().getObjectId();
        for (RevCommit commit : origin._log().add((AnyObjectId)id).call()) {
            commits.add(commit);
        }
        return commits;
    }

    private static interface MyAttrs
    extends BasicFileAttributes {
    }

    private static class MyInvalidFileAttributeView
    implements BasicFileAttributeView {
        private MyInvalidFileAttributeView() {
        }

        public BasicFileAttributes readAttributes() throws IOException {
            return null;
        }

        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        }

        public String name() {
            return null;
        }
    }
}

