/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class Fork {
    private static final String DOT_GIT_EXT = ".git";
    private final KetchLeaderCache leaders;
    private Logger logger = LoggerFactory.getLogger(Fork.class);
    private File parentFolder;
    private final String source;
    private final String target;
    private CredentialsProvider credentialsProvider;
    private final File hookDir;

    public Fork(File parentFolder, String source, String target, CredentialsProvider credentialsProvider, KetchLeaderCache leaders, File hookDir) {
        this.parentFolder = (File)PortablePreconditions.checkNotNull((String)"parentFolder", (Object)parentFolder);
        this.source = PortablePreconditions.checkNotEmpty((String)"source", (String)source);
        this.target = PortablePreconditions.checkNotEmpty((String)"target", (String)target);
        this.credentialsProvider = (CredentialsProvider)PortablePreconditions.checkNotNull((String)"credentialsProvider", (Object)credentialsProvider);
        this.leaders = leaders;
        this.hookDir = hookDir;
    }

    public Git execute() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Forking repository <{}> to <{}>", (Object)this.source, (Object)this.target);
        }
        File origin = new File(this.parentFolder, this.source + DOT_GIT_EXT);
        File destination = new File(this.parentFolder, this.target + DOT_GIT_EXT);
        if (destination.exists()) {
            String message = String.format("Cannot fork because destination repository <%s> already exists", this.target);
            this.logger.error(message);
            throw new GitException(message);
        }
        return Git.clone(destination, origin.toPath().toUri().toString(), false, this.credentialsProvider, this.leaders, this.hookDir);
    }
}

