/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.lib.Repository;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;

public class JGitFileSystemImplProviderDiffTest
extends AbstractTestInfra {
    private Logger logger = LoggerFactory.getLogger(JGitFileSystemImplProviderDiffTest.class);

    @Test
    public void testDiffsBetweenBranches() throws IOException {
        File parentFolder = JGitFileSystemImplProviderDiffTest.createTempDirectory();
        File gitSource = new File(parentFolder, "repo.git");
        final Git origin = (Git)new CreateRepository(gitSource).execute().get();
        Repository gitRepo = origin.getRepository();
        new Commit(origin, "master", "name", "name@example.com", "master-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1\ntemp1\ntemp3\nmiddle\nmoremiddle\nmoremiddle\nmoremiddle\nother\n"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "master", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1\ntemp2\nmiddle\nmoremiddle\nmoremiddle\nmoremiddle\n"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-2", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", AbstractTestInfra.tempFile("temp3"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-3", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", AbstractTestInfra.tempFile("temp4"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-4", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", AbstractTestInfra.tempFile("temp5"));
            }
        }).execute();
        URI newRepo = URI.create("git://diff-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        this.provider.newFileSystem(newRepo, (Map)env);
        Path path = this.provider.getPath(newRepo);
        List diffs = (List)this.provider.readAttributes(path, "diff:master,develop", new LinkOption[0]).get("diff");
        diffs.forEach(elem -> this.logger.info(elem.toString()));
        Assertions.assertThat((int)diffs.size()).isEqualTo(5);
    }

    @Test
    public void testBranchesDoNotHaveDifferences() throws IOException {
        File parentFolder = JGitFileSystemImplProviderDiffTest.createTempDirectory();
        File gitSource = new File(parentFolder, "repo.git");
        final Git origin = (Git)new CreateRepository(gitSource).execute().get();
        Repository gitRepo = origin.getRepository();
        new Commit(origin, "master", "name", "name@example.com", "master-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1\ntemp1\ntemp3\nmiddle\nmoremiddle\nmoremiddle\nmoremiddle\nother\n"));
            }
        }).execute();
        new Commit(origin, "master", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1\ntemp2\nmiddle\nmoremiddle\nmoremiddle\nmoremiddle\n"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "master", "develop").execute();
        URI newRepo = URI.create("git://diff-repo");
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("origin", origin.getRepository().getDirectory().toString());
            }
        };
        this.provider.newFileSystem(newRepo, (Map)env);
        Path path = this.provider.getPath(newRepo);
        List diffs = (List)this.provider.readAttributes(path, "diff:master,develop", new LinkOption[0]).get("diff");
        diffs.forEach(elem -> this.logger.info(elem.toString()));
        Assertions.assertThat((int)diffs.size()).isEqualTo(0);
    }
}

