/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.java.nio.fs.jgit.manager.JGitFileSystemsCache;
import org.uberfire.java.nio.fs.jgit.manager.JGitFileSystemsManager;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;

public class JGitCacheInvalidationTest
extends AbstractTestInfra {
    private JGitFileSystemsCache fsCache;
    private JGitFileSystemsManager fsManager;

    @Override
    @Before
    public void createGitFsProvider() {
        Map<String, String> gitPreferences = this.getGitPreferences();
        gitPreferences.put("org.uberfire.nio.jgit.cache.evict.threshold.duration", "1");
        gitPreferences.put("org.uberfire.nio.jgit.cache.evict.threshold.time.unit", TimeUnit.MILLISECONDS.name());
        gitPreferences.put("org.uberfire.nio.jgit.cache.instances", "2");
        this.provider = new JGitFileSystemProvider(gitPreferences);
        this.fsManager = this.provider.getFsManager();
        this.fsCache = this.fsManager.getFsCache();
    }

    @Test
    public void testTwoInstancesForSameFS() throws IOException {
        String fs1Name = "dora";
        String fs2Name = "bento";
        String fs3Name = "bela";
        JGitFileSystemProxy fs1 = (JGitFileSystemProxy)this.provider.newFileSystem(URI.create("git://" + fs1Name), EMPTY_ENV);
        JGitFileSystemImpl realInstanceFs1 = (JGitFileSystemImpl)fs1.getRealJGitFileSystem();
        FileSystem fs2 = this.provider.newFileSystem(URI.create("git://" + fs2Name), EMPTY_ENV);
        FileSystem fs3 = this.provider.newFileSystem(URI.create("git://" + fs3Name), EMPTY_ENV);
        Assertions.assertThat((Object)fs1).isNotNull();
        Assertions.assertThat((Object)fs2).isNotNull();
        Assertions.assertThat((Object)fs3).isNotNull();
        Assertions.assertThat((Object)fs1).isInstanceOf(JGitFileSystemProxy.class);
        Assertions.assertThat((Object)fs2).isInstanceOf(JGitFileSystemProxy.class);
        Assertions.assertThat((Object)fs3).isInstanceOf(JGitFileSystemProxy.class);
        Assertions.assertThat((Iterable)this.fsCache.getFileSystems()).contains((Object[])new String[]{fs1.getName()});
        Assertions.assertThat((Iterable)this.fsCache.getFileSystems()).contains((Object[])new String[]{fs2.getName()});
        Assertions.assertThat((Iterable)this.fsCache.getFileSystems()).contains((Object[])new String[]{fs3.getName()});
        JGitFileSystemsCache.JGitFileSystemsCacheInfo cacheInfo = this.fsCache.getCacheInfo();
        Assertions.assertThat((Iterable)cacheInfo.memoizedFileSystemsCacheKeys()).contains((Object[])new String[]{fs2.getName()});
        Assertions.assertThat((Iterable)cacheInfo.memoizedFileSystemsCacheKeys()).contains((Object[])new String[]{fs3.getName()});
        Assertions.assertThat((Iterable)cacheInfo.memoizedFileSystemsCacheKeys()).doesNotContain((Object[])new String[]{fs1.getName()});
        JGitFileSystemProxy anotherInstanceOfFs1Proxy = (JGitFileSystemProxy)this.fsManager.get(fs1Name);
        JGitFileSystemImpl anotherInstanceOfFs1 = (JGitFileSystemImpl)anotherInstanceOfFs1Proxy.getRealJGitFileSystem();
        Assertions.assertThat((Iterable)cacheInfo.memoizedFileSystemsCacheKeys()).contains((Object[])new String[]{fs1.getName()});
        Assertions.assertThat((Iterable)cacheInfo.memoizedFileSystemsCacheKeys()).contains((Object[])new String[]{fs3.getName()});
        Assertions.assertThat((Iterable)cacheInfo.memoizedFileSystemsCacheKeys()).doesNotContain((Object[])new String[]{fs2.getName()});
        Assertions.assertThat((String)realInstanceFs1.getName()).isEqualToIgnoringCase((CharSequence)anotherInstanceOfFs1.getName());
        Assertions.assertThat((Object)realInstanceFs1.getLock()).isEqualTo((Object)anotherInstanceOfFs1.getLock());
        new Commit(realInstanceFs1.getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("realInstanceFs1File.txt", AbstractTestInfra.tempFile("dora"));
            }
        }).execute();
        InputStream stream = this.provider.newInputStream(anotherInstanceOfFs1.getPath("realInstanceFs1File.txt", new String[0]), new OpenOption[0]);
        TestCase.assertNotNull((Object)stream);
        String content = new Scanner(stream).useDelimiter("\\A").next();
        TestCase.assertEquals((String)"dora", (String)content);
        new Commit(anotherInstanceOfFs1.getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("anotherInstanceOfFs1File.txt", AbstractTestInfra.tempFile("bento"));
            }
        }).execute();
        stream = this.provider.newInputStream(realInstanceFs1.getPath("anotherInstanceOfFs1File.txt", new String[0]), new OpenOption[0]);
        TestCase.assertNotNull((Object)stream);
        content = new Scanner(stream).useDelimiter("\\A").next();
        TestCase.assertEquals((String)"bento", (String)content);
        realInstanceFs1.lock();
        Assertions.assertThat((boolean)realInstanceFs1.hasBeenInUse()).isTrue();
        Assertions.assertThat((boolean)anotherInstanceOfFs1.hasBeenInUse()).isTrue();
    }
}

