/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.UsernamePasswordCredentialsProvider;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.security.FileSystemUser;

public class JGitFileSystemImplProviderSSHTest
extends AbstractTestInfra {
    private int gitSSHPort;

    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.ssh.enabled", "true");
        this.gitSSHPort = JGitFileSystemImplProviderSSHTest.findFreePort();
        gitPrefs.put("org.uberfire.nio.git.ssh.port", String.valueOf(this.gitSSHPort));
        gitPrefs.put("org.uberfire.nio.git.ssh.idle.timeout", "10001");
        return gitPrefs;
    }

    @Test
    public void testSSHPostReceiveHook() throws IOException {
        Assume.assumeFalse((String)"UF-511", (boolean)System.getProperty("java.vendor").equals("IBM Corporation"));
        this.provider.setAuthenticator((username, password) -> new FileSystemUser(){

            public String getName() {
                return "admin";
            }
        });
        this.provider.setAuthorizer((fs, fileSystemUser) -> true);
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("admin", ""));
        Assert.assertEquals((Object)"10001", this.provider.getGitSSHService().getProperties().get("idle-timeout"));
        URI originRepo = URI.create("git://repo");
        JGitFileSystem origin = (JGitFileSystem)this.provider.newFileSystem(originRepo, Collections.emptyMap());
        new Commit(origin.getGit(), "master", "user1", "user1@example.com", "commitx", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file-name.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        JGitFileSystem clone = (JGitFileSystem)this.provider.newFileSystem(URI.create("git://repo-clone"), (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
                this.put("origin", "ssh://admin@localhost:" + JGitFileSystemImplProviderSSHTest.this.gitSSHPort + "/repo");
            }
        });
        Assert.assertNotNull((Object)clone);
        this.provider.getFileSystem(URI.create("git://repo-clone?push=ssh://admin@localhost:" + this.gitSSHPort + "/repo"));
    }
}

