/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;

public class JGitGetCommitTest
extends AbstractTestInfra {
    private Git git;
    private static final String MASTER_BRANCH = "master";

    @Before
    public void setup() throws IOException {
        File parentFolder = JGitGetCommitTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.git = (Git)new CreateRepository(gitSource).execute().get();
    }

    @Test
    public void successTest() throws IOException {
        JGitGetCommitTest.commit(this.git, MASTER_BRANCH, "Adding file", JGitGetCommitTest.content("file.txt", "file content"));
        RevCommit lastCommit = this.git.getLastCommit(MASTER_BRANCH);
        RevCommit commit = this.git.getCommit(lastCommit.getName());
        Assertions.assertThat((String)commit.getName()).isEqualTo((Object)lastCommit.getName());
    }

    @Test
    public void notFoundTest() {
        RevCommit commit = this.git.getCommit("non-existent-commit-id");
        Assertions.assertThat((Comparable)commit).isNull();
    }
}

