/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;

public class JGitGetCommonAncestorCommitTest
extends AbstractTestInfra {
    private Git git;
    private static final String MASTER_BRANCH = "master";
    private static final String DEVELOP_BRANCH = "develop";

    @Before
    public void setup() throws IOException {
        File parentFolder = JGitGetCommonAncestorCommitTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.git = (Git)new CreateRepository(gitSource).execute().get();
    }

    @Test
    public void successTest() throws IOException {
        JGitGetCommonAncestorCommitTest.commit(this.git, MASTER_BRANCH, "Adding file", JGitGetCommonAncestorCommitTest.content("file.txt", "file content"));
        RevCommit expectedCommonAncestorCommit = this.git.getLastCommit(MASTER_BRANCH);
        new CreateBranch((GitImpl)this.git, MASTER_BRANCH, DEVELOP_BRANCH).execute();
        JGitGetCommonAncestorCommitTest.commit(this.git, MASTER_BRANCH, "Updating file", JGitGetCommonAncestorCommitTest.content("file.txt", "file content 1"));
        JGitGetCommonAncestorCommitTest.commit(this.git, MASTER_BRANCH, "Updating file", JGitGetCommonAncestorCommitTest.content("file.txt", "file content 2"));
        JGitGetCommonAncestorCommitTest.commit(this.git, DEVELOP_BRANCH, "Updating file", JGitGetCommonAncestorCommitTest.content("file.txt", "file content 3"));
        JGitGetCommonAncestorCommitTest.commit(this.git, DEVELOP_BRANCH, "Updating file", JGitGetCommonAncestorCommitTest.content("file.txt", "file content 4"));
        RevCommit actualCommonAncestorCommit = this.git.getCommonAncestorCommit(MASTER_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((String)actualCommonAncestorCommit.getName()).isEqualTo((Object)expectedCommonAncestorCommit.getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidBranchTest() {
        this.git.getCommonAncestorCommit(MASTER_BRANCH, "invalid-branch");
    }
}

