/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.EncodingUtil;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;

public class JGitPathTest {
    private final FileSystemProvider fsp = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
    private final JGitFileSystem fs = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)this.fsp);
        Mockito.when((Object)this.fsp.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)this.fsp.getScheme()).thenReturn((Object)"git");
    }

    @Test
    public void testSimpleBranchedGit() {
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"", (String)"master@my-host", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-host/");
        AssertionsForClassTypes.assertThat((Object)path.getRoot()).isEqualTo((Object)path);
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(0);
        AssertionsForClassTypes.assertThat((Object)path.getRoot()).isEqualTo((Object)path);
    }

    @Test
    public void testSimpleBranchedGitRoot() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/", (String)"master@my-host", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-host/");
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(0);
    }

    @Test
    public void testSimpleBranchedGitRelative() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"home", (String)"master@my-host", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isFalse();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("home");
        AssertionsForClassTypes.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-host/:home");
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(1);
    }

    @Test
    public void testSimpleBranchedGitRoot2() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to/some/place.txt", (String)"master@my-host", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/path/to/some/place.txt");
        AssertionsForClassTypes.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-host/path/to/some/place.txt");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(4);
        AssertionsForClassTypes.assertThat((String)path.getName(0).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
    }

    @Test
    public void testSimpleBranchedGitRoot2Spaced() throws IllegalStateException {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)EncodingUtil.decode((String)"/path/to/some/some%20place.txt"), (String)"master@my-host", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/path/to/some/some place.txt");
        AssertionsForClassTypes.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-host/path/to/some/some%20place.txt");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(4);
        AssertionsForClassTypes.assertThat((String)path.getName(0).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
    }

    @Test
    public void testSimpleImplicitBranchGit() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to/some/place.txt", (String)"my-host", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/path/to/some/place.txt");
        AssertionsForClassTypes.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-host/path/to/some/place.txt");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(4);
        AssertionsForClassTypes.assertThat((String)path.getName(0).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
    }

    @Test
    public void testSimpleImplicitBranchGitRoot() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/", (String)"my-host", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((String)path.toUri().toString()).isEqualTo("git://master@my-host/");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(0);
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
        Assertions.assertThatThrownBy(() -> JGitPathTest.lambda$testSimpleImplicitBranchGitRoot$0((Path)path)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testRelativize() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        JGitPathImpl path = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to/some/place", (String)"master@my-host", (boolean)false);
        Path relative = path.relativize((Path)other);
        AssertionsForClassTypes.assertThat((Object)relative).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative.toString()).isEqualTo("some/place");
        JGitPathImpl path2 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to/some/place", (String)"master@my-host", (boolean)false);
        JGitPathImpl other2 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        Path relative2 = path2.relativize((Path)other2);
        AssertionsForClassTypes.assertThat((Object)relative2).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative2.toString()).isEqualTo("../..");
        JGitPathImpl path3 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other3 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        Path relative3 = path3.relativize((Path)other3);
        AssertionsForClassTypes.assertThat((Object)relative3).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative3.toString()).isEqualTo("");
        JGitPathImpl path4 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other4 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to/some/place", (String)"master@my-host", (boolean)false);
        Path relative4 = path4.relativize((Path)other4);
        AssertionsForClassTypes.assertThat((Object)relative4).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative4.toString()).isEqualTo("some/place");
        JGitPathImpl path5 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other5 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"some/place", (String)"master@my-host", (boolean)false);
        Path relative5 = path5.relativize((Path)other5);
        AssertionsForClassTypes.assertThat((Object)relative5).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative5.toString()).isEqualTo("../../some/place");
        JGitPathImpl path6 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"some/place", (String)"master@my-host", (boolean)false);
        JGitPathImpl other6 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        Path relative6 = path6.relativize((Path)other6);
        AssertionsForClassTypes.assertThat((Object)relative6).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative6.toString()).isEqualTo("../../path/to");
        JGitPathImpl path7 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to/some/thing/here", (String)"master@my-host", (boolean)false);
        JGitPathImpl other7 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"some/place", (String)"master@my-host", (boolean)false);
        Path relative7 = path7.relativize((Path)other7);
        AssertionsForClassTypes.assertThat((Object)relative7).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative7.toString()).isEqualTo("../../../../../some/place");
        JGitPathImpl path8 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"some/place", (String)"master@my-host", (boolean)false);
        JGitPathImpl other8 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to/some/thing/here", (String)"master@my-host", (boolean)false);
        Path relative8 = path8.relativize((Path)other8);
        AssertionsForClassTypes.assertThat((Object)relative8).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative8.toString()).isEqualTo("../../path/to/some/thing/here");
        JGitPathImpl path9 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other9 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"/path/to", (String)"master@my-host", (boolean)false);
        Path relative9 = path9.relativize((Path)other9);
        AssertionsForClassTypes.assertThat((Object)relative9).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative9.toString()).isEqualTo("");
        JGitPathImpl path10 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        JGitPathImpl other10 = JGitPathImpl.create((JGitFileSystem)this.fs, (String)"path/to", (String)"master@my-host", (boolean)false);
        Path relative10 = path10.relativize((Path)other10);
        AssertionsForClassTypes.assertThat((Object)relative10).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative10.toString()).isEqualTo("");
    }

    private static /* synthetic */ void lambda$testSimpleImplicitBranchGitRoot$0(Path path) throws Throwable {
        path.getName(0);
    }
}

