/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;

abstract class BaseCreateCommitTree<T extends CommitContent> {
    final T commitContent;
    final Git git;
    final ObjectId headId;
    final ObjectInserter odi;

    BaseCreateCommitTree(Git git, ObjectId headId, ObjectInserter inserter, T commitContent) {
        this.git = git;
        this.headId = headId;
        this.odi = inserter;
        this.commitContent = commitContent;
    }

    Optional<ObjectId> buildTree(DirCacheEditor editor) {
        try {
            return Optional.ofNullable(editor.getDirCache().writeTree(this.odi));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void iterateOverTreeWalk(Git git, ObjectId headId, BiConsumer<String, CanonicalTreeParser> consumer) {
        if (headId != null) {
            try (TreeWalk treeWalk = new TreeWalk(git.getRepository());){
                int hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    String walkPath = treeWalk.getPathString();
                    CanonicalTreeParser hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                    consumer.accept(walkPath, hTree);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    void addToTemporaryInCoreIndex(DirCacheEditor editor, DirCacheEntry dcEntry, final ObjectId objectId, final FileMode fileMode) {
        editor.add(new DirCacheEditor.PathEdit(dcEntry){

            public void apply(DirCacheEntry ent) {
                ent.setObjectId((AnyObjectId)objectId);
                ent.setFileMode(fileMode);
            }
        });
    }
}

