/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.JGitSSHConfigSessionFactory;

public class JGitSSHConfigSessionFactoryTest {
    @Test
    public void testNoProxy() {
        JGitFileSystemProviderConfiguration config = new JGitFileSystemProviderConfiguration(){};
        config.load(new ConfigProperties(Collections.emptyMap()));
        JGitSSHConfigSessionFactory instance = new JGitSSHConfigSessionFactory(config){

            ProxyHTTP buildProxy(JGitFileSystemProviderConfiguration config) {
                Assertions.fail((String)"no proxy should be set");
                return null;
            }
        };
        instance.configure((OpenSshConfig.Host)Mockito.mock(OpenSshConfig.Host.class), (Session)Mockito.mock(Session.class));
    }

    @Test
    public void testHttpProxy() {
        JGitFileSystemProviderConfiguration config = new JGitFileSystemProviderConfiguration(){};
        config.load(new ConfigProperties((Map)new HashMap<String, String>(){
            {
                this.put("org.uberfire.nio.git.proxy.ssh.over.http", "true");
                this.put("http.proxyHost", "somehost");
                this.put("http.proxyPort", "10");
            }
        }));
        JGitSSHConfigSessionFactory instance = new JGitSSHConfigSessionFactory(config){

            ProxyHTTP buildProxy(JGitFileSystemProviderConfiguration config) {
                ProxyHTTP proxy = super.buildProxy(config);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("proxy_host", (Object)"somehost");
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("proxy_port", (Object)10);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("user", null);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("passwd", null);
                return proxy;
            }
        };
        instance.configure((OpenSshConfig.Host)Mockito.mock(OpenSshConfig.Host.class), (Session)Mockito.mock(Session.class));
    }

    @Test
    public void testHttpProxyWithAuthentication() {
        JGitFileSystemProviderConfiguration config = new JGitFileSystemProviderConfiguration(){};
        config.load(new ConfigProperties((Map)new HashMap<String, String>(){
            {
                this.put("org.uberfire.nio.git.proxy.ssh.over.http", "true");
                this.put("http.proxyHost", "somehost");
                this.put("http.proxyPort", "10");
                this.put("http.proxyUser", "user");
                this.put("http.proxyPassword", "passwd");
            }
        }));
        JGitSSHConfigSessionFactory instance = new JGitSSHConfigSessionFactory(config){

            ProxyHTTP buildProxy(JGitFileSystemProviderConfiguration config) {
                ProxyHTTP proxy = super.buildProxy(config);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("proxy_host", (Object)"somehost");
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("proxy_port", (Object)10);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("user", (Object)"user");
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("passwd", (Object)"passwd");
                return proxy;
            }
        };
        instance.configure((OpenSshConfig.Host)Mockito.mock(OpenSshConfig.Host.class), (Session)Mockito.mock(Session.class));
    }

    @Test
    public void testHttpsProxy() {
        JGitFileSystemProviderConfiguration config = new JGitFileSystemProviderConfiguration(){};
        config.load(new ConfigProperties((Map)new HashMap<String, String>(){
            {
                this.put("org.uberfire.nio.git.proxy.ssh.over.https", "true");
                this.put("https.proxyHost", "somehost");
                this.put("https.proxyPort", "10");
            }
        }));
        JGitSSHConfigSessionFactory instance = new JGitSSHConfigSessionFactory(config){

            ProxyHTTP buildProxy(JGitFileSystemProviderConfiguration config) {
                ProxyHTTP proxy = super.buildProxy(config);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("proxy_host", (Object)"somehost");
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("proxy_port", (Object)10);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("user", null);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("passwd", null);
                return proxy;
            }
        };
        instance.configure((OpenSshConfig.Host)Mockito.mock(OpenSshConfig.Host.class), (Session)Mockito.mock(Session.class));
    }

    @Test
    public void testHttpsProxyWithAuthentication() {
        JGitFileSystemProviderConfiguration config = new JGitFileSystemProviderConfiguration(){};
        config.load(new ConfigProperties((Map)new HashMap<String, String>(){
            {
                this.put("org.uberfire.nio.git.proxy.ssh.over.https", "true");
                this.put("https.proxyHost", "somehost");
                this.put("https.proxyPort", "10");
                this.put("https.proxyUser", "user");
                this.put("https.proxyPassword", "passwd");
            }
        }));
        JGitSSHConfigSessionFactory instance = new JGitSSHConfigSessionFactory(config){

            ProxyHTTP buildProxy(JGitFileSystemProviderConfiguration config) {
                ProxyHTTP proxy = super.buildProxy(config);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("proxy_host", (Object)"somehost");
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("proxy_port", (Object)10);
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("user", (Object)"user");
                Assertions.assertThat((Object)proxy).hasFieldOrPropertyWithValue("passwd", (Object)"passwd");
                return proxy;
            }
        };
        instance.configure((OpenSshConfig.Host)Mockito.mock(OpenSshConfig.Host.class), (Session)Mockito.mock(Session.class));
    }
}

