/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.git;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.concurrent.ExecutorServiceProducer;
import org.uberfire.java.nio.fs.jgit.daemon.git.Daemon;

public class DaemonTest {
    private final ExecutorService executorService = new ExecutorServiceProducer().produceUnmanagedExecutorService();

    @Test
    public void testShutdownByStop() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        Daemon d = new Daemon(null, (Executor)executor, this.executorService);
        d.start();
        Assert.assertTrue((boolean)d.isRunning());
        d.stop();
        Assert.assertFalse((boolean)d.isRunning());
    }

    @Test
    public void testShutdownByThreadPoolTermination() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        Daemon d = new Daemon(null, (Executor)executor, this.executorService);
        d.start();
        Assert.assertTrue((boolean)d.isRunning());
        executor.shutdownNow();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)d.isRunning());
    }
}

