/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.net.URI;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.manager.JGitFileSystemsCache;

public class JGitUpdateFSCacheWithHostnameTest
extends AbstractTestInfra {
    @Override
    public Map<String, String> getGitPreferences() {
        Map<String, String> gitPrefs = super.getGitPreferences();
        gitPrefs.put("org.uberfire.nio.git.http.enabled", "true");
        return gitPrefs;
    }

    @Test
    public void testFSCacheUpdateWithHostName() {
        URI newRepo = URI.create("git://repo-name");
        this.provider.addHostName("ssh", "localhost:8080/git");
        this.provider.newFileSystem(newRepo, EMPTY_ENV);
        JGitFileSystemsCache fileSystemsCache = this.provider.getFsManager().getFsCache();
        JGitFileSystem fileSystem = fileSystemsCache.get("repo-name");
        Assertions.assertThat((Object)fileSystem).isNotNull();
        Assert.assertTrue((boolean)JGitUpdateFSCacheWithHostnameTest.checkProtocolPresent(fileSystem.toString(), "ssh"));
        Assert.assertFalse((boolean)JGitUpdateFSCacheWithHostnameTest.checkProtocolPresent(fileSystem.toString(), "http"));
        this.provider.addHostName("http", "localhost:8080/git");
        JGitFileSystem fileSystem1 = fileSystemsCache.get("repo-name");
        Assertions.assertThat((Object)fileSystem1).isNotNull();
        Assert.assertFalse((boolean)JGitUpdateFSCacheWithHostnameTest.checkProtocolPresent(fileSystem1.toString(), "http"));
        Assertions.assertThat((int)fileSystemsCache.getFileSystems().size()).isOne();
        this.provider.updateCacheWithHostNames();
        JGitFileSystem fileSystem2 = fileSystemsCache.get("repo-name");
        Assertions.assertThat((Object)fileSystem2).isNotNull();
        Assert.assertTrue((boolean)JGitUpdateFSCacheWithHostnameTest.checkProtocolPresent(fileSystem2.toString(), "http"));
        Assertions.assertThat((int)fileSystemsCache.getFileSystems().size()).isOne();
    }
}

