/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.ListCommits;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.CommitHistory;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.MoveCommitContent;

public class JGitHistoryTest
extends AbstractTestInfra {
    private Git git;

    @Before
    public void setup() throws IOException {
        File tmpDir = JGitHistoryTest.createTempDirectory();
        File repoDir = new File(tmpDir, "test-repo.git");
        this.git = (Git)new CreateRepository(repoDir).execute().orElseThrow(() -> new IllegalStateException("Unable to create git repo for tests."));
        JGitHistoryTest.commit(this.git, "master", "create files", JGitHistoryTest.content("non-moving.txt", JGitHistoryTest.multiline("a", "b", "c")), JGitHistoryTest.content("moving.txt", JGitHistoryTest.multiline("1", "2", "3")));
        this.moveCommit(this.singleMove("moving.txt", "moving1.txt"), "rename moving file");
        JGitHistoryTest.commit(this.git, "master", "change content, no moves", JGitHistoryTest.content("non-moving.txt", JGitHistoryTest.multiline("a", "b", "d")), JGitHistoryTest.content("moving1.txt", JGitHistoryTest.multiline("1", "2", "4")));
        this.moveCommit(this.singleMove("moving1.txt", "dir/moving2.txt"), "move moving file to new dir");
        JGitHistoryTest.commit(this.git, "master", "simulate checkout old version", JGitHistoryTest.content("moving1.txt", JGitHistoryTest.multiline("1", "2", "4")));
    }

    private Map<String, String> singleMove(String from, String to) {
        HashMap<String, String> moves = new HashMap<String, String>();
        moves.put(from, to);
        return moves;
    }

    private void moveCommit(Map<String, String> moves, String message) {
        this.git.commit("master", new CommitInfo(null, "name", "name@example.com", message, null, null), false, null, (CommitContent)new MoveCommitContent(moves));
    }

    @Test
    public void listCommitsForUnmovedFile() throws Exception {
        CommitHistory history = new ListCommits(this.git, this.git.getRef("master"), "non-moving.txt").execute();
        Assert.assertEquals((Object)"non-moving.txt", (Object)history.getTrackedFilePath());
        Assert.assertEquals((long)2L, (long)history.getCommits().size());
        Assert.assertEquals((Object)"/non-moving.txt", (Object)history.trackedFileNameChangeFor((AnyObjectId)((RevCommit)history.getCommits().get(0)).getId()));
        Assert.assertEquals((Object)"/non-moving.txt", (Object)history.trackedFileNameChangeFor((AnyObjectId)((RevCommit)history.getCommits().get(1)).getId()));
    }

    @Test
    public void listCommitsForMovedFile() throws Exception {
        CommitHistory history = new ListCommits(this.git, this.git.getRef("master"), "dir/moving2.txt").execute();
        Assert.assertEquals((Object)"dir/moving2.txt", (Object)history.getTrackedFilePath());
        Assert.assertEquals((long)4L, (long)history.getCommits().size());
        RevCommit commit0 = (RevCommit)history.getCommits().get(0);
        String oPath0 = history.trackedFileNameChangeFor((AnyObjectId)commit0.getId());
        Assert.assertEquals((Object)"move moving file to new dir", (Object)commit0.getFullMessage());
        Assert.assertEquals((Object)"/dir/moving2.txt", (Object)oPath0);
        RevCommit commit1 = (RevCommit)history.getCommits().get(1);
        String oPath1 = history.trackedFileNameChangeFor((AnyObjectId)commit1.getId());
        Assert.assertEquals((Object)"change content, no moves", (Object)commit1.getFullMessage());
        Assert.assertEquals((Object)"/moving1.txt", (Object)oPath1);
        RevCommit commit2 = (RevCommit)history.getCommits().get(2);
        String oPath2 = history.trackedFileNameChangeFor((AnyObjectId)commit2.getId());
        Assert.assertEquals((Object)"rename moving file", (Object)commit2.getFullMessage());
        Assert.assertEquals((Object)"/moving1.txt", (Object)oPath2);
        RevCommit commit3 = (RevCommit)history.getCommits().get(3);
        String oPath3 = history.trackedFileNameChangeFor((AnyObjectId)commit3.getId());
        Assert.assertEquals((Object)"create files", (Object)commit3.getFullMessage());
        Assert.assertEquals((Object)"/moving.txt", (Object)oPath3);
    }

    @Test
    public void listCommitsForRestoredFile() throws Exception {
        CommitHistory history = new ListCommits(this.git, this.git.getRef("master"), "moving1.txt").execute();
        Assert.assertEquals((Object)"moving1.txt", (Object)history.getTrackedFilePath());
        Assert.assertEquals((long)4L, (long)history.getCommits().size());
        RevCommit commit0 = (RevCommit)history.getCommits().get(0);
        String oPath0 = history.trackedFileNameChangeFor((AnyObjectId)commit0.getId());
        Assert.assertEquals((Object)"simulate checkout old version", (Object)commit0.getFullMessage());
        Assert.assertEquals((Object)"/moving1.txt", (Object)oPath0);
        RevCommit commit1 = (RevCommit)history.getCommits().get(1);
        String oPath1 = history.trackedFileNameChangeFor((AnyObjectId)commit1.getId());
        Assert.assertEquals((Object)"change content, no moves", (Object)commit1.getFullMessage());
        Assert.assertEquals((Object)"/moving1.txt", (Object)oPath1);
        RevCommit commit2 = (RevCommit)history.getCommits().get(2);
        String oPath2 = history.trackedFileNameChangeFor((AnyObjectId)commit2.getId());
        Assert.assertEquals((Object)"rename moving file", (Object)commit2.getFullMessage());
        Assert.assertEquals((Object)"/moving1.txt", (Object)oPath2);
        RevCommit commit3 = (RevCommit)history.getCommits().get(3);
        String oPath3 = history.trackedFileNameChangeFor((AnyObjectId)commit3.getId());
        Assert.assertEquals((Object)"create files", (Object)commit3.getFullMessage());
        Assert.assertEquals((Object)"/moving.txt", (Object)oPath3);
    }

    @Test
    public void listCommitsOnDirectory() throws Exception {
        CommitHistory history = new ListCommits(this.git, this.git.getRef("master"), "dir").execute();
        Assert.assertEquals((Object)"dir", (Object)history.getTrackedFilePath());
        Assert.assertEquals((long)1L, (long)history.getCommits().size());
        RevCommit commit0 = (RevCommit)history.getCommits().get(0);
        String oPath0 = history.trackedFileNameChangeFor((AnyObjectId)commit0.getId());
        Assert.assertEquals((Object)"move moving file to new dir", (Object)commit0.getFullMessage());
        Assert.assertEquals((Object)"/dir", (Object)oPath0);
    }

    @Test
    public void listCommitsOnRootDirectoryViaAbsolute() throws Exception {
        CommitHistory history = new ListCommits(this.git, this.git.getRef("master"), "/").execute();
        Assert.assertEquals((Object)"/", (Object)history.getTrackedFilePath());
        Assert.assertEquals((long)5L, (long)history.getCommits().size());
        RevCommit commit0 = (RevCommit)history.getCommits().get(0);
        String oPath0 = history.trackedFileNameChangeFor((AnyObjectId)commit0.getId());
        Assert.assertEquals((Object)"simulate checkout old version", (Object)commit0.getFullMessage());
        Assert.assertEquals((Object)"/", (Object)oPath0);
    }

    @Test
    public void listCommitsOnRootDirectoryViaNull() throws Exception {
        CommitHistory history = new ListCommits(this.git, this.git.getRef("master"), null).execute();
        Assert.assertEquals((Object)"/", (Object)history.getTrackedFilePath());
        Assert.assertEquals((long)5L, (long)history.getCommits().size());
        RevCommit commit0 = (RevCommit)history.getCommits().get(0);
        String oPath0 = history.trackedFileNameChangeFor((AnyObjectId)commit0.getId());
        Assert.assertEquals((Object)"simulate checkout old version", (Object)commit0.getFullMessage());
        Assert.assertEquals((Object)"/", (Object)oPath0);
    }

    @Test
    public void listCommitsOnRootDirectoryViaEmpty() throws Exception {
        CommitHistory history = new ListCommits(this.git, this.git.getRef("master"), "").execute();
        Assert.assertEquals((Object)"/", (Object)history.getTrackedFilePath());
        Assert.assertEquals((long)5L, (long)history.getCommits().size());
        RevCommit commit0 = (RevCommit)history.getCommits().get(0);
        String oPath0 = history.trackedFileNameChangeFor((AnyObjectId)commit0.getId());
        Assert.assertEquals((Object)"simulate checkout old version", (Object)commit0.getFullMessage());
        Assert.assertEquals((Object)"/", (Object)oPath0);
    }
}

