/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.net.URI;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;

public class JGitFileSystemImplProviderAsDefaultTest
extends AbstractTestInfra {
    @Before
    public void forceProviderToDefault() {
        this.provider.forceAsDefault();
    }

    @Test
    public void testGetPath() {
        URI newRepo = URI.create("default://default-new-get-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("default://master@default-new-get-repo-name/home"));
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/home");
        AssertionsForClassTypes.assertThat((String)path.toUri().getScheme()).isEqualTo("default");
        Path pathRelative = this.provider.getPath(URI.create("default://master@default-new-get-repo-name/:home"));
        AssertionsForClassTypes.assertThat((Object)pathRelative).isNotNull();
        AssertionsForClassTypes.assertThat((String)pathRelative.toUri().toString()).isEqualTo("default://master@default-new-get-repo-name/:home");
        AssertionsForClassTypes.assertThat((String)pathRelative.getRoot().toString()).isEqualTo("");
        AssertionsForClassTypes.assertThat((String)pathRelative.toString()).isEqualTo("home");
        fs.close();
    }

    @Test
    public void testGetComplexPath() {
        URI newRepo = URI.create("default://default-new-complex-get-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("default://origin/master@default-new-complex-get-repo-name/home"));
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/home");
        AssertionsForClassTypes.assertThat((String)path.toUri().getScheme()).isEqualTo("default");
        Path pathRelative = this.provider.getPath(URI.create("default://origin/master@default-new-complex-get-repo-name/:home"));
        AssertionsForClassTypes.assertThat((Object)pathRelative).isNotNull();
        AssertionsForClassTypes.assertThat((String)pathRelative.getRoot().toString()).isEqualTo("");
        AssertionsForClassTypes.assertThat((String)pathRelative.getRoot().toUri().toString()).isEqualTo("default://origin/master@default-new-complex-get-repo-name");
        AssertionsForClassTypes.assertThat((String)pathRelative.toString()).isEqualTo("home");
        fs.close();
    }

    @Test
    public void testGetComplexPathFileSystemNameIncludedInPath() {
        URI newRepo = URI.create("default://default-new-complex-get-repo-name");
        FileSystem fs = this.provider.newFileSystem(newRepo, EMPTY_ENV);
        Path path = this.provider.getPath(URI.create("default://origin/master@default-new-complex-get-repo-name/home/default-new-complex-get-repo-name/somefolder"));
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/home/default-new-complex-get-repo-name/somefolder");
        AssertionsForClassTypes.assertThat((String)path.toUri().getScheme()).isEqualTo("default");
        fs.close();
    }
}

