/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitAddRemoteTest
extends AbstractTestInfra {
    private Git git;

    @Before
    public void setup() throws IOException {
        File parentFolder = JGitAddRemoteTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.git = (Git)Mockito.spy(new CreateRepository(gitSource).execute().get());
        JGitAddRemoteTest.commit(this.git, "main", "Initial commit", JGitAddRemoteTest.content("file0", JGitAddRemoteTest.multiline("file0", "content")));
    }

    @Test
    public void addRemoteTest() {
        String url = "myRemoteUrl";
        this.git.addRemote("origin", "myRemoteUrl");
        String expectedUrl = this.git.getRepository().getConfig().getString("remote", "origin", "url");
        Assertions.assertThat((String)"myRemoteUrl").isSameAs((Object)expectedUrl);
    }

    @Test(expected=GitException.class)
    public void addRemoteFailTest() {
        ((Git)Mockito.doThrow(RuntimeException.class).when((Object)this.git)).getRepository();
        this.git.addRemote("origin", "myRemoteUrl");
    }
}

