/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;

public class Fetch {
    private final GitImpl git;
    private final CredentialsProvider credentialsProvider;
    private final Pair<String, String> remote;
    private final Collection<RefSpec> refSpecs;

    public Fetch(GitImpl git, CredentialsProvider credentialsProvider, Collection<RefSpec> refSpecs) {
        this.git = git;
        this.credentialsProvider = credentialsProvider;
        this.refSpecs = refSpecs;
        this.remote = Pair.newPair((Object)"origin", null);
    }

    public Fetch(GitImpl git, CredentialsProvider credentialsProvider, Pair<String, String> remote, Collection<RefSpec> refSpecs) {
        this.git = git;
        this.credentialsProvider = credentialsProvider;
        this.remote = remote;
        this.refSpecs = refSpecs;
    }

    public void execute() throws InvalidRemoteException {
        try {
            List<RefSpec> specs = this.git.updateRemoteConfig(this.remote, this.refSpecs);
            ((FetchCommand)this.git._fetch().setCredentialsProvider(this.credentialsProvider)).setRemote((String)this.remote.getK1()).setRefSpecs(specs).call();
        }
        catch (InvalidRemoteException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

