/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.MessageCommitInfo;

public class JGitRevertMergeTest
extends AbstractTestInfra {
    private Git git;
    private static final String MAIN_BRANCH = "main";
    private static final String DEVELOP_BRANCH = "develop";
    private static final List<String> TXT_FILES = Stream.of("file0", "file1", "file2", "file3", "file4").collect(Collectors.toList());
    private static final String[] COMMON_TXT_LINES = new String[]{"Line1", "Line2", "Line3", "Line4"};
    private String commonAncestorCommitId;

    @Before
    public void setup() throws IOException {
        File parentFolder = JGitRevertMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.git = (Git)new CreateRepository(gitSource).execute().get();
        JGitRevertMergeTest.commit(this.git, MAIN_BRANCH, "Adding files into main", JGitRevertMergeTest.content(TXT_FILES.get(0), JGitRevertMergeTest.multiline(TXT_FILES.get(0), COMMON_TXT_LINES)), JGitRevertMergeTest.content(TXT_FILES.get(1), JGitRevertMergeTest.multiline(TXT_FILES.get(1), COMMON_TXT_LINES)), JGitRevertMergeTest.content(TXT_FILES.get(2), JGitRevertMergeTest.multiline(TXT_FILES.get(2), COMMON_TXT_LINES)));
        new CreateBranch((GitImpl)this.git, MAIN_BRANCH, DEVELOP_BRANCH).execute();
        JGitRevertMergeTest.commit(this.git, DEVELOP_BRANCH, "Adding files", JGitRevertMergeTest.content(TXT_FILES.get(3), JGitRevertMergeTest.multiline(TXT_FILES.get(3), COMMON_TXT_LINES)), JGitRevertMergeTest.content(TXT_FILES.get(4), JGitRevertMergeTest.multiline(TXT_FILES.get(4), COMMON_TXT_LINES)));
        this.commonAncestorCommitId = this.git.getCommonAncestorCommit(DEVELOP_BRANCH, MAIN_BRANCH).getName();
    }

    @Test(expected=GitException.class)
    public void testInvalidSourceBranch() {
        String mergeCommitId = this.doMerge();
        this.git.revertMerge("invalid-branch", MAIN_BRANCH, this.commonAncestorCommitId, mergeCommitId);
    }

    @Test(expected=GitException.class)
    public void testInvalidTargetBranch() {
        String mergeCommitId = this.doMerge();
        this.git.revertMerge(DEVELOP_BRANCH, "invalid-branch", this.commonAncestorCommitId, mergeCommitId);
    }

    @Test
    public void testRevertFailedMergeIsNotLastTargetCommit() throws IOException {
        String mergeCommitId = this.doMerge();
        JGitRevertMergeTest.commit(this.git, MAIN_BRANCH, "Updating file", JGitRevertMergeTest.content(TXT_FILES.get(0), "new content"));
        boolean result = this.git.revertMerge(DEVELOP_BRANCH, MAIN_BRANCH, this.commonAncestorCommitId, mergeCommitId);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void testRevertFailedMergeParentTargetIsNotCommonAncestor() throws IOException {
        JGitRevertMergeTest.commit(this.git, MAIN_BRANCH, "Updating file", JGitRevertMergeTest.content(TXT_FILES.get(0), "new content"));
        String mergeCommitId = this.doMerge();
        boolean result = this.git.revertMerge(DEVELOP_BRANCH, MAIN_BRANCH, this.commonAncestorCommitId, mergeCommitId);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void testRevertFailedMergeSourceParentIsNotLastSourceCommit() throws IOException {
        String mergeCommitId = this.doMerge();
        JGitRevertMergeTest.commit(this.git, DEVELOP_BRANCH, "Updating file", JGitRevertMergeTest.content(TXT_FILES.get(0), "new content"));
        boolean result = this.git.revertMerge(DEVELOP_BRANCH, MAIN_BRANCH, this.commonAncestorCommitId, mergeCommitId);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void testRevertSucceeded() {
        String mergeCommitId = this.doMerge();
        boolean result = this.git.revertMerge(DEVELOP_BRANCH, MAIN_BRANCH, this.commonAncestorCommitId, mergeCommitId);
        Assertions.assertThat((boolean)result).isTrue();
    }

    private String doMerge() {
        this.git.merge(DEVELOP_BRANCH, MAIN_BRANCH, true, false, (CommitInfo)MessageCommitInfo.createMergeMessage((String)DEVELOP_BRANCH));
        return this.git.getLastCommit(MAIN_BRANCH).getName();
    }
}

