/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.net.URI;
import java.net.URISyntaxException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class URITest {
    @Test
    public void testURI() throws URISyntaxException {
        URI uri = new URI("git://branch@repo-name/path/to/file.txt");
        Assertions.assertThat((String)uri.getScheme()).isEqualTo("git");
        Assertions.assertThat((String)uri.getAuthority()).isEqualTo("branch@repo-name");
        Assertions.assertThat((String)uri.getPath()).isEqualTo("/path/to/file.txt");
        Assertions.assertThat((String)uri.getQuery()).isNull();
        URI uri2 = new URI("git://repo-name");
        Assertions.assertThat((URI)uri2).isNotNull();
        Assertions.assertThat((String)uri2.getAuthority()).isEqualTo("repo-name");
        URI uri3 = URI.create("git://branch@repo-name/path/to/file.txt");
        Assertions.assertThat((URI)uri3).isNotNull();
        Assertions.assertThat((String)uri3.getScheme()).isEqualTo("git");
        Assertions.assertThat((String)uri3.getAuthority()).isEqualTo("branch@repo-name");
        Assertions.assertThat((String)uri3.getPath()).isEqualTo("/path/to/file.txt");
        Assertions.assertThat((String)uri3.getQuery()).isNull();
        URI uri4 = URI.create("git://main@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((URI)uri4).isNotNull();
        Assertions.assertThat((String)uri4.getScheme()).isEqualTo("git");
        Assertions.assertThat((String)uri4.getAuthority()).isEqualTo("main@my-repo");
        Assertions.assertThat((String)uri4.getPath()).isEqualTo("/:path/to/some/place.txt");
        Assertions.assertThat((String)uri4.getQuery()).isNull();
        URI uri5 = URI.create("git://origin/main@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((URI)uri5).isNotNull();
        Assertions.assertThat((String)uri5.getScheme()).isEqualTo("git");
        Assertions.assertThat((String)uri5.getAuthority()).isEqualTo("origin");
        Assertions.assertThat((String)uri5.getPath()).isEqualTo("/main@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((String)uri5.getQuery()).isNull();
        URI uri6 = URI.create("git://origin/main@my-repo/path/to/some/place.txt");
        Assertions.assertThat((URI)uri6).isNotNull();
        Assertions.assertThat((String)uri6.getScheme()).isEqualTo("git");
        Assertions.assertThat((String)uri6.getAuthority()).isEqualTo("origin");
        Assertions.assertThat((String)uri6.getPath()).isEqualTo("/main@my-repo/path/to/some/place.txt");
        Assertions.assertThat((String)uri6.getQuery()).isNull();
    }
}

