/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.GetTreeFromRef;
import org.uberfire.java.nio.fs.jgit.util.commands.ListDiffs;
import org.uberfire.java.nio.fs.jgit.util.commands.Merge;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.MessageCommitInfo;

public class JGitMergeTest
extends AbstractTestInfra {
    private static final String SOURCE_GIT = "source/source";

    @Test
    public void testMergeFastForwardSuccessful() throws IOException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "main", "name", "name@example.com", "main-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "main", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", AbstractTestInfra.tempFile("temp2"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-2", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", AbstractTestInfra.tempFile("temp3"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-3", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", AbstractTestInfra.tempFile("temp4"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-4", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", AbstractTestInfra.tempFile("temp5"));
            }
        }).execute();
        new Merge(origin, "develop", "main").execute();
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "main").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void testMergeNonFastForwardSuccessful() throws IOException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "main", "name", "name@example.com", "main-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "main", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", AbstractTestInfra.tempFile("temp2"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-2", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", AbstractTestInfra.tempFile("temp3"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-3", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", AbstractTestInfra.tempFile("temp4"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-4", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", AbstractTestInfra.tempFile("temp5"));
            }
        }).execute();
        new Merge(origin, "develop", "main", true, false, (CommitInfo)MessageCommitInfo.createMergeMessage((String)"develop")).execute();
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "main").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void testMergeWithSquashSuccessful() throws IOException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "main", "name", "name@example.com", "main-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        RevCommit commitBeforeMerge = origin.getLastCommit("main");
        new CreateBranch((GitImpl)origin, "main", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", AbstractTestInfra.tempFile("temp2"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-2", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", AbstractTestInfra.tempFile("temp3"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-3", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", AbstractTestInfra.tempFile("temp4"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-4", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", AbstractTestInfra.tempFile("temp5"));
            }
        }).execute();
        new Merge(origin, "develop", "main", true, true, (CommitInfo)MessageCommitInfo.createMergeMessage((String)"develop")).execute();
        RevCommit commitAfterMerge = origin.getLastCommit("main");
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "main").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((List)result).isEmpty();
        Assertions.assertThat((Comparable)commitAfterMerge.getParent(0)).isEqualTo((Object)commitBeforeMerge);
    }

    @Test
    public void testMergeNoDiff() throws IOException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "main", "name", "name@example.com", "main-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "main", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        List commitIds = new Merge(origin, "develop", "main").execute();
        Assertions.assertThat((List)commitIds).isEmpty();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParametersNotNull() {
        new Merge(null, "develop", "main").execute();
    }

    @Test(expected=GitException.class)
    public void testTryToMergeNonexistentBranch() throws IOException {
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "main", "name", "name@example.com", "main-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.txt", AbstractTestInfra.tempFile("temp1"));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "main", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file2.txt", AbstractTestInfra.tempFile("temp2"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-2", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file3.txt", AbstractTestInfra.tempFile("temp3"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-3", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file4.txt", AbstractTestInfra.tempFile("temp4"));
            }
        }).execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-4", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file5.txt", AbstractTestInfra.tempFile("temp5"));
            }
        }).execute();
        new Merge(origin, "develop", "nonexistent").execute();
    }

    @Test(expected=GitException.class)
    public void testMergeBinaryInformationButHasConflicts() throws IOException {
        final byte[] contentA = this.loadImage("images/drools.png");
        final byte[] contentB = this.loadImage("images/jbpm.png");
        final byte[] contentC = this.loadImage("images/opta.png");
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "main", "name", "name@example.com", "main-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentA));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "main", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentB));
            }
        }).execute();
        new Commit(origin, "main", "name", "name@example.com", "main-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentC));
            }
        }).execute();
        new Merge(origin, "develop", "main").execute();
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "main").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void testMergeBinaryInformationSuccessful() throws IOException {
        final byte[] contentA = this.loadImage("images/drools.png");
        final byte[] contentB = this.loadImage("images/jbpm.png");
        File parentFolder = JGitMergeTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        Git origin = (Git)new CreateRepository(gitSource).execute().get();
        new Commit(origin, "main", "name", "name@example.com", "main-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentA));
            }
        }).execute();
        new CreateBranch((GitImpl)origin, "main", "develop").execute();
        new Commit(origin, "develop", "name", "name@example.com", "develop-1", null, null, false, (Map)new HashMap<String, File>(){
            {
                this.put("file1.jpg", JGitMergeTest.this.tempFile(contentB));
            }
        }).execute();
        new Merge(origin, "develop", "main").execute();
        List result = new ListDiffs(origin, new GetTreeFromRef(origin, "main").execute(), new GetTreeFromRef(origin, "develop").execute()).execute();
        Assertions.assertThat((List)result).isEmpty();
    }
}

