/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.fs.jgit.AbstractTestInfra;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class JGitConflictBranchesCheckerTest
extends AbstractTestInfra {
    private Git git;
    private static final String MAIN_BRANCH = "main";
    private static final String DEVELOP_BRANCH = "develop";
    private static final List<String> TXT_FILES = Stream.of("file0", "file1", "file2", "file3", "file4").collect(Collectors.toList());
    private static final String[] COMMON_TXT_LINES = new String[]{"Line1", "Line2", "Line3", "Line4"};

    @Before
    public void setup() throws IOException {
        File parentFolder = JGitConflictBranchesCheckerTest.createTempDirectory();
        File gitSource = new File(parentFolder, "source/source.git");
        this.git = (Git)new CreateRepository(gitSource).execute().get();
        JGitConflictBranchesCheckerTest.commit(this.git, MAIN_BRANCH, "Adding files into main", JGitConflictBranchesCheckerTest.content(TXT_FILES.get(0), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(0), COMMON_TXT_LINES)), JGitConflictBranchesCheckerTest.content(TXT_FILES.get(1), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(1), COMMON_TXT_LINES)), JGitConflictBranchesCheckerTest.content(TXT_FILES.get(2), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(2), COMMON_TXT_LINES)));
        new CreateBranch((GitImpl)this.git, MAIN_BRANCH, DEVELOP_BRANCH).execute();
    }

    @Test
    public void testReportConflictsAllFiles() throws IOException {
        JGitConflictBranchesCheckerTest.commit(this.git, DEVELOP_BRANCH, "Updating files", JGitConflictBranchesCheckerTest.content(TXT_FILES.get(1), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(1), "Line1", "Line2ChangedDev", "Line3", "Line4")), JGitConflictBranchesCheckerTest.content(TXT_FILES.get(2), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(2), "Line1", "Line2ChangedDev", "Line3", "Line4")));
        JGitConflictBranchesCheckerTest.commit(this.git, MAIN_BRANCH, "Updating files", JGitConflictBranchesCheckerTest.content(TXT_FILES.get(1), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(1), "Line1", "Line2ChangedMain", "Line3", "Line4")), JGitConflictBranchesCheckerTest.content(TXT_FILES.get(2), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(2), "Line1", "Line2ChangedMain", "Line3", "Line4")));
        List conflicts = this.git.conflictBranchesChecker(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)conflicts).isNotEmpty();
        Assertions.assertThat((List)conflicts).hasSize(2);
        Assertions.assertThat((String)((String)conflicts.get(0))).isEqualTo(TXT_FILES.get(1));
        Assertions.assertThat((String)((String)conflicts.get(1))).isEqualTo(TXT_FILES.get(2));
    }

    @Test
    public void testReportConflictsSomeFiles() throws IOException {
        JGitConflictBranchesCheckerTest.commit(this.git, DEVELOP_BRANCH, "Updating files", JGitConflictBranchesCheckerTest.content(TXT_FILES.get(1), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(1), "Line1", "Line2ChangedDev", "Line3", "Line4")), JGitConflictBranchesCheckerTest.content(TXT_FILES.get(2), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(2), "Line1", "Line2ChangedDev", "Line3", "Line4")));
        JGitConflictBranchesCheckerTest.commit(this.git, MAIN_BRANCH, "Updating files", JGitConflictBranchesCheckerTest.content(TXT_FILES.get(1), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(1), "Line1", "Line2ChangedMain", "Line3", "Line4")), JGitConflictBranchesCheckerTest.content(TXT_FILES.get(2), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(2), "Line1", "Line2", "Line3", "Line4ChangedMain")));
        List conflicts = this.git.conflictBranchesChecker(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)conflicts).isNotEmpty();
        Assertions.assertThat((List)conflicts).hasSize(1);
        Assertions.assertThat((String)((String)conflicts.get(0))).isEqualTo(TXT_FILES.get(1));
    }

    @Test
    public void testReportConflictsNoFiles() throws IOException {
        JGitConflictBranchesCheckerTest.commit(this.git, DEVELOP_BRANCH, "Updating files", JGitConflictBranchesCheckerTest.content(TXT_FILES.get(1), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(1), "Line1", "Line2ChangedDev", "Line3", "Line4")), JGitConflictBranchesCheckerTest.content(TXT_FILES.get(2), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(2), "Line1", "Line2ChangedDev", "Line3", "Line4")));
        JGitConflictBranchesCheckerTest.commit(this.git, MAIN_BRANCH, "Updating files", JGitConflictBranchesCheckerTest.content(TXT_FILES.get(1), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(1), "Line1", "Line2", "Line3", "Line4ChangedMain")), JGitConflictBranchesCheckerTest.content(TXT_FILES.get(2), JGitConflictBranchesCheckerTest.multiline(TXT_FILES.get(2), "Line1", "Line2", "Line3", "Line4ChangedMain")));
        List conflicts = this.git.conflictBranchesChecker(MAIN_BRANCH, DEVELOP_BRANCH);
        Assertions.assertThat((List)conflicts).isEmpty();
    }

    @Test(expected=GitException.class)
    public void testInvalidBranch() {
        this.git.conflictBranchesChecker(MAIN_BRANCH, "invalid-branch");
    }
}

