/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.manager.MemoizedFileSystemsSupplier;

public class JGitFileSystemsCacheDataStructure {
    public static Map<String, Supplier<JGitFileSystem>> create(final JGitFileSystemProviderConfiguration config) {
        return Collections.synchronizedMap(new LinkedHashMap<String, Supplier<JGitFileSystem>>(config.getJgitFileSystemsInstancesCache() + 1, 0.75f, true){
            private Integer removeEldestEntryIterations;
            {
                super(arg0, arg1, arg2);
                this.removeEldestEntryIterations = 0;
            }

            @Override
            public Supplier<JGitFileSystem> putIfAbsent(String key, Supplier<JGitFileSystem> value) {
                Supplier<JGitFileSystem> jGitFileSystemSupplier = super.putIfAbsent(key, value);
                if (this.size() > config.getJgitFileSystemsInstancesCache()) {
                    this.fitListToCacheSize();
                }
                return jGitFileSystemSupplier;
            }

            private void fitListToCacheSize() {
                ArrayList<String> itemsToRemove = new ArrayList<String>();
                int maxIterations = config.getJgitCacheOverflowCleanupSize();
                Object[] entries = this.entrySet().toArray();
                for (int i = this.size() - 1; i >= 0 && this.size() - i < maxIterations; --i) {
                    Map.Entry entry = (Map.Entry)entries[i];
                    JGitFileSystem targetFS = (JGitFileSystem)((MemoizedFileSystemsSupplier)entry.getValue()).get();
                    if (targetFS.hasBeenInUse()) continue;
                    itemsToRemove.add((String)entry.getKey());
                }
                itemsToRemove.forEach((? super T item) -> this.remove(item));
            }

            @Override
            public boolean removeEldestEntry(Map.Entry eldest) {
                if (this.removeEldestEntryIterations > config.getJgitRemoveEldestEntryIterations()) {
                    this.removeEldestEntryIterations = 0;
                    return false;
                }
                if (this.size() > config.getJgitFileSystemsInstancesCache()) {
                    JGitFileSystem targetFS = (JGitFileSystem)((MemoizedFileSystemsSupplier)eldest.getValue()).get();
                    if (targetFS.hasBeenInUse()) {
                        Integer n = this.removeEldestEntryIterations;
                        Integer n2 = this.removeEldestEntryIterations = Integer.valueOf(this.removeEldestEntryIterations + 1);
                        this.remove(eldest.getKey());
                        this.put((String)eldest.getKey(), (MemoizedFileSystemsSupplier)eldest.getValue());
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }
}

