/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.git;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;

public class KetchCustomReceivePack
extends ReceivePack {
    public KetchCustomReceivePack(Repository into) {
        super(into);
    }

    public void setAdvertisedRefs(Map<String, Ref> allRefs, Set<ObjectId> additionalHaves) {
        super.setAdvertisedRefs(allRefs, additionalHaves);
        Map refs = this.getAdvertisedRefs();
        if (this.getRepository().getRefDatabase() instanceof RefTreeDatabase) {
            RefDatabase bootstrap = ((RefTreeDatabase)this.getRepository().getRefDatabase()).getBootstrap();
            try {
                for (Map.Entry entry : bootstrap.getRefs("").entrySet()) {
                    refs.put((String)entry.getKey(), (Ref)entry.getValue());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void executeCommands() {
        if (this.getRepository().getRefDatabase() instanceof RefTreeDatabase) {
            List toApply = this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED);
            if (toApply.isEmpty()) {
                return;
            }
            BatchRefUpdate batch = ((RefTreeDatabase)this.getRepository().getRefDatabase()).getBootstrap().newBatchUpdate();
            batch.setAllowNonFastForwards(true);
            batch.setAtomic(false);
            batch.setRefLogIdent(this.getRefLogIdent());
            batch.setRefLogMessage("push", true);
            batch.addCommand((Collection)toApply);
            try {
                batch.setPushCertificate(this.getPushCertificate());
                batch.execute(this.getRevWalk(), (ProgressMonitor)NullProgressMonitor.INSTANCE);
            }
            catch (IOException err) {
                for (ReceiveCommand cmd : toApply) {
                    if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err.getMessage()));
                }
            }
        } else {
            super.executeCommands();
        }
    }
}

