/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.java.nio.EncodingUtil;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AttrHolder;
import org.uberfire.java.nio.base.AttrsStorage;
import org.uberfire.java.nio.base.AttrsStorageImpl;
import org.uberfire.java.nio.file.ClosedWatchServiceException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.AttributeView;

public abstract class AbstractPath<FS extends FileSystem>
implements Path,
AttrHolder {
    public static final Pattern WINDOWS_DRIVER = Pattern.compile("^/?[A-Z|a-z]+(:).*");
    public static final String DEFAULT_WINDOWS_DRIVER = "C:";
    protected final FS fs;
    protected final boolean usesWindowsFormat;
    protected final boolean isAbsolute;
    protected final byte[] path;
    protected final boolean isRoot;
    protected final boolean isRealPath;
    protected final boolean isNormalized;
    protected final String host;
    protected String toStringFormat;
    protected File file = null;
    protected final List<Pair<Integer, Integer>> offsets = new ArrayList<Pair<Integer, Integer>>();
    protected final AttrsStorage attrsStorage = new AttrsStorageImpl();

    protected abstract Path newPath(FS var1, String var2, String var3, boolean var4, boolean var5);

    protected abstract Path newRoot(FS var1, String var2, String var3, boolean var4);

    protected AbstractPath(FS fs, File file) {
        this((FileSystem)PortablePreconditions.checkNotNull((String)"fs", fs), ((File)PortablePreconditions.checkNotNull((String)"file", (Object)file)).getAbsolutePath(), "", false, false, true);
    }

    protected AbstractPath(FS fs, String path, String host, boolean isRoot, boolean isRealPath, boolean isNormalized) {
        int lastOffset;
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.fs = (FileSystem)PortablePreconditions.checkNotNull((String)"fs", fs);
        this.host = (String)PortablePreconditions.checkNotNull((String)"host", (Object)host);
        this.isRealPath = isRealPath;
        this.isNormalized = isNormalized;
        this.usesWindowsFormat = path.matches(".*\\\\.*");
        RootInfo rootInfo = this.setupRoot(fs, path, host, isRoot);
        this.path = rootInfo.path;
        PortablePreconditions.checkNotNull((String)"rootInfo", (Object)rootInfo);
        this.isAbsolute = rootInfo.isAbsolute;
        for (int i = lastOffset = rootInfo.startOffset; i < this.path.length; ++i) {
            byte b = this.path[i];
            if (b != this.getSeparator()) continue;
            this.offsets.add((Pair<Integer, Integer>)Pair.newPair((Object)lastOffset, (Object)i));
            lastOffset = ++i;
        }
        if (lastOffset < this.path.length) {
            this.offsets.add((Pair<Integer, Integer>)Pair.newPair((Object)lastOffset, (Object)this.path.length));
        }
        this.isRoot = rootInfo.isRoot;
    }

    protected abstract RootInfo setupRoot(FS var1, String var2, String var3, boolean var4);

    public FS getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public Path getRoot() {
        if (this.isRoot) {
            return this;
        }
        if (this.isAbsolute || !this.host.isEmpty()) {
            return this.newRoot(this.fs, this.substring(-1), this.host, this.isRealPath);
        }
        return null;
    }

    private String substring(int index) {
        byte[] result;
        if (index == -1) {
            result = new byte[((Integer)this.offsets.get(0).getK1()).intValue()];
            System.arraycopy(this.path, 0, result, 0, result.length);
        } else {
            Pair<Integer, Integer> offset = this.offsets.get(index);
            result = new byte[(Integer)offset.getK2() - (Integer)offset.getK1()];
            System.arraycopy(this.path, (Integer)offset.getK1(), result, 0, result.length);
        }
        return new String(result);
    }

    private String substring(int beginIndex, int endIndex) {
        int initPos = beginIndex == -1 ? 0 : (Integer)this.offsets.get(beginIndex).getK1();
        Pair<Integer, Integer> offsetEnd = this.offsets.get(endIndex);
        byte[] result = new byte[(Integer)offsetEnd.getK2() - initPos];
        System.arraycopy(this.path, initPos, result, 0, result.length);
        return new String(result);
    }

    @Override
    public Path getFileName() {
        if (this.getNameCount() == 0) {
            return null;
        }
        return this.getName(this.getNameCount() - 1);
    }

    @Override
    public Path getParent() {
        if (this.getNameCount() <= 0) {
            return null;
        }
        if (this.getNameCount() == 1) {
            return this.getRoot();
        }
        return this.newPath(this.fs, this.substring(-1, this.getNameCount() - 2), this.host, this.isRealPath, this.isNormalized);
    }

    @Override
    public int getNameCount() {
        return this.offsets.size();
    }

    @Override
    public Path getName(int index) throws IllegalArgumentException {
        if (this.isRoot && index > 0) {
            throw new IllegalArgumentException();
        }
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index >= this.offsets.size()) {
            throw new IllegalArgumentException();
        }
        return this.newPath(this.fs, this.substring(index), this.host, this.isRealPath, false);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) throws IllegalArgumentException {
        if (beginIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (beginIndex >= this.offsets.size()) {
            throw new IllegalArgumentException();
        }
        if (endIndex > this.offsets.size()) {
            throw new IllegalArgumentException();
        }
        if (beginIndex >= endIndex) {
            throw new IllegalArgumentException();
        }
        return this.newPath(this.fs, this.substring(beginIndex, endIndex - 1), this.host, this.isRealPath, false);
    }

    @Override
    public URI toUri() throws IOException, SecurityException {
        if (!this.isAbsolute()) {
            return this.toAbsolutePath().toUri();
        }
        if (this.fs.provider().isDefault() && !this.isRealPath) {
            return URI.create("default://" + this.host + this.toURIString());
        }
        return URI.create(this.fs.provider().getScheme() + "://" + this.host + this.toURIString());
    }

    private String toURIString() {
        if (this.usesWindowsFormat) {
            return this.encodePath("/" + this.toString().replace("\\", "/"));
        }
        return this.encodePath(new String(this.path));
    }

    private String encodePath(String s) {
        return EncodingUtil.encodePath(s);
    }

    @Override
    public Path toAbsolutePath() throws IOException, SecurityException {
        if (this.isAbsolute()) {
            return this;
        }
        if (this.host.isEmpty()) {
            return this.newPath(this.fs, FilenameUtils.normalize(this.defaultDirectory() + this.toString(), !this.usesWindowsFormat), this.host, this.isRealPath, true);
        }
        return this.newPath(this.fs, this.defaultDirectory() + this.toString(false), this.host, this.isRealPath, true);
    }

    protected abstract String defaultDirectory();

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException, SecurityException {
        if (this.isRealPath) {
            return this;
        }
        return this.newPath(this.fs, FilenameUtils.normalize(this.toString(), !this.usesWindowsFormat), this.host, true, true);
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < AbstractPath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < AbstractPath.this.getNameCount()) {
                    Path result = AbstractPath.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean startsWith(Path other) {
        int i;
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        if (!(other instanceof AbstractPath)) {
            return false;
        }
        AbstractPath that = (AbstractPath)other;
        if (that.path.length > this.path.length) {
            return false;
        }
        int thisOffsetCount = this.getNameCount();
        int thatOffsetCount = that.getNameCount();
        if (thatOffsetCount > thisOffsetCount) {
            return false;
        }
        if (thatOffsetCount == thisOffsetCount && this.path.length != that.path.length) {
            return false;
        }
        for (i = 0; i < thatOffsetCount; ++i) {
            Pair<Integer, Integer> o2;
            Pair<Integer, Integer> o1 = this.offsets.get(i);
            if (o1.equals(o2 = that.offsets.get(i))) continue;
            return false;
        }
        for (i = 0; i < that.path.length; ++i) {
            if (this.path[i] == that.path[i]) continue;
            return false;
        }
        return i >= this.path.length || this.path[i] == this.fs.getSeparator().charAt(0);
    }

    @Override
    public boolean startsWith(String other) throws InvalidPathException {
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        if (!(other instanceof AbstractPath)) {
            return false;
        }
        AbstractPath that = (AbstractPath)other;
        int thatLen = that.path.length;
        int thisLen = this.path.length;
        if (thatLen > thisLen) {
            return false;
        }
        if (thisLen > 0 && thatLen == 0) {
            return false;
        }
        if (that.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        int thisOffsetCount = this.getNameCount();
        int thatOffsetCount = that.getNameCount();
        if (thatOffsetCount > thisOffsetCount) {
            return false;
        }
        if (thatOffsetCount == thisOffsetCount) {
            if (thisOffsetCount == 0) {
                return true;
            }
            int expectedLen = thisLen;
            if (this.isAbsolute() && !that.isAbsolute()) {
                --expectedLen;
            }
            if (thatLen != expectedLen) {
                return false;
            }
        } else if (that.isAbsolute()) {
            return false;
        }
        int thisPos = (Integer)this.offsets.get(thisOffsetCount - thatOffsetCount).getK1();
        int thatPos = (Integer)that.offsets.get(0).getK1();
        if (thatLen - thatPos != thisLen - thisPos) {
            return false;
        }
        while (thatPos < thatLen) {
            if (this.path[thisPos++] == that.path[thatPos++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) throws InvalidPathException {
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public Path normalize() {
        if (this.isNormalized) {
            return this;
        }
        return this.newPath(this.fs, FilenameUtils.normalize(new String(this.path), !this.usesWindowsFormat), this.host, this.isRealPath, true);
    }

    @Override
    public Path resolve(Path other) {
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        if (other.isAbsolute()) {
            return other;
        }
        if (other.toString().trim().length() == 0) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new String(this.path));
        if (this.path[this.path.length - 1] != this.getSeparator()) {
            sb.append(this.getSeparator());
        }
        sb.append(other.toString());
        return this.newPath(this.fs, sb.toString(), this.host, this.isRealPath, false);
    }

    @Override
    public Path resolve(String other) throws InvalidPathException {
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        return this.resolve(this.newPath(this.fs, other, this.host, this.isRealPath, false));
    }

    @Override
    public Path resolveSibling(Path other) {
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        Path parent = this.getParent();
        if (parent == null || other.isAbsolute()) {
            return other;
        }
        return parent.resolve(other);
    }

    @Override
    public Path resolveSibling(String other) throws InvalidPathException {
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        return this.resolveSibling(this.newPath(this.fs, other, this.host, this.isRealPath, false));
    }

    @Override
    public Path relativize(Path otherx) throws IllegalArgumentException {
        int i;
        PortablePreconditions.checkNotNull((String)"otherx", (Object)otherx);
        AbstractPath other = (AbstractPath)Preconditions.checkInstanceOf((String)"otherx", (Object)otherx, AbstractPath.class);
        if (this.equals(other)) {
            return this.emptyPath();
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (this.isAbsolute() && !this.getRoot().equals(other.getRoot())) {
            throw new IllegalArgumentException();
        }
        if (this.path.length == 0) {
            return other;
        }
        int n = this.getNameCount() > other.getNameCount() ? other.getNameCount() : this.getNameCount();
        for (i = 0; i < n && this.getName(i).equals(other.getName(i)); ++i) {
        }
        int numberOfDots = this.getNameCount() - i;
        if (numberOfDots == 0 && i < other.getNameCount()) {
            return other.subpath(i, other.getNameCount());
        }
        StringBuilder sb = new StringBuilder();
        while (numberOfDots > 0) {
            sb.append("..");
            if (numberOfDots > 1) {
                sb.append(this.getSeparator());
            }
            --numberOfDots;
        }
        if (i < other.getNameCount()) {
            if (sb.length() > 0) {
                sb.append(this.getSeparator());
            }
            sb.append(((AbstractPath)other.subpath(i, other.getNameCount())).toString(false));
        }
        return this.newPath(this.fs, sb.toString(), this.host, this.isRealPath, false);
    }

    private Path emptyPath() {
        return this.newPath(this.fs, "", this.host, this.isRealPath, true);
    }

    @Override
    public int compareTo(Path other) {
        PortablePreconditions.checkNotNull((String)"other", (Object)other);
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws UnsupportedOperationException, IllegalArgumentException, ClosedWatchServiceException, IOException, SecurityException {
        return watcher.poll();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws UnsupportedOperationException, IllegalArgumentException, ClosedWatchServiceException, IOException, SecurityException {
        return watcher.poll();
    }

    public String toString() {
        if (this.toStringFormat == null) {
            this.toStringFormat = this.toString(false);
        }
        return this.toStringFormat;
    }

    public String toString(boolean addHost) {
        if (!addHost || this.host.isEmpty()) {
            return new String(this.path);
        }
        if (this.isAbsolute) {
            return this.host + new String(this.path);
        }
        return this.host + ":" + new String(this.path);
    }

    private char getSeparator() {
        if (this.usesWindowsFormat) {
            return '\\';
        }
        return this.fs.getSeparator().toCharArray()[0];
    }

    public void clearCache() {
        this.file = null;
        this.attrsStorage.clear();
    }

    public boolean equals(Object o) {
        PortablePreconditions.checkNotNull((String)"o", (Object)o);
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractPath)) {
            return false;
        }
        AbstractPath other = (AbstractPath)o;
        if (this.isAbsolute != other.isAbsolute) {
            return false;
        }
        if (this.isRealPath != other.isRealPath) {
            return false;
        }
        if (this.isRoot != other.isRoot) {
            return false;
        }
        if (this.usesWindowsFormat != other.usesWindowsFormat) {
            return false;
        }
        if (!this.host.equals(other.host)) {
            return false;
        }
        if (!this.fs.equals(other.fs)) {
            return false;
        }
        if (!this.usesWindowsFormat && !Arrays.equals(this.path, other.path)) {
            return false;
        }
        return !this.usesWindowsFormat || new String(this.path).equalsIgnoreCase(new String(other.path));
    }

    public int hashCode() {
        int result = this.fs != null ? this.fs.hashCode() : 0;
        result = 31 * result + (this.usesWindowsFormat ? 1 : 0);
        result = 31 * result + (this.isAbsolute ? 1 : 0);
        result = !this.usesWindowsFormat ? 31 * result + (this.path != null ? Arrays.hashCode(this.path) : 0) : 31 * result + (this.path != null ? new String(this.path).toLowerCase().hashCode() : 0);
        result = 31 * result + (this.isRoot ? 1 : 0);
        result = 31 * result + (this.isRealPath ? 1 : 0);
        result = 31 * result + (this.isNormalized ? 1 : 0);
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isRealPath() {
        return this.isRealPath;
    }

    @Override
    public AttrsStorage getAttrStorage() {
        return this.attrsStorage;
    }

    @Override
    public <V extends AttributeView> void addAttrView(V view) {
        this.attrsStorage.addAttrView(view);
    }

    @Override
    public <V extends AttributeView> V getAttrView(Class<V> type) {
        return this.attrsStorage.getAttrView(type);
    }

    @Override
    public <V extends AttributeView> V getAttrView(String name) {
        return this.attrsStorage.getAttrView(name);
    }

    public static class RootInfo {
        private final int startOffset;
        private final boolean isAbsolute;
        private final boolean isRoot;
        private final byte[] path;

        public RootInfo(int startOffset, boolean isAbsolute, boolean isRoot, byte[] path) {
            this.startOffset = startOffset;
            this.isAbsolute = isAbsolute;
            this.isRoot = isRoot;
            this.path = path;
        }
    }
}

