/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.io.File;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class GeneralPathValidationTest {
    final FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
    }

    @Test
    public void createNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathImpl.create(null, (String)"/path/to/file.txt", (boolean)false)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'fs' should be not null!");
    }

    @Test
    public void createNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathImpl.create((FileSystem)this.fs, null, (boolean)false)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void newFromFileNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathImpl.newFromFile(null, (File)new File(""))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'fs' should be not null!");
    }

    @Test
    public void newFromFileNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathImpl.newFromFile((FileSystem)this.fs, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'file' should be not null!");
    }

    @Test
    public void getNameNegative() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$getNameNegative$4((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid index argument: -1");
    }

    @Test
    public void subpathInvaligRange1() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$subpathInvaligRange1$5((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid beginIndex argument: -1");
    }

    @Test
    public void subpathInvaligRange2() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$subpathInvaligRange2$6((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid beginIndex argument: 5");
    }

    @Test
    public void subpathInvaligRange3() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$subpathInvaligRange3$7((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid endIndex argument: 7");
    }

    @Test
    public void subpathInvaligRange4() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$subpathInvaligRange4$8((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid arguments, beginIndex must be < endIndex, but they were: bI 2, eI 1");
    }

    @Test
    public void startsWith() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$startsWith$9((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void startsWithPath() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$startsWithPath$10((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void endsWith() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$endsWith$11((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void endsWithPath() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$endsWithPath$12((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void resolve() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$resolve$13((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void resolvePath() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$resolvePath$14((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void resolveSibling() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$resolveSibling$15((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void resolveSiblingPath() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$resolveSiblingPath$16((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void relativize() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$relativize$17((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'otherx' should be not null!");
    }

    @Test
    public void compareTo() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$compareTo$18((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void checkEquals() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathValidationTest.lambda$checkEquals$19((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'o' should be not null!");
    }

    private static /* synthetic */ void lambda$checkEquals$19(Path path) throws Throwable {
        path.equals(null);
    }

    private static /* synthetic */ void lambda$compareTo$18(Path path) throws Throwable {
        path.compareTo(null);
    }

    private static /* synthetic */ void lambda$relativize$17(Path path) throws Throwable {
        path.relativize(null);
    }

    private static /* synthetic */ void lambda$resolveSiblingPath$16(Path path) throws Throwable {
        path.resolveSibling((Path)null);
    }

    private static /* synthetic */ void lambda$resolveSibling$15(Path path) throws Throwable {
        path.resolveSibling((String)null);
    }

    private static /* synthetic */ void lambda$resolvePath$14(Path path) throws Throwable {
        path.resolve((Path)null);
    }

    private static /* synthetic */ void lambda$resolve$13(Path path) throws Throwable {
        path.resolve((String)null);
    }

    private static /* synthetic */ void lambda$endsWithPath$12(Path path) throws Throwable {
        path.endsWith((Path)null);
    }

    private static /* synthetic */ void lambda$endsWith$11(Path path) throws Throwable {
        path.endsWith((String)null);
    }

    private static /* synthetic */ void lambda$startsWithPath$10(Path path) throws Throwable {
        path.startsWith((Path)null);
    }

    private static /* synthetic */ void lambda$startsWith$9(Path path) throws Throwable {
        path.startsWith((String)null);
    }

    private static /* synthetic */ void lambda$subpathInvaligRange4$8(Path path) throws Throwable {
        path.subpath(2, 1);
    }

    private static /* synthetic */ void lambda$subpathInvaligRange3$7(Path path) throws Throwable {
        path.subpath(0, 7);
    }

    private static /* synthetic */ void lambda$subpathInvaligRange2$6(Path path) throws Throwable {
        path.subpath(5, 7);
    }

    private static /* synthetic */ void lambda$subpathInvaligRange1$5(Path path) throws Throwable {
        path.subpath(-1, 1);
    }

    private static /* synthetic */ void lambda$getNameNegative$4(Path path) throws Throwable {
        path.getName(-1);
    }
}

