/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.shared.impl;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.annotations.FallbackImplementation;
import org.uberfire.ext.preferences.shared.PreferenceScopeTypes;
import org.uberfire.ext.preferences.shared.UsernameProvider;
import org.uberfire.ext.preferences.shared.impl.DefaultScopes;
import org.uberfire.ext.preferences.shared.impl.exception.InvalidPreferenceScopeException;

@ApplicationScoped
@FallbackImplementation
public class DefaultPreferenceScopeTypes
implements PreferenceScopeTypes {
    private Map<String, DefaultKey> defaultKeyByType;
    private UsernameProvider usernameProvider;

    protected DefaultPreferenceScopeTypes() {
    }

    @Inject
    public DefaultPreferenceScopeTypes(UsernameProvider usernameProvider) {
        this.usernameProvider = usernameProvider;
        this.defaultKeyByType = new HashMap<String, DefaultKey>();
        this.defaultKeyByType.put(DefaultScopes.ALL_USERS.type(), DefaultScopes.ALL_USERS::type);
        this.defaultKeyByType.put(DefaultScopes.ENTIRE_APPLICATION.type(), DefaultScopes.ENTIRE_APPLICATION::type);
        this.defaultKeyByType.put(DefaultScopes.COMPONENT.type(), null);
        this.defaultKeyByType.put(DefaultScopes.USER.type(), () -> ((UsernameProvider)usernameProvider).get());
    }

    @Override
    public boolean typeRequiresKey(String type) throws InvalidPreferenceScopeException {
        this.validateType(type);
        return this.defaultKeyByType.get(type) == null;
    }

    @Override
    public String getDefaultKeyFor(String type) throws InvalidPreferenceScopeException {
        this.validateType(type);
        DefaultKey defaultKey = this.defaultKeyByType.get(type);
        if (defaultKey == null) {
            throw new InvalidPreferenceScopeException("The type " + type + " does not have a default key.");
        }
        return defaultKey.get();
    }

    protected void validateType(String type) throws InvalidPreferenceScopeException {
        if (this.isEmpty(type)) {
            throw new InvalidPreferenceScopeException("Type must be a non empty string.");
        }
        if (!this.defaultKeyByType.containsKey(type)) {
            throw new InvalidPreferenceScopeException("Invalid preference scope type.");
        }
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    protected static interface DefaultKey {
        public String get();
    }
}

