/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.PreferenceScopeTypes;
import org.uberfire.preferences.shared.UsernameProvider;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeTypes;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopesForTests;
import org.uberfire.preferences.shared.impl.PreferenceScopeFactoryImpl;
import org.uberfire.preferences.shared.impl.UsernameProviderMock;
import org.uberfire.rpc.SessionInfo;

public class DefaultPreferenceScopeResolutionStrategyTest {
    private PreferenceScopeFactory scopesBuilder;
    private PreferenceScopeTypes scopeTypes;
    private DefaultPreferenceScopeResolutionStrategy defaultPreferenceScopeResolutionStrategy;

    @Before
    public void setup() {
        SessionInfoMock sessionInfo = new SessionInfoMock("my-user");
        this.scopeTypes = new DefaultPreferenceScopeTypes((UsernameProvider)new UsernameProviderMock((SessionInfo)sessionInfo));
        this.scopesBuilder = new PreferenceScopeFactoryImpl(this.scopeTypes);
        this.defaultPreferenceScopeResolutionStrategy = new DefaultPreferenceScopeResolutionStrategy(this.scopesBuilder, null);
    }

    @Test
    public void defaultOrderTest() {
        List order = this.defaultPreferenceScopeResolutionStrategy.getInfo().order();
        Assert.assertEquals((long)2L, (long)order.size());
        PreferenceScope secondScope = (PreferenceScope)order.get(0);
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.userScopeType, (Object)secondScope.type());
        Assert.assertEquals((Object)"my-user", (Object)secondScope.key());
        PreferenceScope secondScopeChild = secondScope.childScope();
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeType, (Object)secondScopeChild.type());
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeKey, (Object)secondScopeChild.key());
        Assert.assertNull((Object)secondScopeChild.childScope());
        PreferenceScope fourthScope = (PreferenceScope)order.get(1);
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersScopeType, (Object)fourthScope.type());
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersScopeKey, (Object)fourthScope.key());
        PreferenceScope fourthScopeChild = fourthScope.childScope();
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeType, (Object)fourthScopeChild.type());
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeKey, (Object)fourthScopeChild.key());
        Assert.assertNull((Object)fourthScopeChild.childScope());
    }

    @Test
    public void orderWithComponentScopeTest() {
        this.defaultPreferenceScopeResolutionStrategy = new DefaultPreferenceScopeResolutionStrategy(this.scopesBuilder, "my-component");
        List order = this.defaultPreferenceScopeResolutionStrategy.getInfo().order();
        Assert.assertEquals((long)4L, (long)order.size());
        PreferenceScope firstScope = (PreferenceScope)order.get(0);
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.userScopeType, (Object)firstScope.type());
        Assert.assertEquals((Object)"my-user", (Object)firstScope.key());
        PreferenceScope firstScopeChild = firstScope.childScope();
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.componentScopeType, (Object)firstScopeChild.type());
        Assert.assertEquals((Object)"my-component", (Object)firstScopeChild.key());
        Assert.assertNull((Object)firstScopeChild.childScope());
        PreferenceScope secondScope = (PreferenceScope)order.get(1);
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.userScopeType, (Object)secondScope.type());
        Assert.assertEquals((Object)"my-user", (Object)secondScope.key());
        PreferenceScope secondScopeChild = secondScope.childScope();
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeType, (Object)secondScopeChild.type());
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeKey, (Object)secondScopeChild.key());
        Assert.assertNull((Object)secondScopeChild.childScope());
        PreferenceScope thirdScope = (PreferenceScope)order.get(2);
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersScopeType, (Object)thirdScope.type());
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersScopeKey, (Object)thirdScope.key());
        PreferenceScope thirdScopeChild = thirdScope.childScope();
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.componentScopeType, (Object)thirdScopeChild.type());
        Assert.assertEquals((Object)"my-component", (Object)thirdScopeChild.key());
        Assert.assertNull((Object)thirdScopeChild.childScope());
        PreferenceScope fourthScope = (PreferenceScope)order.get(3);
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersScopeType, (Object)fourthScope.type());
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersScopeKey, (Object)fourthScope.key());
        PreferenceScope fourthScopeChild = fourthScope.childScope();
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeType, (Object)fourthScopeChild.type());
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeKey, (Object)fourthScopeChild.key());
        Assert.assertNull((Object)fourthScopeChild.childScope());
    }

    @Test
    public void defaultScopeTest() {
        PreferenceScope defaultScope = this.defaultPreferenceScopeResolutionStrategy.getInfo().defaultScope();
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.userScopeType, (Object)defaultScope.type());
        Assert.assertEquals((Object)"my-user", (Object)defaultScope.key());
        PreferenceScope defaultScopeChild = defaultScope.childScope();
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeType, (Object)defaultScopeChild.type());
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.entireApplicationScopeKey, (Object)defaultScopeChild.key());
        Assert.assertNull((Object)defaultScopeChild.childScope());
    }
}

